/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pvm.runtime.operation;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.pvm.delegate.SubProcessActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.operation.PvmAtomicOperationActivityInstanceEnd;

public class PvmAtomicOperationProcessEnd
extends PvmAtomicOperationActivityInstanceEnd {
    private static Logger log = Logger.getLogger(PvmAtomicOperationProcessEnd.class.getName());

    @Override
    protected ScopeImpl getScope(PvmExecutionImpl execution) {
        return execution.getProcessDefinition();
    }

    @Override
    protected String getEventName() {
        return "end";
    }

    @Override
    protected void eventNotificationsCompleted(PvmExecutionImpl execution) {
        super.eventNotificationsCompleted(execution);
        PvmExecutionImpl superExecution = execution.getSuperExecution();
        SubProcessActivityBehavior subProcessActivityBehavior = null;
        if (superExecution != null) {
            ActivityImpl activity = superExecution.getActivity();
            subProcessActivityBehavior = (SubProcessActivityBehavior)activity.getActivityBehavior();
            try {
                subProcessActivityBehavior.completing(superExecution, execution);
            }
            catch (RuntimeException e) {
                log.log(Level.SEVERE, "Error while completing sub process of execution " + execution, e);
                throw e;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error while completing sub process of execution " + execution, e);
                throw new ProcessEngineException("Error while completing sub process of execution " + execution, e);
            }
        }
        execution.destroy();
        execution.remove();
        if (superExecution != null) {
            superExecution.setSubProcessInstance(null);
            try {
                subProcessActivityBehavior.completed(superExecution);
            }
            catch (RuntimeException e) {
                log.log(Level.SEVERE, "Error while completing sub process of execution " + execution, e);
                throw e;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error while completing sub process of execution " + execution, e);
                throw new ProcessEngineException("Error while completing sub process of execution " + execution, e);
            }
        }
    }

    @Override
    public String getCanonicalName() {
        return "process-end";
    }
}

