/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.scripting;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.scripting.ScriptBindingsFactory;

public class ScriptingEngines {
    private static Logger LOG = Logger.getLogger(ScriptingEngines.class.getName());
    public static final String DEFAULT_SCRIPTING_LANGUAGE = "juel";
    public static final String GROOVY_SCRIPTING_LANGUAGE = "groovy";
    private final ScriptEngineManager scriptEngineManager;
    protected ScriptBindingsFactory scriptBindingsFactory;
    protected Map<String, ScriptEngine> cachedEngines = new HashMap<String, ScriptEngine>();
    protected boolean enableScriptEngineCaching = true;

    public ScriptingEngines(ScriptBindingsFactory scriptBindingsFactory) {
        this(new ScriptEngineManager());
        this.scriptBindingsFactory = scriptBindingsFactory;
    }

    public ScriptingEngines(ScriptEngineManager scriptEngineManager) {
        this.scriptEngineManager = scriptEngineManager;
    }

    public void setEnableScriptEngineCaching(boolean cacheScriptEngines) {
        this.enableScriptEngineCaching = cacheScriptEngines;
    }

    public boolean isEnableScriptEngineCaching() {
        return this.enableScriptEngineCaching;
    }

    public ScriptingEngines addScriptEngineFactory(ScriptEngineFactory scriptEngineFactory) {
        this.scriptEngineManager.registerEngineName(scriptEngineFactory.getEngineName(), scriptEngineFactory);
        return this;
    }

    public void setScriptEngineFactories(List<ScriptEngineFactory> scriptEngineFactories) {
        if (scriptEngineFactories != null) {
            for (ScriptEngineFactory scriptEngineFactory : scriptEngineFactories) {
                this.scriptEngineManager.registerEngineName(scriptEngineFactory.getEngineName(), scriptEngineFactory);
            }
        }
    }

    public Object evaluate(String script, String language, VariableScope variableScope) {
        ScriptEngine scriptEngine = this.getScriptEngineForLanguage(language);
        Bindings bindings = this.createBindings(variableScope, scriptEngine.createBindings());
        try {
            LOG.log(Level.FINE, "Evaluationg un-compiled script using {0} script engine ", language);
            return scriptEngine.eval(script, bindings);
        }
        catch (ScriptException e) {
            throw new ProcessEngineException("problem evaluating script: " + e.getMessage(), e);
        }
    }

    public Object evaluate(CompiledScript script, String language, VariableScope variableScope) {
        ScriptEngine scriptEngine = this.getScriptEngineForLanguage(language);
        Bindings bindings = this.createBindings(variableScope, scriptEngine.createBindings());
        try {
            LOG.log(Level.FINE, "Evaluationg compiled script using {0} script engine ", language);
            return script.eval(bindings);
        }
        catch (ScriptException e) {
            throw new ProcessEngineException("problem evaluating script: " + e.getMessage(), e);
        }
    }

    public CompiledScript compile(String script, String language) {
        ScriptEngine scriptEngine = this.getScriptEngineForLanguage(language);
        if (scriptEngine instanceof Compilable) {
            Compilable compilingEngine = (Compilable)((Object)scriptEngine);
            try {
                CompiledScript compiledScript = compilingEngine.compile(script);
                LOG.log(Level.FINE, "Compiled script using {0} script engine ", language);
                return compiledScript;
            }
            catch (ScriptException e) {
                throw new ProcessEngineException("problem while compiling script: " + e.getMessage(), e);
            }
        }
        return null;
    }

    public ScriptEngine getScriptEngineForLanguage(String language) {
        if (language != null) {
            language = language.toLowerCase();
        }
        ScriptEngine scriptEngine = null;
        scriptEngine = this.enableScriptEngineCaching ? this.getCachedScriptEngine(language) : this.scriptEngineManager.getEngineByName(language);
        if (scriptEngine == null) {
            throw new ProcessEngineException("Can't find scripting engine for '" + language + "'");
        }
        return scriptEngine;
    }

    protected ScriptEngine getCachedScriptEngine(String language) {
        ScriptEngine scriptEngine = this.cachedEngines.get(language);
        if (scriptEngine == null && (scriptEngine = this.scriptEngineManager.getEngineByName(language)) != null) {
            if (GROOVY_SCRIPTING_LANGUAGE.equals(language)) {
                this.configureGroovyScriptEngine(scriptEngine);
            }
            if (this.isCachable(scriptEngine)) {
                this.cachedEngines.put(language, scriptEngine);
            }
        }
        return scriptEngine;
    }

    protected boolean isCachable(ScriptEngine scriptEngine) {
        Object threadingParameter = scriptEngine.getFactory().getParameter("THREADING");
        return threadingParameter != null;
    }

    protected void configureGroovyScriptEngine(ScriptEngine scriptEngine) {
        scriptEngine.getContext().setAttribute("#jsr223.groovy.engine.keep.globals", "weak", 100);
    }

    protected Bindings createBindings(VariableScope variableScope, Bindings engineBindings) {
        return this.scriptBindingsFactory.createBindings(variableScope, engineBindings);
    }

    public ScriptBindingsFactory getScriptBindingsFactory() {
        return this.scriptBindingsFactory;
    }

    public void setScriptBindingsFactory(ScriptBindingsFactory scriptBindingsFactory) {
        this.scriptBindingsFactory = scriptBindingsFactory;
    }
}

