/* Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.camunda.bpm.engine.impl.bpmn.listener;

import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.el.Expression;
import org.camunda.bpm.engine.impl.scripting.ExecutableScript;
import org.camunda.bpm.engine.impl.scripting.ScriptFactory;
import org.camunda.bpm.engine.impl.scripting.env.ScriptingEnvironment;

import java.io.StringReader;

public class ScriptTaskListener implements TaskListener {
	private Expression script;

	private Expression language = null;

	private Expression resultVariable = null;

	public void notify(DelegateTask delegateTask) {
		if (script == null) {
			throw new IllegalArgumentException("The field 'script' should be set on the TaskListener");
		}

		if (language == null) {
			throw new IllegalArgumentException("The field 'language' should be set on the TaskListener");
		}

		ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
    ScriptingEnvironment scriptEnv = processEngineConfiguration.getScriptingEnvironment();
    ScriptFactory scriptFactory = processEngineConfiguration.getScriptFactory();
    ExecutableScript executableScript = scriptFactory.createScript(new StringReader(script.getExpressionText()), language.getExpressionText());

    Object result = scriptEnv.execute(executableScript, delegateTask);

		if (resultVariable != null) {
			delegateTask.setVariable(resultVariable.getExpressionText(), result);
		}
	}

	public void setScript(Expression script) {
		this.script = script;
	}

	public void setLanguage(Expression language) {
		this.language = language;
	}

	public void setResultVariable(Expression resultVariable) {
		this.resultVariable = resultVariable;
	}
}
