/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.application.impl.deployment.parser;

import java.net.URL;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.camunda.bpm.application.impl.metadata.ProcessesXmlParser;
import org.camunda.bpm.application.impl.metadata.spi.ProcessArchiveXml;
import org.camunda.bpm.application.impl.metadata.spi.ProcessesXml;
import org.camunda.bpm.container.impl.metadata.spi.ProcessEngineXml;
import org.camunda.bpm.engine.ProcessEngineException;

public class ProcessesXmlParserTest
extends TestCase {
    private ProcessesXmlParser parser;

    protected void setUp() throws Exception {
        this.parser = new ProcessesXmlParser();
        super.setUp();
    }

    protected URL getStreamUrl(String filename) {
        return ProcessesXmlParserTest.class.getResource(filename);
    }

    public void testParseProcessesXmlOneEngine() {
        ProcessesXml processesXml = this.parser.createParse().sourceUrl(this.getStreamUrl("process_xml_one_engine.xml")).execute().getProcessesXml();
        ProcessesXmlParserTest.assertNotNull((Object)processesXml);
        ProcessesXmlParserTest.assertEquals((int)1, (int)processesXml.getProcessEngines().size());
        ProcessesXmlParserTest.assertEquals((int)0, (int)processesXml.getProcessArchives().size());
        ProcessEngineXml engineXml = (ProcessEngineXml)processesXml.getProcessEngines().get(0);
        ProcessesXmlParserTest.assertEquals((String)"default", (String)engineXml.getName());
        ProcessesXmlParserTest.assertEquals((String)"default", (String)engineXml.getJobAcquisitionName());
        ProcessesXmlParserTest.assertEquals((String)"configuration", (String)engineXml.getConfigurationClass());
        ProcessesXmlParserTest.assertEquals((String)"datasource", (String)engineXml.getDatasource());
        Map properties = engineXml.getProperties();
        ProcessesXmlParserTest.assertNotNull((Object)properties);
        ProcessesXmlParserTest.assertEquals((int)2, (int)properties.size());
        ProcessesXmlParserTest.assertEquals((String)"value1", (String)((String)properties.get("prop1")));
        ProcessesXmlParserTest.assertEquals((String)"value2", (String)((String)properties.get("prop2")));
    }

    public void testParseProcessesXmlTwoEngines() {
        ProcessesXml processesXml = this.parser.createParse().sourceUrl(this.getStreamUrl("process_xml_two_engines.xml")).execute().getProcessesXml();
        ProcessesXmlParserTest.assertNotNull((Object)processesXml);
        ProcessesXmlParserTest.assertEquals((int)2, (int)processesXml.getProcessEngines().size());
        ProcessesXmlParserTest.assertEquals((int)0, (int)processesXml.getProcessArchives().size());
        ProcessEngineXml engineXml1 = (ProcessEngineXml)processesXml.getProcessEngines().get(0);
        ProcessesXmlParserTest.assertEquals((String)"engine1", (String)engineXml1.getName());
        ProcessesXmlParserTest.assertEquals((String)"configuration", (String)engineXml1.getConfigurationClass());
        ProcessesXmlParserTest.assertEquals((String)"datasource", (String)engineXml1.getDatasource());
        Map properties1 = engineXml1.getProperties();
        ProcessesXmlParserTest.assertNotNull((Object)properties1);
        ProcessesXmlParserTest.assertEquals((int)2, (int)properties1.size());
        ProcessesXmlParserTest.assertEquals((String)"value1", (String)((String)properties1.get("prop1")));
        ProcessesXmlParserTest.assertEquals((String)"value2", (String)((String)properties1.get("prop2")));
        ProcessEngineXml engineXml2 = (ProcessEngineXml)processesXml.getProcessEngines().get(1);
        ProcessesXmlParserTest.assertEquals((String)"engine2", (String)engineXml2.getName());
        ProcessesXmlParserTest.assertEquals((String)"configuration", (String)engineXml2.getConfigurationClass());
        ProcessesXmlParserTest.assertEquals((String)"datasource", (String)engineXml2.getDatasource());
        Map properties2 = engineXml2.getProperties();
        ProcessesXmlParserTest.assertNotNull((Object)properties2);
        ProcessesXmlParserTest.assertEquals((int)0, (int)properties2.size());
    }

    public void testParseProcessesXmlOneArchive() {
        ProcessesXml processesXml = this.parser.createParse().sourceUrl(this.getStreamUrl("process_xml_one_archive.xml")).execute().getProcessesXml();
        ProcessesXmlParserTest.assertNotNull((Object)processesXml);
        ProcessesXmlParserTest.assertEquals((int)0, (int)processesXml.getProcessEngines().size());
        ProcessesXmlParserTest.assertEquals((int)1, (int)processesXml.getProcessArchives().size());
        ProcessArchiveXml archiveXml1 = (ProcessArchiveXml)processesXml.getProcessArchives().get(0);
        ProcessesXmlParserTest.assertEquals((String)"pa1", (String)archiveXml1.getName());
        ProcessesXmlParserTest.assertEquals((String)"default", (String)archiveXml1.getProcessEngineName());
        List resourceNames = archiveXml1.getProcessResourceNames();
        ProcessesXmlParserTest.assertEquals((int)2, (int)resourceNames.size());
        ProcessesXmlParserTest.assertEquals((String)"process1.bpmn", (String)((String)resourceNames.get(0)));
        ProcessesXmlParserTest.assertEquals((String)"process2.bpmn", (String)((String)resourceNames.get(1)));
        Map properties1 = archiveXml1.getProperties();
        ProcessesXmlParserTest.assertNotNull((Object)properties1);
        ProcessesXmlParserTest.assertEquals((int)2, (int)properties1.size());
        ProcessesXmlParserTest.assertEquals((String)"value1", (String)((String)properties1.get("prop1")));
        ProcessesXmlParserTest.assertEquals((String)"value2", (String)((String)properties1.get("prop2")));
    }

    public void testParseProcessesXmlTwoArchives() {
        ProcessesXml processesXml = this.parser.createParse().sourceUrl(this.getStreamUrl("process_xml_two_archives.xml")).execute().getProcessesXml();
        ProcessesXmlParserTest.assertNotNull((Object)processesXml);
        ProcessesXmlParserTest.assertEquals((int)0, (int)processesXml.getProcessEngines().size());
        ProcessesXmlParserTest.assertEquals((int)2, (int)processesXml.getProcessArchives().size());
        ProcessArchiveXml archiveXml1 = (ProcessArchiveXml)processesXml.getProcessArchives().get(0);
        ProcessesXmlParserTest.assertEquals((String)"pa1", (String)archiveXml1.getName());
        ProcessesXmlParserTest.assertEquals((String)"default", (String)archiveXml1.getProcessEngineName());
        List resourceNames = archiveXml1.getProcessResourceNames();
        ProcessesXmlParserTest.assertEquals((int)2, (int)resourceNames.size());
        ProcessesXmlParserTest.assertEquals((String)"process1.bpmn", (String)((String)resourceNames.get(0)));
        ProcessesXmlParserTest.assertEquals((String)"process2.bpmn", (String)((String)resourceNames.get(1)));
        Map properties1 = archiveXml1.getProperties();
        ProcessesXmlParserTest.assertNotNull((Object)properties1);
        ProcessesXmlParserTest.assertEquals((int)2, (int)properties1.size());
        ProcessesXmlParserTest.assertEquals((String)"value1", (String)((String)properties1.get("prop1")));
        ProcessesXmlParserTest.assertEquals((String)"value2", (String)((String)properties1.get("prop2")));
        ProcessArchiveXml archiveXml2 = (ProcessArchiveXml)processesXml.getProcessArchives().get(1);
        ProcessesXmlParserTest.assertEquals((String)"pa2", (String)archiveXml2.getName());
        ProcessesXmlParserTest.assertEquals((String)"default", (String)archiveXml2.getProcessEngineName());
        List resourceNames2 = archiveXml2.getProcessResourceNames();
        ProcessesXmlParserTest.assertEquals((int)2, (int)resourceNames.size());
        ProcessesXmlParserTest.assertEquals((String)"process1.bpmn", (String)((String)resourceNames2.get(0)));
        ProcessesXmlParserTest.assertEquals((String)"process2.bpmn", (String)((String)resourceNames2.get(1)));
        Map properties2 = archiveXml2.getProperties();
        ProcessesXmlParserTest.assertNotNull((Object)properties2);
        ProcessesXmlParserTest.assertEquals((int)0, (int)properties2.size());
    }

    public void testParseProcessesXmlTwoArchivesAndTwoEngines() {
        ProcessesXml processesXml = this.parser.createParse().sourceUrl(this.getStreamUrl("process_xml_two_archives_two_engines.xml")).execute().getProcessesXml();
        ProcessesXmlParserTest.assertNotNull((Object)processesXml);
        ProcessesXmlParserTest.assertEquals((int)2, (int)processesXml.getProcessEngines().size());
        ProcessesXmlParserTest.assertEquals((int)2, (int)processesXml.getProcessArchives().size());
        ProcessArchiveXml archiveXml1 = (ProcessArchiveXml)processesXml.getProcessArchives().get(0);
        ProcessesXmlParserTest.assertEquals((String)"pa1", (String)archiveXml1.getName());
        ProcessesXmlParserTest.assertEquals((String)"default", (String)archiveXml1.getProcessEngineName());
        List resourceNames = archiveXml1.getProcessResourceNames();
        ProcessesXmlParserTest.assertEquals((int)2, (int)resourceNames.size());
        ProcessesXmlParserTest.assertEquals((String)"process1.bpmn", (String)((String)resourceNames.get(0)));
        ProcessesXmlParserTest.assertEquals((String)"process2.bpmn", (String)((String)resourceNames.get(1)));
        Map properties1 = archiveXml1.getProperties();
        ProcessesXmlParserTest.assertNotNull((Object)properties1);
        ProcessesXmlParserTest.assertEquals((int)2, (int)properties1.size());
        ProcessesXmlParserTest.assertEquals((String)"value1", (String)((String)properties1.get("prop1")));
        ProcessesXmlParserTest.assertEquals((String)"value2", (String)((String)properties1.get("prop2")));
        ProcessArchiveXml archiveXml2 = (ProcessArchiveXml)processesXml.getProcessArchives().get(1);
        ProcessesXmlParserTest.assertEquals((String)"pa2", (String)archiveXml2.getName());
        ProcessesXmlParserTest.assertEquals((String)"default", (String)archiveXml2.getProcessEngineName());
        List resourceNames2 = archiveXml2.getProcessResourceNames();
        ProcessesXmlParserTest.assertEquals((int)2, (int)resourceNames.size());
        ProcessesXmlParserTest.assertEquals((String)"process1.bpmn", (String)((String)resourceNames2.get(0)));
        ProcessesXmlParserTest.assertEquals((String)"process2.bpmn", (String)((String)resourceNames2.get(1)));
        Map properties2 = archiveXml2.getProperties();
        ProcessesXmlParserTest.assertNotNull((Object)properties2);
        ProcessesXmlParserTest.assertEquals((int)0, (int)properties2.size());
        ProcessEngineXml engineXml1 = (ProcessEngineXml)processesXml.getProcessEngines().get(0);
        ProcessesXmlParserTest.assertEquals((String)"engine1", (String)engineXml1.getName());
        ProcessesXmlParserTest.assertEquals((String)"configuration", (String)engineXml1.getConfigurationClass());
        ProcessesXmlParserTest.assertEquals((String)"datasource", (String)engineXml1.getDatasource());
        properties1 = engineXml1.getProperties();
        ProcessesXmlParserTest.assertNotNull((Object)properties1);
        ProcessesXmlParserTest.assertEquals((int)2, (int)properties1.size());
        ProcessesXmlParserTest.assertEquals((String)"value1", (String)((String)properties1.get("prop1")));
        ProcessesXmlParserTest.assertEquals((String)"value2", (String)((String)properties1.get("prop2")));
        ProcessEngineXml engineXml2 = (ProcessEngineXml)processesXml.getProcessEngines().get(1);
        ProcessesXmlParserTest.assertEquals((String)"engine2", (String)engineXml2.getName());
        ProcessesXmlParserTest.assertEquals((String)"configuration", (String)engineXml2.getConfigurationClass());
        ProcessesXmlParserTest.assertEquals((String)"datasource", (String)engineXml2.getDatasource());
        properties2 = engineXml2.getProperties();
        ProcessesXmlParserTest.assertNotNull((Object)properties2);
        ProcessesXmlParserTest.assertEquals((int)0, (int)properties2.size());
    }

    public void testParseProcessesXmlEngineNoName() {
        try {
            this.parser.createParse().sourceUrl(this.getStreamUrl("process_xml_engine_no_name.xml")).execute();
            ProcessesXmlParserTest.fail((String)"exceptoion expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testParseProcessesXmlNsPrefix() {
        ProcessesXml processesXml = this.parser.createParse().sourceUrl(this.getStreamUrl("process_xml_ns_prefix.xml")).execute().getProcessesXml();
        ProcessesXmlParserTest.assertNotNull((Object)processesXml);
        ProcessesXmlParserTest.assertEquals((int)1, (int)processesXml.getProcessEngines().size());
        ProcessesXmlParserTest.assertEquals((int)1, (int)processesXml.getProcessArchives().size());
    }
}

