/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.cmmn;

import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.runtime.CaseExecutionQuery;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.CaseInstanceQuery;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.runtime.VariableInstanceQuery;
import org.camunda.bpm.engine.test.Deployment;

public class CaseServiceTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCreateCaseInstanceByKey() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        CaseInstance caseInstance = this.caseService.createCaseInstanceByKey("oneTaskCase").create();
        CaseServiceTest.assertNotNull((Object)caseInstance);
        CaseServiceTest.assertNull((Object)caseInstance.getBusinessKey());
        CaseServiceTest.assertEquals((String)caseDefinitionId, (String)caseInstance.getCaseDefinitionId());
        CaseServiceTest.assertEquals((String)caseInstance.getId(), (String)caseInstance.getCaseInstanceId());
        CaseServiceTest.assertTrue((boolean)caseInstance.isActive());
        CaseServiceTest.assertFalse((boolean)caseInstance.isEnabled());
        CaseInstance instance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        CaseServiceTest.assertEquals((String)caseInstance.getId(), (String)instance.getId());
        CaseServiceTest.assertEquals((String)caseInstance.getBusinessKey(), (String)instance.getBusinessKey());
        CaseServiceTest.assertEquals((String)caseInstance.getCaseDefinitionId(), (String)instance.getCaseDefinitionId());
        CaseServiceTest.assertEquals((String)caseInstance.getCaseInstanceId(), (String)instance.getCaseInstanceId());
        CaseServiceTest.assertEquals((boolean)caseInstance.isActive(), (boolean)instance.isActive());
        CaseServiceTest.assertEquals((boolean)caseInstance.isEnabled(), (boolean)instance.isEnabled());
    }

    public void testCreateCaseInstanceByInvalidKey() {
        try {
            this.caseService.createCaseInstanceByKey("invalid").create();
            CaseServiceTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.caseService.createCaseInstanceByKey(null).create();
            CaseServiceTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCreateCaseInstanceById() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        CaseInstance caseInstance = this.caseService.createCaseInstanceById(caseDefinitionId).create();
        CaseServiceTest.assertNotNull((Object)caseInstance);
        CaseServiceTest.assertNull((Object)caseInstance.getBusinessKey());
        CaseServiceTest.assertEquals((String)caseDefinitionId, (String)caseInstance.getCaseDefinitionId());
        CaseServiceTest.assertEquals((String)caseInstance.getId(), (String)caseInstance.getCaseInstanceId());
        CaseServiceTest.assertTrue((boolean)caseInstance.isActive());
        CaseServiceTest.assertFalse((boolean)caseInstance.isEnabled());
        CaseInstance instance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        CaseServiceTest.assertEquals((String)caseInstance.getId(), (String)instance.getId());
        CaseServiceTest.assertEquals((String)caseInstance.getBusinessKey(), (String)instance.getBusinessKey());
        CaseServiceTest.assertEquals((String)caseInstance.getCaseDefinitionId(), (String)instance.getCaseDefinitionId());
        CaseServiceTest.assertEquals((String)caseInstance.getCaseInstanceId(), (String)instance.getCaseInstanceId());
        CaseServiceTest.assertEquals((boolean)caseInstance.isActive(), (boolean)instance.isActive());
        CaseServiceTest.assertEquals((boolean)caseInstance.isEnabled(), (boolean)instance.isEnabled());
    }

    public void testCreateCaseInstanceByInvalidId() {
        try {
            this.caseService.createCaseInstanceById("invalid").create();
            CaseServiceTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.caseService.createCaseInstanceById(null).create();
            CaseServiceTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCreateCaseInstanceByKeyWithBusinessKey() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        CaseInstance caseInstance = this.caseService.createCaseInstanceByKey("oneTaskCase").businessKey("aBusinessKey").create();
        CaseServiceTest.assertNotNull((Object)caseInstance);
        CaseServiceTest.assertEquals((String)"aBusinessKey", (String)caseInstance.getBusinessKey());
        CaseServiceTest.assertEquals((String)caseDefinitionId, (String)caseInstance.getCaseDefinitionId());
        CaseServiceTest.assertEquals((String)caseInstance.getId(), (String)caseInstance.getCaseInstanceId());
        CaseServiceTest.assertTrue((boolean)caseInstance.isActive());
        CaseServiceTest.assertFalse((boolean)caseInstance.isEnabled());
        CaseInstance instance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        CaseServiceTest.assertEquals((String)caseInstance.getId(), (String)instance.getId());
        CaseServiceTest.assertEquals((String)caseInstance.getBusinessKey(), (String)instance.getBusinessKey());
        CaseServiceTest.assertEquals((String)caseInstance.getCaseDefinitionId(), (String)instance.getCaseDefinitionId());
        CaseServiceTest.assertEquals((String)caseInstance.getCaseInstanceId(), (String)instance.getCaseInstanceId());
        CaseServiceTest.assertEquals((boolean)caseInstance.isActive(), (boolean)instance.isActive());
        CaseServiceTest.assertEquals((boolean)caseInstance.isEnabled(), (boolean)instance.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCreateCaseInstanceByIdWithBusinessKey() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        CaseInstance caseInstance = this.caseService.createCaseInstanceById(caseDefinitionId).businessKey("aBusinessKey").create();
        CaseServiceTest.assertNotNull((Object)caseInstance);
        CaseServiceTest.assertEquals((String)"aBusinessKey", (String)caseInstance.getBusinessKey());
        CaseServiceTest.assertEquals((String)caseDefinitionId, (String)caseInstance.getCaseDefinitionId());
        CaseServiceTest.assertEquals((String)caseInstance.getId(), (String)caseInstance.getCaseInstanceId());
        CaseServiceTest.assertTrue((boolean)caseInstance.isActive());
        CaseServiceTest.assertFalse((boolean)caseInstance.isEnabled());
        CaseInstance instance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        CaseServiceTest.assertEquals((String)caseInstance.getId(), (String)instance.getId());
        CaseServiceTest.assertEquals((String)caseInstance.getBusinessKey(), (String)instance.getBusinessKey());
        CaseServiceTest.assertEquals((String)caseInstance.getCaseDefinitionId(), (String)instance.getCaseDefinitionId());
        CaseServiceTest.assertEquals((String)caseInstance.getCaseInstanceId(), (String)instance.getCaseInstanceId());
        CaseServiceTest.assertEquals((boolean)caseInstance.isActive(), (boolean)instance.isActive());
        CaseServiceTest.assertEquals((boolean)caseInstance.isEnabled(), (boolean)instance.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCreateCaseInstanceByKeyWithVariable() {
        CaseInstance caseInstance = this.caseService.createCaseInstanceByKey("oneTaskCase").setVariable("aVariableName", (Object)"aVariableValue").setVariable("anotherVariableName", (Object)999).create();
        CaseServiceTest.assertNotNull((Object)caseInstance);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        List result = ((VariableInstanceQuery)query.caseInstanceIdIn(new String[]{caseInstance.getId()}).orderByVariableName().asc()).list();
        CaseServiceTest.assertFalse((boolean)result.isEmpty());
        CaseServiceTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variableInstance : result) {
            if (variableInstance.getName().equals("aVariableName")) {
                CaseServiceTest.assertEquals((String)"aVariableName", (String)variableInstance.getName());
                CaseServiceTest.assertEquals((Object)"aVariableValue", (Object)variableInstance.getValue());
                continue;
            }
            if (variableInstance.getName().equals("anotherVariableName")) {
                CaseServiceTest.assertEquals((String)"anotherVariableName", (String)variableInstance.getName());
                CaseServiceTest.assertEquals((Object)999, (Object)variableInstance.getValue());
                continue;
            }
            CaseServiceTest.fail((String)("Unexpected variable: " + variableInstance.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCreateCaseInstanceByKeyWithVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "aVariableValue");
        variables.put("anotherVariableName", 999);
        CaseInstance caseInstance = this.caseService.createCaseInstanceByKey("oneTaskCase").setVariables(variables).create();
        CaseServiceTest.assertNotNull((Object)caseInstance);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        List result = ((VariableInstanceQuery)query.caseInstanceIdIn(new String[]{caseInstance.getId()}).orderByVariableName().asc()).list();
        CaseServiceTest.assertFalse((boolean)result.isEmpty());
        CaseServiceTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variableInstance : result) {
            if (variableInstance.getName().equals("aVariableName")) {
                CaseServiceTest.assertEquals((String)"aVariableName", (String)variableInstance.getName());
                CaseServiceTest.assertEquals((Object)"aVariableValue", (Object)variableInstance.getValue());
                continue;
            }
            if (variableInstance.getName().equals("anotherVariableName")) {
                CaseServiceTest.assertEquals((String)"anotherVariableName", (String)variableInstance.getName());
                CaseServiceTest.assertEquals((Object)999, (Object)variableInstance.getValue());
                continue;
            }
            CaseServiceTest.fail((String)("Unexpected variable: " + variableInstance.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCreateCaseInstanceByIdWithVariable() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        CaseInstance caseInstance = this.caseService.createCaseInstanceById(caseDefinitionId).setVariable("aVariableName", (Object)"aVariableValue").setVariable("anotherVariableName", (Object)999).create();
        CaseServiceTest.assertNotNull((Object)caseInstance);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        List result = ((VariableInstanceQuery)query.caseInstanceIdIn(new String[]{caseInstance.getId()}).orderByVariableName().asc()).list();
        CaseServiceTest.assertFalse((boolean)result.isEmpty());
        CaseServiceTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variableInstance : result) {
            if (variableInstance.getName().equals("aVariableName")) {
                CaseServiceTest.assertEquals((String)"aVariableName", (String)variableInstance.getName());
                CaseServiceTest.assertEquals((Object)"aVariableValue", (Object)variableInstance.getValue());
                continue;
            }
            if (variableInstance.getName().equals("anotherVariableName")) {
                CaseServiceTest.assertEquals((String)"anotherVariableName", (String)variableInstance.getName());
                CaseServiceTest.assertEquals((Object)999, (Object)variableInstance.getValue());
                continue;
            }
            CaseServiceTest.fail((String)("Unexpected variable: " + variableInstance.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCreateCaseInstanceByIdWithVariables() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "aVariableValue");
        variables.put("anotherVariableName", 999);
        CaseInstance caseInstance = this.caseService.createCaseInstanceById(caseDefinitionId).setVariables(variables).create();
        CaseServiceTest.assertNotNull((Object)caseInstance);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        List result = ((VariableInstanceQuery)query.caseInstanceIdIn(new String[]{caseInstance.getId()}).orderByVariableName().asc()).list();
        CaseServiceTest.assertFalse((boolean)result.isEmpty());
        CaseServiceTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variableInstance : result) {
            if (variableInstance.getName().equals("aVariableName")) {
                CaseServiceTest.assertEquals((String)"aVariableName", (String)variableInstance.getName());
                CaseServiceTest.assertEquals((Object)"aVariableValue", (Object)variableInstance.getValue());
                continue;
            }
            if (variableInstance.getName().equals("anotherVariableName")) {
                CaseServiceTest.assertEquals((String)"anotherVariableName", (String)variableInstance.getName());
                CaseServiceTest.assertEquals((Object)999, (Object)variableInstance.getValue());
                continue;
            }
            CaseServiceTest.fail((String)("Unexpected variable: " + variableInstance.getName()));
        }
    }

    public void testCreateCaseInstanceQuery() {
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        CaseServiceTest.assertNotNull((Object)query);
    }

    public void testCreateCaseExecutionQuery() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        CaseServiceTest.assertNotNull((Object)query);
    }
}

