/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.identity;

import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;

public class AuthorizationServiceAuthorizationsTest
extends PluggableProcessEngineTestCase {
    private static final String jonny2 = "jonny2";

    protected void tearDown() throws Exception {
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        this.cleanupAfterTest();
        super.tearDown();
    }

    public void testCreateAuthorization() {
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.AUTHORIZATION);
        basePerms.setResourceId("*");
        basePerms.addPermission((Permission)Permissions.ALL);
        basePerms.removePermission((Permission)Permissions.CREATE);
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.identityService.setAuthenticatedUserId(jonny2);
        try {
            this.authorizationService.createNewAuthorization(0);
            AuthorizationServiceAuthorizationsTest.fail((String)"exception expected");
        }
        catch (AuthorizationException e) {
            AuthorizationServiceAuthorizationsTest.assertEquals((String)Permissions.CREATE.getName(), (String)e.getViolatedPermissionName());
            AuthorizationServiceAuthorizationsTest.assertEquals((String)jonny2, (String)e.getUserId());
            AuthorizationServiceAuthorizationsTest.assertEquals((String)Resources.AUTHORIZATION.resourceName(), (String)e.getResourceType());
            AuthorizationServiceAuthorizationsTest.assertEquals(null, (String)e.getResourceId());
        }
        AuthorizationEntity authorization = new AuthorizationEntity(2);
        authorization.setUserId("someUserId");
        authorization.setResource((Resource)Resources.APPLICATION);
        try {
            this.authorizationService.saveAuthorization((Authorization)authorization);
            AuthorizationServiceAuthorizationsTest.fail((String)"exception expected");
        }
        catch (AuthorizationException e) {
            AuthorizationServiceAuthorizationsTest.assertEquals((String)Permissions.CREATE.getName(), (String)e.getViolatedPermissionName());
            AuthorizationServiceAuthorizationsTest.assertEquals((String)jonny2, (String)e.getUserId());
            AuthorizationServiceAuthorizationsTest.assertEquals((String)Resources.AUTHORIZATION.resourceName(), (String)e.getResourceType());
            AuthorizationServiceAuthorizationsTest.assertEquals(null, (String)e.getResourceId());
        }
    }

    public void testDeleteAuthorization() {
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.AUTHORIZATION);
        basePerms.setResourceId("*");
        basePerms.addPermission((Permission)Permissions.ALL);
        basePerms.removePermission((Permission)Permissions.DELETE);
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.identityService.setAuthenticatedUserId(jonny2);
        try {
            this.authorizationService.deleteAuthorization(basePerms.getId());
            AuthorizationServiceAuthorizationsTest.fail((String)"exception expected");
        }
        catch (AuthorizationException e) {
            AuthorizationServiceAuthorizationsTest.assertEquals((String)Permissions.DELETE.getName(), (String)e.getViolatedPermissionName());
            AuthorizationServiceAuthorizationsTest.assertEquals((String)jonny2, (String)e.getUserId());
            AuthorizationServiceAuthorizationsTest.assertEquals((String)Resources.AUTHORIZATION.resourceName(), (String)e.getResourceType());
            AuthorizationServiceAuthorizationsTest.assertEquals((String)basePerms.getId(), (String)e.getResourceId());
        }
    }

    public void testUserUpdateAuthorizations() {
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.AUTHORIZATION);
        basePerms.setResourceId("*");
        basePerms.addPermission((Permission)Permissions.ALL);
        basePerms.removePermission((Permission)Permissions.UPDATE);
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.identityService.setAuthenticatedUserId(jonny2);
        basePerms = (Authorization)this.authorizationService.createAuthorizationQuery().singleResult();
        basePerms.addPermission((Permission)Permissions.ALL);
        try {
            this.authorizationService.saveAuthorization(basePerms);
            AuthorizationServiceAuthorizationsTest.fail((String)"exception expected");
        }
        catch (AuthorizationException e) {
            AuthorizationServiceAuthorizationsTest.assertEquals((String)Permissions.UPDATE.getName(), (String)e.getViolatedPermissionName());
            AuthorizationServiceAuthorizationsTest.assertEquals((String)jonny2, (String)e.getUserId());
            AuthorizationServiceAuthorizationsTest.assertEquals((String)Resources.AUTHORIZATION.resourceName(), (String)e.getResourceType());
            AuthorizationServiceAuthorizationsTest.assertEquals((String)basePerms.getId(), (String)e.getResourceId());
        }
        Authorization newAuth = this.authorizationService.createNewAuthorization(1);
        newAuth.setUserId(jonny2);
        newAuth.setResource((Resource)Resources.AUTHORIZATION);
        newAuth.setResourceId("*");
        newAuth.addPermission((Permission)Permissions.ALL);
        this.authorizationService.saveAuthorization(newAuth);
    }

    public void testAuthorizationQueryAuthorizations() {
        String authUserId = jonny2;
        this.identityService.setAuthenticatedUserId(authUserId);
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.AUTHORIZATION);
        basePerms.setResourceId("*");
        this.authorizationService.saveAuthorization(basePerms);
        AuthorizationServiceAuthorizationsTest.assertEquals((long)1L, (long)this.authorizationService.createAuthorizationQuery().count());
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        AuthorizationServiceAuthorizationsTest.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().count());
    }

    protected void cleanupAfterTest() {
        for (Authorization authorization : this.authorizationService.createAuthorizationQuery().list()) {
            this.authorizationService.deleteAuthorization(authorization.getId());
        }
    }
}

