/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.identity;

import java.util.List;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;

public class DefaultAuthorizationProviderTest
extends PluggableProcessEngineTestCase {
    protected void setUp() throws Exception {
        this.identityService.setAuthenticatedUserId("jonny");
        Authorization jonnyIsGod = this.authorizationService.createNewAuthorization(1);
        jonnyIsGod.setUserId("jonny");
        jonnyIsGod.setResource((Resource)Resources.USER);
        jonnyIsGod.setResourceId("*");
        jonnyIsGod.addPermission((Permission)Permissions.ALL);
        this.authorizationService.saveAuthorization(jonnyIsGod);
        jonnyIsGod = this.authorizationService.createNewAuthorization(1);
        jonnyIsGod.setUserId("jonny");
        jonnyIsGod.setResource((Resource)Resources.GROUP);
        jonnyIsGod.setResourceId("*");
        jonnyIsGod.addPermission((Permission)Permissions.ALL);
        this.authorizationService.saveAuthorization(jonnyIsGod);
        jonnyIsGod = this.authorizationService.createNewAuthorization(1);
        jonnyIsGod.setUserId("jonny");
        jonnyIsGod.setResource((Resource)Resources.AUTHORIZATION);
        jonnyIsGod.setResourceId("*");
        jonnyIsGod.addPermission((Permission)Permissions.ALL);
        this.authorizationService.saveAuthorization(jonnyIsGod);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        super.setUp();
    }

    protected void tearDown() throws Exception {
        List jonnysAuths = this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"jonny"}).list();
        for (Authorization authorization : jonnysAuths) {
            this.authorizationService.deleteAuthorization(authorization.getId());
        }
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        super.tearDown();
    }

    public void testCreateUser() {
        DefaultAuthorizationProviderTest.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"jonny2"}).count());
        this.identityService.saveUser(this.identityService.newUser("jonny2"));
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"jonny2"}).singleResult();
        DefaultAuthorizationProviderTest.assertNotNull((Object)authorization);
        DefaultAuthorizationProviderTest.assertEquals((int)1, (int)authorization.getAuthorizationType());
        DefaultAuthorizationProviderTest.assertEquals((int)Resources.USER.resourceType(), (int)authorization.getResourceType());
        DefaultAuthorizationProviderTest.assertEquals((String)"jonny2", (String)authorization.getResourceId());
        DefaultAuthorizationProviderTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.ALL));
        this.identityService.deleteUser("jonny2");
        DefaultAuthorizationProviderTest.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"jonny2"}).count());
    }

    public void testCreateGroup() {
        DefaultAuthorizationProviderTest.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"sales"}).count());
        this.identityService.saveGroup(this.identityService.newGroup("sales"));
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"sales"}).singleResult();
        DefaultAuthorizationProviderTest.assertNotNull((Object)authorization);
        DefaultAuthorizationProviderTest.assertEquals((int)1, (int)authorization.getAuthorizationType());
        DefaultAuthorizationProviderTest.assertEquals((int)Resources.GROUP.resourceType(), (int)authorization.getResourceType());
        DefaultAuthorizationProviderTest.assertEquals((String)"sales", (String)authorization.getResourceId());
        DefaultAuthorizationProviderTest.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        this.identityService.deleteGroup("sales");
        DefaultAuthorizationProviderTest.assertEquals((long)0L, (long)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"sales"}).count());
    }
}

