/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.repository;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.CaseDefinitionQuery;

public class CaseDefinitionQueryTest
extends PluggableProcessEngineTestCase {
    private String deploymentOneId;
    private String deploymentTwoId;
    private String resourceOne = "org/camunda/bpm/engine/test/repository/one.cmmn";
    private String resourceTwo = "org/camunda/bpm/engine/test/repository/two.cmmn";

    protected void setUp() throws Exception {
        this.deploymentOneId = this.repositoryService.createDeployment().name("firstDeployment").addClasspathResource(this.resourceOne).addClasspathResource(this.resourceTwo).deploy().getId();
        this.deploymentTwoId = this.repositoryService.createDeployment().name("secondDeployment").addClasspathResource(this.resourceOne).deploy().getId();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.repositoryService.deleteDeployment(this.deploymentOneId, true);
        this.repositoryService.deleteDeployment(this.deploymentTwoId, true);
    }

    private void verifyQueryResults(CaseDefinitionQuery query, int countExpected) {
        CaseDefinitionQueryTest.assertEquals((int)countExpected, (int)query.list().size());
        CaseDefinitionQueryTest.assertEquals((long)countExpected, (long)query.count());
        if (countExpected == 1) {
            CaseDefinitionQueryTest.assertNotNull((Object)query.singleResult());
        } else if (countExpected > 1) {
            this.verifySingleResultFails(query);
        } else if (countExpected == 0) {
            CaseDefinitionQueryTest.assertNull((Object)query.singleResult());
        }
    }

    private void verifySingleResultFails(CaseDefinitionQuery query) {
        try {
            query.singleResult();
            CaseDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testCaseDefinitionProperties() {
        List caseDefinitions = ((CaseDefinitionQuery)((CaseDefinitionQuery)((CaseDefinitionQuery)this.repositoryService.createCaseDefinitionQuery().orderByCaseDefinitionName().asc()).orderByCaseDefinitionVersion().asc()).orderByCaseDefinitionCategory().asc()).list();
        CaseDefinition caseDefinition = (CaseDefinition)caseDefinitions.get(0);
        CaseDefinitionQueryTest.assertEquals((String)"one", (String)caseDefinition.getKey());
        CaseDefinitionQueryTest.assertEquals((String)"One", (String)caseDefinition.getName());
        CaseDefinitionQueryTest.assertTrue((boolean)caseDefinition.getId().startsWith("one:1"));
        CaseDefinitionQueryTest.assertEquals((String)"Examples", (String)caseDefinition.getCategory());
        CaseDefinitionQueryTest.assertEquals((int)1, (int)caseDefinition.getVersion());
        CaseDefinitionQueryTest.assertEquals((String)"org/camunda/bpm/engine/test/repository/one.cmmn", (String)caseDefinition.getResourceName());
        CaseDefinitionQueryTest.assertEquals((String)this.deploymentOneId, (String)caseDefinition.getDeploymentId());
        caseDefinition = (CaseDefinition)caseDefinitions.get(1);
        CaseDefinitionQueryTest.assertEquals((String)"one", (String)caseDefinition.getKey());
        CaseDefinitionQueryTest.assertEquals((String)"One", (String)caseDefinition.getName());
        CaseDefinitionQueryTest.assertTrue((boolean)caseDefinition.getId().startsWith("one:2"));
        CaseDefinitionQueryTest.assertEquals((String)"Examples", (String)caseDefinition.getCategory());
        CaseDefinitionQueryTest.assertEquals((int)2, (int)caseDefinition.getVersion());
        CaseDefinitionQueryTest.assertEquals((String)"org/camunda/bpm/engine/test/repository/one.cmmn", (String)caseDefinition.getResourceName());
        CaseDefinitionQueryTest.assertEquals((String)this.deploymentTwoId, (String)caseDefinition.getDeploymentId());
        caseDefinition = (CaseDefinition)caseDefinitions.get(2);
        CaseDefinitionQueryTest.assertEquals((String)"two", (String)caseDefinition.getKey());
        CaseDefinitionQueryTest.assertEquals((String)"Two", (String)caseDefinition.getName());
        CaseDefinitionQueryTest.assertTrue((boolean)caseDefinition.getId().startsWith("two:1"));
        CaseDefinitionQueryTest.assertEquals((String)"Examples2", (String)caseDefinition.getCategory());
        CaseDefinitionQueryTest.assertEquals((int)1, (int)caseDefinition.getVersion());
        CaseDefinitionQueryTest.assertEquals((String)"org/camunda/bpm/engine/test/repository/two.cmmn", (String)caseDefinition.getResourceName());
        CaseDefinitionQueryTest.assertEquals((String)this.deploymentOneId, (String)caseDefinition.getDeploymentId());
    }

    public void testQueryByDeploymentId() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        query.deploymentId(this.deploymentOneId);
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByInvalidDeploymentId() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        query.deploymentId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.deploymentId(null);
            CaseDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByName() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        query.caseDefinitionName("Two");
        this.verifyQueryResults(query, 1);
        query.caseDefinitionName("One");
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByInvalidName() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        query.caseDefinitionName("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseDefinitionName(null);
            CaseDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByNameLike() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        query.caseDefinitionNameLike("%w%");
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidNameLike() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        query.caseDefinitionNameLike("%invalid%");
        this.verifyQueryResults(query, 0);
        try {
            query.caseDefinitionNameLike(null);
            CaseDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByKey() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        query.caseDefinitionKey("one");
        this.verifyQueryResults(query, 2);
        query.caseDefinitionKey("two");
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidKey() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        query.caseDefinitionKey("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseDefinitionKey(null);
            CaseDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByKeyLike() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        query.caseDefinitionKeyLike("%o%");
        this.verifyQueryResults(query, 3);
    }

    public void testQueryByInvalidKeyLike() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        query.caseDefinitionKeyLike("%invalid%");
        this.verifyQueryResults(query, 0);
        try {
            query.caseDefinitionKeyLike(null);
            CaseDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByCategory() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        query.caseDefinitionCategory("Examples");
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByInvalidCategory() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        query.caseDefinitionCategory("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseDefinitionCategory(null);
            CaseDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByCategoryLike() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        query.caseDefinitionCategoryLike("%Example%");
        this.verifyQueryResults(query, 3);
        query.caseDefinitionCategoryLike("%amples2");
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidCategoryLike() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        query.caseDefinitionCategoryLike("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseDefinitionCategoryLike(null);
            CaseDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByVersion() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        query.caseDefinitionVersion(Integer.valueOf(2));
        this.verifyQueryResults(query, 1);
        query.caseDefinitionVersion(Integer.valueOf(1));
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByInvalidVersion() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        query.caseDefinitionVersion(Integer.valueOf(3));
        this.verifyQueryResults(query, 0);
        try {
            query.caseDefinitionVersion(Integer.valueOf(-1));
            CaseDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            query.caseDefinitionVersion(null);
            CaseDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByLatest() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        query.latestVersion();
        this.verifyQueryResults(query, 2);
        query.caseDefinitionKey("one").latestVersion();
        this.verifyQueryResults(query, 1);
        query.caseDefinitionKey("two").latestVersion();
        this.verifyQueryResults(query, 1);
    }

    public void testInvalidUsageOfLatest() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        try {
            query.caseDefinitionId("test").latestVersion().list();
            CaseDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            query.caseDefinitionName("test").latestVersion().list();
            CaseDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            query.caseDefinitionNameLike("test").latestVersion().list();
            CaseDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            query.caseDefinitionVersion(Integer.valueOf(1)).latestVersion().list();
            CaseDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            query.deploymentId("test").latestVersion().list();
            CaseDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQuerySorting() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        query.orderByCaseDefinitionId().asc();
        this.verifyQueryResults(query, 3);
        query = this.repositoryService.createCaseDefinitionQuery();
        query.orderByDeploymentId().asc();
        this.verifyQueryResults(query, 3);
        query = this.repositoryService.createCaseDefinitionQuery();
        query.orderByCaseDefinitionKey().asc();
        this.verifyQueryResults(query, 3);
        query = this.repositoryService.createCaseDefinitionQuery();
        query.orderByCaseDefinitionVersion().asc();
        this.verifyQueryResults(query, 3);
        query = this.repositoryService.createCaseDefinitionQuery();
        query.orderByCaseDefinitionId().desc();
        this.verifyQueryResults(query, 3);
        query = this.repositoryService.createCaseDefinitionQuery();
        query.orderByDeploymentId().desc();
        this.verifyQueryResults(query, 3);
        query = this.repositoryService.createCaseDefinitionQuery();
        query.orderByCaseDefinitionKey().desc();
        this.verifyQueryResults(query, 3);
        query = this.repositoryService.createCaseDefinitionQuery();
        query.orderByCaseDefinitionVersion().desc();
        this.verifyQueryResults(query, 3);
        query = this.repositoryService.createCaseDefinitionQuery();
        ((CaseDefinitionQuery)query.orderByCaseDefinitionKey().asc()).orderByCaseDefinitionVersion().desc();
        List caseDefinitions = query.list();
        CaseDefinitionQueryTest.assertEquals((int)3, (int)caseDefinitions.size());
        CaseDefinitionQueryTest.assertEquals((String)"one", (String)((CaseDefinition)caseDefinitions.get(0)).getKey());
        CaseDefinitionQueryTest.assertEquals((int)2, (int)((CaseDefinition)caseDefinitions.get(0)).getVersion());
        CaseDefinitionQueryTest.assertEquals((String)"one", (String)((CaseDefinition)caseDefinitions.get(1)).getKey());
        CaseDefinitionQueryTest.assertEquals((int)1, (int)((CaseDefinition)caseDefinitions.get(1)).getVersion());
        CaseDefinitionQueryTest.assertEquals((String)"two", (String)((CaseDefinition)caseDefinitions.get(2)).getKey());
        CaseDefinitionQueryTest.assertEquals((int)1, (int)((CaseDefinition)caseDefinitions.get(2)).getVersion());
    }
}

