/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseExecutionQuery;
import org.camunda.bpm.engine.runtime.CaseInstance;

public class CaseExecutionQueryTest
extends PluggableProcessEngineTestCase {
    private static String CASE_DEFINITION_KEY = "oneTaskCase";
    private static String CASE_DEFINITION_KEY_2 = "twoTaskCase";

    protected void setUp() throws Exception {
        super.setUp();
        this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn").addClasspathResource("org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn").deploy();
        for (int i = 0; i < 4; ++i) {
            this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).businessKey(i + "").create();
        }
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY_2).businessKey("1").create();
    }

    protected void tearDown() throws Exception {
        for (Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
        super.tearDown();
    }

    private void verifyQueryResults(CaseExecutionQuery query, int countExpected) {
        CaseExecutionQueryTest.assertEquals((int)countExpected, (int)query.list().size());
        CaseExecutionQueryTest.assertEquals((long)countExpected, (long)query.count());
        if (countExpected == 1) {
            CaseExecutionQueryTest.assertNotNull((Object)query.singleResult());
        } else if (countExpected > 1) {
            this.verifySingleResultFails(query);
        } else if (countExpected == 0) {
            CaseExecutionQueryTest.assertNull((Object)query.singleResult());
        }
    }

    private void verifySingleResultFails(CaseExecutionQuery query) {
        try {
            query.singleResult();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryWithoutQueryParameter() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        this.verifyQueryResults(query, 11);
    }

    public void testQueryByCaseDefinitionKey() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseDefinitionKey(CASE_DEFINITION_KEY);
        this.verifyQueryResults(query, 8);
        query.caseDefinitionKey(CASE_DEFINITION_KEY_2);
        this.verifyQueryResults(query, 3);
    }

    public void testQueryByInvalidCaseDefinitionKey() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseDefinitionKey("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseDefinitionKey(null);
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByCaseDefinitionId() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(CASE_DEFINITION_KEY).singleResult()).getId();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseDefinitionId(caseDefinitionId);
        this.verifyQueryResults(query, 8);
        caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(CASE_DEFINITION_KEY_2).singleResult()).getId();
        query.caseDefinitionId(caseDefinitionId);
        this.verifyQueryResults(query, 3);
    }

    public void testQueryByInvalidCaseDefinitionId() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseDefinitionId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseDefinitionId(null);
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByCaseInstaceId() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        List caseInstances = this.caseService.createCaseInstanceQuery().caseDefinitionKey(CASE_DEFINITION_KEY).list();
        for (CaseInstance caseInstance : caseInstances) {
            query.caseInstanceId(caseInstance.getId());
            this.verifyQueryResults(query, 2);
        }
        CaseInstance instance = (CaseInstance)this.caseService.createCaseInstanceQuery().caseDefinitionKey(CASE_DEFINITION_KEY_2).singleResult();
        query.caseInstanceId(instance.getId());
        this.verifyQueryResults(query, 3);
    }

    public void testQueryByInvalidCaseInstanceId() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseInstanceId(null);
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByCaseInstanceBusinessKey() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceBusinessKey("0");
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByInvalidCaseInstanceBusinessKey() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceBusinessKey("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseInstanceBusinessKey(null);
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByCaseInstanceBusinessKeyAndCaseDefinitionKey() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceBusinessKey("0").caseDefinitionKey(CASE_DEFINITION_KEY);
        this.verifyQueryResults(query, 2);
        query.caseInstanceBusinessKey("1").caseDefinitionKey(CASE_DEFINITION_KEY);
        this.verifyQueryResults(query, 2);
        query.caseInstanceBusinessKey("2").caseDefinitionKey(CASE_DEFINITION_KEY);
        this.verifyQueryResults(query, 2);
        query.caseInstanceBusinessKey("3").caseDefinitionKey(CASE_DEFINITION_KEY);
        this.verifyQueryResults(query, 2);
        query.caseInstanceBusinessKey("1").caseDefinitionKey(CASE_DEFINITION_KEY_2);
        this.verifyQueryResults(query, 3);
    }

    public void testQueryByCaseExecutionId() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        List executions = this.caseService.createCaseExecutionQuery().caseDefinitionKey(CASE_DEFINITION_KEY_2).list();
        for (CaseExecution execution : executions) {
            query.caseExecutionId(execution.getId());
            this.verifyQueryResults(query, 1);
        }
    }

    public void testQueryByInvalidCaseExecutionId() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseExecutionId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseExecutionId(null);
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByActivityId() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.activityId("PI_HumanTask_1");
        this.verifyQueryResults(query, 5);
        query.activityId("PI_HumanTask_2");
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidActivityId() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.activityId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.activityId(null);
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByEnabled() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.enabled();
        this.verifyQueryResults(query, 6);
    }

    public void testQueryByActive() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.active();
        this.verifyQueryResults(query, 5);
    }

    public void testQueryByNullVariableValueEquals() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aNullValue", null).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueEquals("aNullValue", null);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByStringVariableValueEquals() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueEquals("aStringValue", (Object)"abc");
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByBooleanVariableValueEquals() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aBooleanValue", (Object)true).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueEquals("aBooleanValue", (Object)true);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByShortVariableValueEquals() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aShortValue", (Object)123).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueEquals("aShortValue", (Object)123);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByIntegerVariableValueEquals() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("anIntegerValue", (Object)456).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueEquals("anIntegerValue", (Object)456);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByLongVariableValueEquals() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aLongValue", (Object)789L).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueEquals("aLongValue", (Object)789L);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByDateVariableValueEquals() {
        Date now = new Date();
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aDateValue", (Object)now).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueEquals("aDateValue", (Object)now);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByDoubleVariableValueEquals() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aDoubleValue", (Object)1.5).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueEquals("aDoubleValue", (Object)1.5);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByByteArrayVariableValueEquals() {
        byte[] bytes = "somebytes".getBytes();
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aByteArrayValue", (Object)bytes).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueEquals("aByteArrayValue", (Object)bytes).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryBySerializableVariableValueEquals() {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aSerializableValue", serializable).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueEquals("aSerializableValue", serializable).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByStringVariableValueNotEquals() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueNotEquals("aStringValue", (Object)"abd");
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByBooleanVariableValueNotEquals() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aBooleanValue", (Object)true).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueNotEquals("aBooleanValue", (Object)false);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByShortVariableValueNotEquals() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aShortValue", (Object)123).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueNotEquals("aShortValue", (Object)124);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByIntegerVariableValueNotEquals() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("anIntegerValue", (Object)456).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueNotEquals("anIntegerValue", (Object)457);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByLongVariableValueNotEquals() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aLongValue", (Object)789L).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueNotEquals("aLongValue", (Object)790L);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByDateVariableValueNotEquals() {
        Date now = new Date();
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aDateValue", (Object)now).create();
        Date before = new Date(now.getTime() - 100000L);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueNotEquals("aDateValue", (Object)before);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByDoubleVariableValueNotEquals() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aDoubleValue", (Object)1.5).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueNotEquals("aDoubleValue", (Object)1.6);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByByteArrayVariableValueNotEquals() {
        byte[] bytes = "somebytes".getBytes();
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aByteArrayValue", (Object)bytes).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueNotEquals("aByteArrayValue", (Object)bytes).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryBySerializableVariableValueNotEquals() {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aSerializableValue", serializable).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueNotEquals("aSerializableValue", serializable).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByNullVariableValueGreaterThan() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aNullValue", null).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueGreaterThan("aNullValue", null).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByStringVariableValueGreaterThan() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueGreaterThan("aStringValue", (Object)"ab");
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByBooleanVariableValueGreaterThan() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aBooleanValue", (Object)true).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueGreaterThan("aBooleanValue", (Object)false).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByShortVariableValueGreaterThan() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aShortValue", (Object)123).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueGreaterThan("aShortValue", (Object)122);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByIntegerVariableValueGreaterThan() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("anIntegerValue", (Object)456).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueGreaterThan("anIntegerValue", (Object)455);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByLongVariableValueGreaterThan() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aLongValue", (Object)789L).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueGreaterThan("aLongValue", (Object)788L);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByDateVariableValueGreaterThan() {
        Date now = new Date();
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aDateValue", (Object)now).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        Date before = new Date(now.getTime() - 100000L);
        query.variableValueGreaterThan("aDateValue", (Object)before);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByDoubleVariableValueGreaterThan() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aDoubleValue", (Object)1.5).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueGreaterThan("aDoubleValue", (Object)1.4);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByByteArrayVariableValueGreaterThan() {
        byte[] bytes = "somebytes".getBytes();
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aByteArrayValue", (Object)bytes).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueGreaterThan("aByteArrayValue", (Object)bytes).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryBySerializableVariableGreaterThan() {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aSerializableValue", serializable).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueGreaterThan("aSerializableValue", serializable).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByNullVariableValueGreaterThanOrEqual() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aNullValue", null).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueGreaterThanOrEqual("aNullValue", null).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByStringVariableValueGreaterThanOrEqual() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueGreaterThanOrEqual("aStringValue", (Object)"ab");
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseExecutionQuery();
        query.variableValueGreaterThanOrEqual("aStringValue", (Object)"abc");
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByBooleanVariableValueGreaterThanOrEqual() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aBooleanValue", (Object)true).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueGreaterThanOrEqual("aBooleanValue", (Object)false).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByShortVariableValueGreaterThanOrEqual() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aShortValue", (Object)123).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueGreaterThanOrEqual("aShortValue", (Object)122);
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseExecutionQuery();
        query.variableValueGreaterThanOrEqual("aShortValue", (Object)123);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByIntegerVariableValueGreaterThanOrEquals() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("anIntegerValue", (Object)456).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueGreaterThanOrEqual("anIntegerValue", (Object)455);
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseExecutionQuery();
        query.variableValueGreaterThanOrEqual("anIntegerValue", (Object)456);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByLongVariableValueGreaterThanOrEqual() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aLongValue", (Object)789L).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueGreaterThanOrEqual("aLongValue", (Object)788L);
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseExecutionQuery();
        query.variableValueGreaterThanOrEqual("aLongValue", (Object)789L);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByDateVariableValueGreaterThanOrEqual() {
        Date now = new Date();
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aDateValue", (Object)now).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        Date before = new Date(now.getTime() - 100000L);
        query.variableValueGreaterThanOrEqual("aDateValue", (Object)before);
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseExecutionQuery();
        query.variableValueGreaterThanOrEqual("aDateValue", (Object)now);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByDoubleVariableValueGreaterThanOrEqual() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aDoubleValue", (Object)1.5).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueGreaterThanOrEqual("aDoubleValue", (Object)1.4);
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseExecutionQuery();
        query.variableValueGreaterThanOrEqual("aDoubleValue", (Object)1.5);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByByteArrayVariableValueGreaterThanOrEqual() {
        byte[] bytes = "somebytes".getBytes();
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aByteArrayValue", (Object)bytes).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueGreaterThanOrEqual("aByteArrayValue", (Object)bytes).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryBySerializableVariableGreaterThanOrEqual() {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aSerializableValue", serializable).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueGreaterThanOrEqual("aSerializableValue", serializable).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByNullVariableValueLessThan() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aNullValue", null).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueLessThan("aNullValue", null).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByStringVariableValueLessThan() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueLessThan("aStringValue", (Object)"abd");
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByBooleanVariableValueLessThan() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aBooleanValue", (Object)true).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueLessThan("aBooleanValue", (Object)false).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByShortVariableValueLessThan() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aShortValue", (Object)123).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueLessThan("aShortValue", (Object)124);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByIntegerVariableValueLessThan() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("anIntegerValue", (Object)456).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueLessThan("anIntegerValue", (Object)457);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByLongVariableValueLessThan() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aLongValue", (Object)789L).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueLessThan("aLongValue", (Object)790L);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByDateVariableValueLessThan() {
        Date now = new Date();
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aDateValue", (Object)now).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        Date after = new Date(now.getTime() + 100000L);
        query.variableValueLessThan("aDateValue", (Object)after);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByDoubleVariableValueLessThan() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aDoubleValue", (Object)1.5).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueLessThan("aDoubleValue", (Object)1.6);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByByteArrayVariableValueLessThan() {
        byte[] bytes = "somebytes".getBytes();
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aByteArrayValue", (Object)bytes).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueLessThan("aByteArrayValue", (Object)bytes).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryBySerializableVariableLessThan() {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aSerializableValue", serializable).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueLessThan("aSerializableValue", serializable).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByNullVariableValueLessThanOrEqual() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aNullValue", null).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueLessThanOrEqual("aNullValue", null).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByStringVariableValueLessThanOrEqual() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueLessThanOrEqual("aStringValue", (Object)"abd");
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseExecutionQuery();
        query.variableValueLessThanOrEqual("aStringValue", (Object)"abc");
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByBooleanVariableValueLessThanOrEqual() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aBooleanValue", (Object)true).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueLessThanOrEqual("aBooleanValue", (Object)false).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByShortVariableValueLessThanOrEqual() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aShortValue", (Object)123).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueLessThanOrEqual("aShortValue", (Object)124);
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseExecutionQuery();
        query.variableValueLessThanOrEqual("aShortValue", (Object)123);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByIntegerVariableValueLessThanOrEquals() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("anIntegerValue", (Object)456).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueLessThanOrEqual("anIntegerValue", (Object)457);
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseExecutionQuery();
        query.variableValueLessThanOrEqual("anIntegerValue", (Object)456);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByLongVariableValueLessThanOrEqual() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aLongValue", (Object)789L).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueLessThanOrEqual("aLongValue", (Object)790L);
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseExecutionQuery();
        query.variableValueLessThanOrEqual("aLongValue", (Object)789L);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByDateVariableValueLessThanOrEqual() {
        Date now = new Date();
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aDateValue", (Object)now).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        Date after = new Date(now.getTime() + 100000L);
        query.variableValueLessThanOrEqual("aDateValue", (Object)after);
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseExecutionQuery();
        query.variableValueLessThanOrEqual("aDateValue", (Object)now);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByDoubleVariableValueLessThanOrEqual() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aDoubleValue", (Object)1.5).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueLessThanOrEqual("aDoubleValue", (Object)1.6);
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseExecutionQuery();
        query.variableValueLessThanOrEqual("aDoubleValue", (Object)1.5);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByByteArrayVariableValueLessThanOrEqual() {
        byte[] bytes = "somebytes".getBytes();
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aByteArrayValue", (Object)bytes).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueLessThanOrEqual("aByteArrayValue", (Object)bytes).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryBySerializableVariableLessThanOrEqual() {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aSerializableValue", serializable).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueLessThanOrEqual("aSerializableValue", serializable).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByNullVariableValueLike() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aNullValue", null).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.variableValueLike("aNullValue", null).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByStringVariableValueLike() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.variableValueLike("aStringValue", "ab%");
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseExecutionQuery();
        query.variableValueLike("aStringValue", "%bc");
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseExecutionQuery();
        query.variableValueLike("aStringValue", "%b%");
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByNullCaseInstanceVariableValueEquals() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aNullValue", null).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueEquals("aNullValue", null);
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByStringCaseInstanceVariableValueEquals() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueEquals("aStringValue", (Object)"abc");
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByBooleanCaseInstanceVariableValueEquals() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aBooleanValue", (Object)true).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueEquals("aBooleanValue", (Object)true);
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByShortCaseInstanceVariableValueEquals() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aShortValue", (Object)123).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueEquals("aShortValue", (Object)123);
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByIntegerCaseInstanceVariableValueEquals() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("anIntegerValue", (Object)456).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueEquals("anIntegerValue", (Object)456);
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByLongCaseInstanceVariableValueEquals() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aLongValue", (Object)789L).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueEquals("aLongValue", (Object)789L);
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByDateCaseInstanceVariableValueEquals() {
        Date now = new Date();
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aDateValue", (Object)now).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueEquals("aDateValue", (Object)now);
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByDoubleCaseInstanceVariableValueEquals() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aDoubleValue", (Object)1.5).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueEquals("aDoubleValue", (Object)1.5);
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByByteArrayCaseInstanceVariableValueEquals() {
        byte[] bytes = "somebytes".getBytes();
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aByteArrayValue", (Object)bytes).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueEquals("aByteArrayValue", (Object)bytes).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryBySerializableCaseInstanceVariableValueEquals() {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aSerializableValue", serializable).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueEquals("aSerializableValue", serializable).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByStringCaseInstanceVariableValueNotEquals() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueNotEquals("aStringValue", (Object)"abd");
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByBooleanCaseInstanceVariableValueNotEquals() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aBooleanValue", (Object)true).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueNotEquals("aBooleanValue", (Object)false);
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByShortCaseInstanceVariableValueNotEquals() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aShortValue", (Object)123).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueNotEquals("aShortValue", (Object)124);
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByIntegerCaseInstanceVariableValueNotEquals() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("anIntegerValue", (Object)456).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueNotEquals("anIntegerValue", (Object)457);
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByLongCaseInstanceVariableValueNotEquals() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aLongValue", (Object)789L).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueNotEquals("aLongValue", (Object)790L);
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByDateCaseInstanceVariableValueNotEquals() {
        Date now = new Date();
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aDateValue", (Object)now).create();
        Date before = new Date(now.getTime() - 100000L);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueNotEquals("aDateValue", (Object)before);
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByDoubleCaseInstanceVariableValueNotEquals() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aDoubleValue", (Object)1.5).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueNotEquals("aDoubleValue", (Object)1.6);
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByByteArrayCaseInstanceVariableValueNotEquals() {
        byte[] bytes = "somebytes".getBytes();
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aByteArrayValue", (Object)bytes).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueNotEquals("aByteArrayValue", (Object)bytes).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryBySerializableCaseInstanceVariableValueNotEquals() {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aSerializableValue", serializable).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueNotEquals("aSerializableValue", serializable).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByNullCaseInstanceVariableValueGreaterThan() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aNullValue", null).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueGreaterThan("aNullValue", null).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByStringCaseInstanceVariableValueGreaterThan() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueGreaterThan("aStringValue", (Object)"ab");
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByBooleanCaseInstanceVariableValueGreaterThan() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aBooleanValue", (Object)true).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueGreaterThan("aBooleanValue", (Object)false).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByShortCaseInstanceVariableValueGreaterThan() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aShortValue", (Object)123).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueGreaterThan("aShortValue", (Object)122);
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByIntegerCaseInstanceVariableValueGreaterThan() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("anIntegerValue", (Object)456).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueGreaterThan("anIntegerValue", (Object)455);
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByLongCaseInstanceVariableValueGreaterThan() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aLongValue", (Object)789L).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueGreaterThan("aLongValue", (Object)788L);
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByDateCaseInstanceVariableValueGreaterThan() {
        Date now = new Date();
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aDateValue", (Object)now).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        Date before = new Date(now.getTime() - 100000L);
        query.caseInstanceVariableValueGreaterThan("aDateValue", (Object)before);
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByDoubleCaseInstanceVariableValueGreaterThan() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aDoubleValue", (Object)1.5).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueGreaterThan("aDoubleValue", (Object)1.4);
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByByteArrayCaseInstanceVariableValueGreaterThan() {
        byte[] bytes = "somebytes".getBytes();
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aByteArrayValue", (Object)bytes).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueGreaterThan("aByteArrayValue", (Object)bytes).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryBySerializableCaseInstanceVariableGreaterThan() {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aSerializableValue", serializable).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueGreaterThan("aSerializableValue", serializable).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByNullCaseInstanceVariableValueGreaterThanOrEqual() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aNullValue", null).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueGreaterThanOrEqual("aNullValue", null).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByStringCaseInstanceVariableValueGreaterThanOrEqual() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueGreaterThanOrEqual("aStringValue", (Object)"ab");
        this.verifyQueryResults(query, 2);
        query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueGreaterThanOrEqual("aStringValue", (Object)"abc");
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByBooleanCaseInstanceVariableValueGreaterThanOrEqual() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aBooleanValue", (Object)true).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueGreaterThanOrEqual("aBooleanValue", (Object)false).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByShortCaseInstanceVariableValueGreaterThanOrEqual() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aShortValue", (Object)123).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueGreaterThanOrEqual("aShortValue", (Object)122);
        this.verifyQueryResults(query, 2);
        query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueGreaterThanOrEqual("aShortValue", (Object)123);
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByIntegerCaseInstanceVariableValueGreaterThanOrEquals() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("anIntegerValue", (Object)456).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueGreaterThanOrEqual("anIntegerValue", (Object)455);
        this.verifyQueryResults(query, 2);
        query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueGreaterThanOrEqual("anIntegerValue", (Object)456);
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByLongCaseInstanceVariableValueGreaterThanOrEqual() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aLongValue", (Object)789L).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueGreaterThanOrEqual("aLongValue", (Object)788L);
        this.verifyQueryResults(query, 2);
        query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueGreaterThanOrEqual("aLongValue", (Object)789L);
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByDateCaseInstanceVariableValueGreaterThanOrEqual() {
        Date now = new Date();
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aDateValue", (Object)now).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        Date before = new Date(now.getTime() - 100000L);
        query.caseInstanceVariableValueGreaterThanOrEqual("aDateValue", (Object)before);
        this.verifyQueryResults(query, 2);
        query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueGreaterThanOrEqual("aDateValue", (Object)now);
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByDoubleCaseInstanceVariableValueGreaterThanOrEqual() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aDoubleValue", (Object)1.5).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueGreaterThanOrEqual("aDoubleValue", (Object)1.4);
        this.verifyQueryResults(query, 2);
        query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueGreaterThanOrEqual("aDoubleValue", (Object)1.5);
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByByteArrayCaseInstanceVariableValueGreaterThanOrEqual() {
        byte[] bytes = "somebytes".getBytes();
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aByteArrayValue", (Object)bytes).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueGreaterThanOrEqual("aByteArrayValue", (Object)bytes).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryBySerializableCaseInstanceVariableGreaterThanOrEqual() {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aSerializableValue", serializable).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueGreaterThanOrEqual("aSerializableValue", serializable).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByNullCaseInstanceVariableValueLessThan() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aNullValue", null).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueLessThan("aNullValue", null).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByStringCaseInstanceVariableValueLessThan() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueLessThan("aStringValue", (Object)"abd");
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByBooleanCaseInstanceVariableValueLessThan() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aBooleanValue", (Object)true).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueLessThan("aBooleanValue", (Object)false).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByShortCaseInstanceVariableValueLessThan() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aShortValue", (Object)123).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueLessThan("aShortValue", (Object)124);
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByIntegerCaseInstanceVariableValueLessThan() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("anIntegerValue", (Object)456).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueLessThan("anIntegerValue", (Object)457);
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByLongCaseInstanceVariableValueLessThan() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aLongValue", (Object)789L).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueLessThan("aLongValue", (Object)790L);
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByDateCaseInstanceVariableValueLessThan() {
        Date now = new Date();
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aDateValue", (Object)now).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        Date after = new Date(now.getTime() + 100000L);
        query.caseInstanceVariableValueLessThan("aDateValue", (Object)after);
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByDoubleCaseInstanceVariableValueLessThan() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aDoubleValue", (Object)1.5).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueLessThan("aDoubleValue", (Object)1.6);
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByByteArrayCaseInstanceVariableValueLessThan() {
        byte[] bytes = "somebytes".getBytes();
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aByteArrayValue", (Object)bytes).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueLessThan("aByteArrayValue", (Object)bytes).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryBySerializableCaseInstanceVariableLessThan() {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aSerializableValue", serializable).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueLessThan("aSerializableValue", serializable).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByNullCaseInstanceVariableValueLessThanOrEqual() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aNullValue", null).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueLessThanOrEqual("aNullValue", null).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByStringCaseInstanceVariableValueLessThanOrEqual() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueLessThanOrEqual("aStringValue", (Object)"abd");
        this.verifyQueryResults(query, 2);
        query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueLessThanOrEqual("aStringValue", (Object)"abc");
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByBooleanCaseInstanceVariableValueLessThanOrEqual() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aBooleanValue", (Object)true).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueLessThanOrEqual("aBooleanValue", (Object)false).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByShortCaseInstanceVariableValueLessThanOrEqual() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aShortValue", (Object)123).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueLessThanOrEqual("aShortValue", (Object)124);
        this.verifyQueryResults(query, 2);
        query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueLessThanOrEqual("aShortValue", (Object)123);
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByIntegerCaseInstanceVariableValueLessThanOrEquals() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("anIntegerValue", (Object)456).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueLessThanOrEqual("anIntegerValue", (Object)457);
        this.verifyQueryResults(query, 2);
        query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueLessThanOrEqual("anIntegerValue", (Object)456);
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByLongCaseInstanceVariableValueLessThanOrEqual() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aLongValue", (Object)789L).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueLessThanOrEqual("aLongValue", (Object)790L);
        this.verifyQueryResults(query, 2);
        query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueLessThanOrEqual("aLongValue", (Object)789L);
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByDateCaseInstanceVariableValueLessThanOrEqual() {
        Date now = new Date();
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aDateValue", (Object)now).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        Date after = new Date(now.getTime() + 100000L);
        query.caseInstanceVariableValueLessThanOrEqual("aDateValue", (Object)after);
        this.verifyQueryResults(query, 2);
        query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueLessThanOrEqual("aDateValue", (Object)now);
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByDoubleCaseInstanceVariableValueLessThanOrEqual() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aDoubleValue", (Object)1.5).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueLessThanOrEqual("aDoubleValue", (Object)1.6);
        this.verifyQueryResults(query, 2);
        query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueLessThanOrEqual("aDoubleValue", (Object)1.5);
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByByteArrayCaseInstanceVariableValueLessThanOrEqual() {
        byte[] bytes = "somebytes".getBytes();
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aByteArrayValue", (Object)bytes).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueLessThanOrEqual("aByteArrayValue", (Object)bytes).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryBySerializableCaseInstanceVariableLessThanOrEqual() {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aSerializableValue", serializable).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueLessThanOrEqual("aSerializableValue", serializable).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByNullCaseInstanceVariableValueLike() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aNullValue", null).create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        try {
            query.caseInstanceVariableValueLike("aNullValue", null).list();
            CaseExecutionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByStringCaseInstanceVariableValueLike() {
        this.caseService.createCaseInstanceByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueLike("aStringValue", "ab%");
        this.verifyQueryResults(query, 2);
        query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueLike("aStringValue", "%bc");
        this.verifyQueryResults(query, 2);
        query = this.caseService.createCaseExecutionQuery();
        query.caseInstanceVariableValueLike("aStringValue", "%b%");
        this.verifyQueryResults(query, 2);
    }

    public void testQuerySorting() {
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        query.orderByCaseDefinitionId().asc();
        this.verifyQueryResults(query, 11);
        query = this.caseService.createCaseExecutionQuery();
        query.orderByCaseDefinitionKey().asc();
        this.verifyQueryResults(query, 11);
        query = this.caseService.createCaseExecutionQuery();
        query.orderByCaseExecutionId().asc();
        this.verifyQueryResults(query, 11);
        query = this.caseService.createCaseExecutionQuery();
        query.orderByCaseDefinitionId().desc();
        this.verifyQueryResults(query, 11);
        query = this.caseService.createCaseExecutionQuery();
        query.orderByCaseDefinitionKey().desc();
        this.verifyQueryResults(query, 11);
        query = this.caseService.createCaseExecutionQuery();
        query.orderByCaseExecutionId().desc();
        this.verifyQueryResults(query, 11);
        query = this.caseService.createCaseExecutionQuery();
    }
}

