/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.history.HistoricDetail;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.impl.RuntimeServiceImpl;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricDetailVariableInstanceUpdateEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.CollectionUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class RuntimeServiceTest
extends PluggableProcessEngineTestCase {
    public void testStartProcessInstanceByKeyNullKey() {
        try {
            this.runtimeService.startProcessInstanceByKey(null);
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testStartProcessInstanceByKeyUnexistingKey() {
        try {
            this.runtimeService.startProcessInstanceByKey("unexistingkey");
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("no processes deployed with key", ae.getMessage());
        }
    }

    public void testStartProcessInstanceByIdNullId() {
        try {
            this.runtimeService.startProcessInstanceById(null);
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testStartProcessInstanceByIdUnexistingId() {
        try {
            this.runtimeService.startProcessInstanceById("unexistingId");
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("no deployed process definition found with id", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testStartProcessInstanceByIdNullVariables() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)null);
        RuntimeServiceTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("oneTaskProcess").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void startProcessInstanceWithBusinessKey() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "123");
        RuntimeServiceTest.assertNotNull((Object)processInstance);
        RuntimeServiceTest.assertEquals((String)"123", (String)processInstance.getBusinessKey());
        RuntimeServiceTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("oneTaskProcess").count());
        processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "456", CollectionUtil.singletonMap((String)"var", (Object)"value"));
        RuntimeServiceTest.assertNotNull((Object)processInstance);
        RuntimeServiceTest.assertEquals((long)2L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("oneTaskProcess").count());
        RuntimeServiceTest.assertEquals((Object)"var", (Object)this.runtimeService.getVariable(processInstance.getId(), "var"));
        processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId(), "789");
        RuntimeServiceTest.assertNotNull((Object)processInstance);
        RuntimeServiceTest.assertEquals((long)3L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("oneTaskProcess").count());
        processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId(), "101123", CollectionUtil.singletonMap((String)"var", (Object)"value2"));
        RuntimeServiceTest.assertNotNull((Object)processInstance);
        RuntimeServiceTest.assertEquals((long)4L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("oneTaskProcess").count());
        RuntimeServiceTest.assertEquals((Object)"var", (Object)this.runtimeService.getVariable(processInstance.getId(), "var"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testDeleteProcessInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        RuntimeServiceTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("oneTaskProcess").count());
        String deleteReason = "testing instance deletion";
        this.runtimeService.deleteProcessInstance(processInstance.getId(), deleteReason);
        RuntimeServiceTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("oneTaskProcess").count());
        if (!"none".equals(this.processEngineConfiguration.getHistory())) {
            HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
            RuntimeServiceTest.assertEquals((String)deleteReason, (String)historicTaskInstance.getDeleteReason());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testDeleteProcessInstanceNullReason() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        RuntimeServiceTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("oneTaskProcess").count());
        this.runtimeService.deleteProcessInstance(processInstance.getId(), null);
        RuntimeServiceTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("oneTaskProcess").count());
    }

    public void testDeleteProcessInstanceUnexistingId() {
        try {
            this.runtimeService.deleteProcessInstance("enexistingInstanceId", null);
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("No process instance found for id", ae.getMessage());
            RuntimeServiceTest.assertTrue((boolean)(ae instanceof BadUserRequestException));
        }
    }

    public void testDeleteProcessInstanceNullId() {
        try {
            this.runtimeService.deleteProcessInstance(null, "test null id delete");
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("processInstanceId is null", ae.getMessage());
            RuntimeServiceTest.assertTrue((boolean)(ae instanceof BadUserRequestException));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testFindActiveActivityIds() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        List activities = this.runtimeService.getActiveActivityIds(processInstance.getId());
        RuntimeServiceTest.assertNotNull((Object)activities);
        RuntimeServiceTest.assertEquals((int)1, (int)activities.size());
    }

    public void testFindActiveActivityIdsUnexistingExecututionId() {
        try {
            this.runtimeService.getActiveActivityIds("unexistingExecutionId");
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("execution unexistingExecutionId doesn't exist", ae.getMessage());
        }
    }

    public void testFindActiveActivityIdsNullExecututionId() {
        try {
            this.runtimeService.getActiveActivityIds(null);
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("executionId is null", ae.getMessage());
        }
    }

    @Deployment
    public void testFindActiveActivityIdProcessWithErrorEventAndSubProcess() {
        ProcessInstance processInstance = this.processEngine.getRuntimeService().startProcessInstanceByKey("errorEventSubprocess");
        List activeActivities = this.runtimeService.getActiveActivityIds(processInstance.getId());
        RuntimeServiceTest.assertEquals((int)3, (int)activeActivities.size());
        List tasks = this.taskService.createTaskQuery().list();
        RuntimeServiceTest.assertEquals((int)2, (int)tasks.size());
        Task parallelUserTask = null;
        for (Task task : tasks) {
            if (!task.getName().equals("ParallelUserTask") && !task.getName().equals("MainUserTask")) {
                RuntimeServiceTest.fail((String)("Expected: <ParallelUserTask> or <MainUserTask> but was <" + task.getName() + ">."));
            }
            if (!task.getName().equals("ParallelUserTask")) continue;
            parallelUserTask = task;
        }
        RuntimeServiceTest.assertNotNull(parallelUserTask);
        this.taskService.complete(parallelUserTask.getId());
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId()).activityId("subprocess1WaitBeforeError").singleResult();
        this.runtimeService.signal(execution.getId());
        activeActivities = this.runtimeService.getActiveActivityIds(processInstance.getId());
        RuntimeServiceTest.assertEquals((int)2, (int)activeActivities.size());
        tasks = this.taskService.createTaskQuery().list();
        RuntimeServiceTest.assertEquals((int)2, (int)tasks.size());
        Task beforeErrorUserTask = null;
        for (Task task : tasks) {
            if (!task.getName().equals("BeforeError") && !task.getName().equals("MainUserTask")) {
                RuntimeServiceTest.fail((String)("Expected: <BeforeError> or <MainUserTask> but was <" + task.getName() + ">."));
            }
            if (!task.getName().equals("BeforeError")) continue;
            beforeErrorUserTask = task;
        }
        RuntimeServiceTest.assertNotNull(beforeErrorUserTask);
        this.taskService.complete(beforeErrorUserTask.getId());
        activeActivities = this.runtimeService.getActiveActivityIds(processInstance.getId());
        RuntimeServiceTest.assertEquals((int)2, (int)activeActivities.size());
        tasks = this.taskService.createTaskQuery().list();
        RuntimeServiceTest.assertEquals((int)2, (int)tasks.size());
        Task afterErrorUserTask = null;
        for (Task task : tasks) {
            if (!task.getName().equals("AfterError") && !task.getName().equals("MainUserTask")) {
                RuntimeServiceTest.fail((String)("Expected: <AfterError> or <MainUserTask> but was <" + task.getName() + ">."));
            }
            if (!task.getName().equals("AfterError")) continue;
            afterErrorUserTask = task;
        }
        RuntimeServiceTest.assertNotNull(afterErrorUserTask);
        this.taskService.complete(afterErrorUserTask.getId());
        tasks = this.taskService.createTaskQuery().list();
        RuntimeServiceTest.assertEquals((int)1, (int)tasks.size());
        RuntimeServiceTest.assertEquals((String)"MainUserTask", (String)((Task)tasks.get(0)).getName());
        activeActivities = this.runtimeService.getActiveActivityIds(processInstance.getId());
        RuntimeServiceTest.assertEquals((int)1, (int)activeActivities.size());
        RuntimeServiceTest.assertEquals((String)"MainUserTask", (String)((String)activeActivities.get(0)));
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.assertProcessEnded(processInstance.getId());
    }

    public void testSignalUnexistingExecututionId() {
        try {
            this.runtimeService.signal("unexistingExecutionId");
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("execution unexistingExecutionId doesn't exist", ae.getMessage());
            RuntimeServiceTest.assertTrue((boolean)(ae instanceof BadUserRequestException));
        }
    }

    public void testSignalNullExecutionId() {
        try {
            this.runtimeService.signal(null);
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("executionId is null", ae.getMessage());
            RuntimeServiceTest.assertTrue((boolean)(ae instanceof BadUserRequestException));
        }
    }

    @Deployment
    public void testSignalWithProcessVariables() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testSignalWithProcessVariables");
        HashMap<String, String> processVariables = new HashMap<String, String>();
        processVariables.put("variable", "value");
        this.runtimeService.signal(processInstance.getId(), processVariables);
        Map variables = this.runtimeService.getVariables(processInstance.getId());
        RuntimeServiceTest.assertEquals((Object)variables, processVariables);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/RuntimeServiceTest.testSignalWithProcessVariables.bpmn20.xml"})
    public void testSignalWithSignalNameAndData() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testSignalWithProcessVariables");
        HashMap<String, String> processVariables = new HashMap<String, String>();
        processVariables.put("variable", "value");
        this.runtimeService.signal(processInstance.getId(), "dummySignalName", (Object)new String("SignalData"), processVariables);
        Map variables = this.runtimeService.getVariables(processInstance.getId());
        RuntimeServiceTest.assertEquals((Object)variables, processVariables);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/RuntimeServiceTest.testSignalWithProcessVariables.bpmn20.xml"})
    public void testSignalWithoutSignalNameAndData() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testSignalWithProcessVariables");
        HashMap<String, String> processVariables = new HashMap<String, String>();
        processVariables.put("variable", "value");
        this.runtimeService.signal(processInstance.getId(), null, null, processVariables);
        Map variables = this.runtimeService.getVariables(processInstance.getId());
        RuntimeServiceTest.assertEquals((Object)variables, processVariables);
    }

    @Deployment
    public void testSignalInactiveExecution() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("testSignalInactiveExecution");
        try {
            this.runtimeService.signal(instance.getId());
            RuntimeServiceTest.fail();
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("cannot signal execution " + instance.getId() + ": it has no current activity", e.getMessage());
        }
        catch (Exception e) {
            RuntimeServiceTest.fail((String)"Signalling an inactive execution that has no activity should result in a ProcessEngineException");
        }
    }

    public void testGetVariablesUnexistingExecutionId() {
        try {
            this.runtimeService.getVariables("unexistingExecutionId");
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("execution unexistingExecutionId doesn't exist", ae.getMessage());
        }
    }

    public void testGetVariablesNullExecutionId() {
        try {
            this.runtimeService.getVariables(null);
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("executionId is null", ae.getMessage());
        }
    }

    public void testGetVariableUnexistingExecutionId() {
        try {
            this.runtimeService.getVariables("unexistingExecutionId");
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("execution unexistingExecutionId doesn't exist", ae.getMessage());
        }
    }

    public void testGetVariableNullExecutionId() {
        try {
            this.runtimeService.getVariables(null);
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("executionId is null", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testGetVariableUnexistingVariableName() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Object variableValue = this.runtimeService.getVariable(processInstance.getId(), "unexistingVariable");
        RuntimeServiceTest.assertNull((Object)variableValue);
    }

    public void testSetVariableUnexistingExecutionId() {
        try {
            this.runtimeService.setVariable("unexistingExecutionId", "variableName", (Object)"value");
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("execution unexistingExecutionId doesn't exist", ae.getMessage());
        }
    }

    public void testSetVariableNullExecutionId() {
        try {
            this.runtimeService.setVariable(null, "variableName", (Object)"variableValue");
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("executionId is null", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSetVariableNullVariableName() {
        try {
            ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
            this.runtimeService.setVariable(processInstance.getId(), null, (Object)"variableValue");
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("variableName is null", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSetVariables() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("variable1", "value1");
        vars.put("variable2", "value2");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.setVariables(processInstance.getId(), vars);
        RuntimeServiceTest.assertEquals((Object)"value1", (Object)this.runtimeService.getVariable(processInstance.getId(), "variable1"));
        RuntimeServiceTest.assertEquals((Object)"value2", (Object)this.runtimeService.getVariable(processInstance.getId(), "variable2"));
    }

    public void testSetVariablesUnexistingExecutionId() {
        try {
            this.runtimeService.setVariables("unexistingexecution", Collections.EMPTY_MAP);
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("execution unexistingexecution doesn't exist", ae.getMessage());
        }
    }

    public void testSetVariablesNullExecutionId() {
        try {
            this.runtimeService.setVariables(null, Collections.EMPTY_MAP);
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("executionId is null", ae.getMessage());
        }
    }

    private void checkHistoricVariableUpdateEntity(String variableName, String processInstanceId) {
        if (this.processEngineConfiguration.getHistoryLevel() == 3) {
            boolean deletedVariableUpdateFound = false;
            List resultSet = this.historyService.createHistoricDetailQuery().processInstanceId(processInstanceId).list();
            for (HistoricDetail currentHistoricDetail : resultSet) {
                RuntimeServiceTest.assertTrue((boolean)(currentHistoricDetail instanceof HistoricDetailVariableInstanceUpdateEntity));
                HistoricDetailVariableInstanceUpdateEntity historicVariableUpdate = (HistoricDetailVariableInstanceUpdateEntity)currentHistoricDetail;
                if (!historicVariableUpdate.getName().equals(variableName) || historicVariableUpdate.getValue() != null) continue;
                if (deletedVariableUpdateFound) {
                    RuntimeServiceTest.fail((String)"Mismatch: A HistoricVariableUpdateEntity with a null value already found");
                    continue;
                }
                deletedVariableUpdateFound = true;
            }
            RuntimeServiceTest.assertTrue((boolean)deletedVariableUpdateFound);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testRemoveVariable() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("variable1", "value1");
        vars.put("variable2", "value2");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.setVariables(processInstance.getId(), vars);
        this.runtimeService.removeVariable(processInstance.getId(), "variable1");
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "variable1"));
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariableLocal(processInstance.getId(), "variable1"));
        RuntimeServiceTest.assertEquals((Object)"value2", (Object)this.runtimeService.getVariable(processInstance.getId(), "variable2"));
        this.checkHistoricVariableUpdateEntity("variable1", processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneSubProcess.bpmn20.xml"})
    public void testRemoveVariableInParentScope() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("variable1", "value1");
        vars.put("variable2", "value2");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("startSimpleSubProcess", vars);
        Task currentTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.runtimeService.removeVariable(currentTask.getExecutionId(), "variable1");
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "variable1"));
        RuntimeServiceTest.assertEquals((Object)"value2", (Object)this.runtimeService.getVariable(processInstance.getId(), "variable2"));
        this.checkHistoricVariableUpdateEntity("variable1", processInstance.getId());
    }

    public void testRemoveVariableNullExecutionId() {
        try {
            this.runtimeService.removeVariable(null, "variable");
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("executionId is null", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testRemoveVariableLocal() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("variable1", "value1");
        vars.put("variable2", "value2");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        this.runtimeService.removeVariableLocal(processInstance.getId(), "variable1");
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "variable1"));
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariableLocal(processInstance.getId(), "variable1"));
        RuntimeServiceTest.assertEquals((Object)"value2", (Object)this.runtimeService.getVariable(processInstance.getId(), "variable2"));
        this.checkHistoricVariableUpdateEntity("variable1", processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneSubProcess.bpmn20.xml"})
    public void testRemoveVariableLocalWithParentScope() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("variable1", "value1");
        vars.put("variable2", "value2");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("startSimpleSubProcess", vars);
        Task currentTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.runtimeService.setVariableLocal(currentTask.getExecutionId(), "localVariable", (Object)"local value");
        RuntimeServiceTest.assertEquals((Object)"local value", (Object)this.runtimeService.getVariableLocal(currentTask.getExecutionId(), "localVariable"));
        this.runtimeService.removeVariableLocal(currentTask.getExecutionId(), "localVariable");
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "localVariable"));
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariableLocal(currentTask.getExecutionId(), "localVariable"));
        RuntimeServiceTest.assertEquals((Object)"value1", (Object)this.runtimeService.getVariable(processInstance.getId(), "variable1"));
        RuntimeServiceTest.assertEquals((Object)"value2", (Object)this.runtimeService.getVariable(processInstance.getId(), "variable2"));
        RuntimeServiceTest.assertEquals((Object)"value1", (Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable1"));
        RuntimeServiceTest.assertEquals((Object)"value2", (Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable2"));
        this.checkHistoricVariableUpdateEntity("localVariable", processInstance.getId());
    }

    public void testRemoveLocalVariableNullExecutionId() {
        try {
            this.runtimeService.removeVariableLocal(null, "variable");
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("executionId is null", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testRemoveVariables() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("variable1", "value1");
        vars.put("variable2", "value2");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        this.runtimeService.setVariable(processInstance.getId(), "variable3", (Object)"value3");
        this.runtimeService.removeVariables(processInstance.getId(), vars.keySet());
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "variable1"));
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariableLocal(processInstance.getId(), "variable1"));
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "variable2"));
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariableLocal(processInstance.getId(), "variable2"));
        RuntimeServiceTest.assertEquals((Object)"value3", (Object)this.runtimeService.getVariable(processInstance.getId(), "variable3"));
        RuntimeServiceTest.assertEquals((Object)"value3", (Object)this.runtimeService.getVariableLocal(processInstance.getId(), "variable3"));
        this.checkHistoricVariableUpdateEntity("variable1", processInstance.getId());
        this.checkHistoricVariableUpdateEntity("variable2", processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneSubProcess.bpmn20.xml"})
    public void testRemoveVariablesWithParentScope() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("variable1", "value1");
        vars.put("variable2", "value2");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("startSimpleSubProcess", vars);
        this.runtimeService.setVariable(processInstance.getId(), "variable3", (Object)"value3");
        Task currentTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.runtimeService.removeVariables(currentTask.getExecutionId(), vars.keySet());
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "variable1"));
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariableLocal(processInstance.getId(), "variable1"));
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "variable2"));
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariableLocal(processInstance.getId(), "variable2"));
        RuntimeServiceTest.assertEquals((Object)"value3", (Object)this.runtimeService.getVariable(processInstance.getId(), "variable3"));
        RuntimeServiceTest.assertEquals((Object)"value3", (Object)this.runtimeService.getVariableLocal(processInstance.getId(), "variable3"));
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable1"));
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable2"));
        RuntimeServiceTest.assertEquals((Object)"value3", (Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable3"));
        this.checkHistoricVariableUpdateEntity("variable1", processInstance.getId());
        this.checkHistoricVariableUpdateEntity("variable2", processInstance.getId());
    }

    public void testRemoveVariablesNullExecutionId() {
        try {
            this.runtimeService.removeVariables(null, (Collection)Collections.EMPTY_LIST);
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("executionId is null", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneSubProcess.bpmn20.xml"})
    public void testRemoveVariablesLocalWithParentScope() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("variable1", "value1");
        vars.put("variable2", "value2");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("startSimpleSubProcess", vars);
        Task currentTask = (Task)this.taskService.createTaskQuery().singleResult();
        HashMap<String, String> varsToDelete = new HashMap<String, String>();
        varsToDelete.put("variable3", "value3");
        varsToDelete.put("variable4", "value4");
        varsToDelete.put("variable5", "value5");
        this.runtimeService.setVariablesLocal(currentTask.getExecutionId(), varsToDelete);
        this.runtimeService.setVariableLocal(currentTask.getExecutionId(), "variable6", (Object)"value6");
        RuntimeServiceTest.assertEquals((Object)"value3", (Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable3"));
        RuntimeServiceTest.assertEquals((Object)"value3", (Object)this.runtimeService.getVariableLocal(currentTask.getExecutionId(), "variable3"));
        RuntimeServiceTest.assertEquals((Object)"value4", (Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable4"));
        RuntimeServiceTest.assertEquals((Object)"value4", (Object)this.runtimeService.getVariableLocal(currentTask.getExecutionId(), "variable4"));
        RuntimeServiceTest.assertEquals((Object)"value5", (Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable5"));
        RuntimeServiceTest.assertEquals((Object)"value5", (Object)this.runtimeService.getVariableLocal(currentTask.getExecutionId(), "variable5"));
        RuntimeServiceTest.assertEquals((Object)"value6", (Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable6"));
        RuntimeServiceTest.assertEquals((Object)"value6", (Object)this.runtimeService.getVariableLocal(currentTask.getExecutionId(), "variable6"));
        this.runtimeService.removeVariablesLocal(currentTask.getExecutionId(), varsToDelete.keySet());
        RuntimeServiceTest.assertEquals((Object)"value1", (Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable1"));
        RuntimeServiceTest.assertEquals((Object)"value2", (Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable2"));
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable3"));
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariableLocal(currentTask.getExecutionId(), "variable3"));
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable4"));
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariableLocal(currentTask.getExecutionId(), "variable4"));
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable5"));
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariableLocal(currentTask.getExecutionId(), "variable5"));
        RuntimeServiceTest.assertEquals((Object)"value6", (Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable6"));
        RuntimeServiceTest.assertEquals((Object)"value6", (Object)this.runtimeService.getVariableLocal(currentTask.getExecutionId(), "variable6"));
        this.checkHistoricVariableUpdateEntity("variable3", processInstance.getId());
        this.checkHistoricVariableUpdateEntity("variable4", processInstance.getId());
        this.checkHistoricVariableUpdateEntity("variable5", processInstance.getId());
    }

    public void testRemoveVariablesLocalNullExecutionId() {
        try {
            this.runtimeService.removeVariablesLocal(null, (Collection)Collections.EMPTY_LIST);
            RuntimeServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("executionId is null", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testUpdateVariables() {
        HashMap<String, String> modifications = new HashMap<String, String>();
        modifications.put("variable1", "value1");
        modifications.put("variable2", "value2");
        ArrayList<String> deletions = new ArrayList<String>();
        deletions.add("variable1");
        HashMap<String, String> initialVariables = new HashMap<String, String>();
        initialVariables.put("variable1", "initialValue");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", initialVariables);
        ((RuntimeServiceImpl)this.runtimeService).updateVariables(processInstance.getId(), modifications, deletions);
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "variable1"));
        RuntimeServiceTest.assertEquals((Object)"value2", (Object)this.runtimeService.getVariable(processInstance.getId(), "variable2"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneSubProcess.bpmn20.xml"})
    public void testUpdateVariablesLocal() {
        HashMap<String, String> globalVars = new HashMap<String, String>();
        globalVars.put("variable4", "value4");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("startSimpleSubProcess", globalVars);
        Task currentTask = (Task)this.taskService.createTaskQuery().singleResult();
        HashMap<String, String> localVars = new HashMap<String, String>();
        localVars.put("variable1", "value1");
        localVars.put("variable2", "value2");
        localVars.put("variable3", "value3");
        this.runtimeService.setVariablesLocal(currentTask.getExecutionId(), localVars);
        HashMap<String, String> modifications = new HashMap<String, String>();
        modifications.put("variable1", "anotherValue1");
        modifications.put("variable2", "anotherValue2");
        ArrayList<String> deletions = new ArrayList<String>();
        deletions.add("variable2");
        deletions.add("variable3");
        deletions.add("variable4");
        ((RuntimeServiceImpl)this.runtimeService).updateVariablesLocal(currentTask.getExecutionId(), modifications, deletions);
        RuntimeServiceTest.assertEquals((Object)"anotherValue1", (Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable1"));
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable2"));
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getVariable(currentTask.getExecutionId(), "variable3"));
        RuntimeServiceTest.assertEquals((Object)"value4", (Object)this.runtimeService.getVariable(processInstance.getId(), "variable4"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/RuntimeServiceTest.catchAlertSignal.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/RuntimeServiceTest.catchPanicSignal.bpmn20.xml"})
    public void testSignalEventReceived() {
        List page;
        int executions;
        this.startSignalCatchProcesses();
        RuntimeServiceTest.assertEquals((long)12L, (long)this.runtimeService.createExecutionQuery().count());
        this.runtimeService.signalEventReceived("alert");
        RuntimeServiceTest.assertEquals((long)6L, (long)this.runtimeService.createExecutionQuery().count());
        this.runtimeService.signalEventReceived("panic");
        RuntimeServiceTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
        this.startSignalCatchProcesses();
        for (executions = 3; executions > 0; --executions) {
            page = this.runtimeService.createExecutionQuery().signalEventSubscriptionName("alert").listPage(0, 1);
            this.runtimeService.signalEventReceived("alert", ((Execution)page.get(0)).getId());
            RuntimeServiceTest.assertEquals((long)(executions - 1), (long)this.runtimeService.createExecutionQuery().signalEventSubscriptionName("alert").count());
        }
        for (executions = 3; executions > 0; --executions) {
            page = this.runtimeService.createExecutionQuery().signalEventSubscriptionName("panic").listPage(0, 1);
            this.runtimeService.signalEventReceived("panic", ((Execution)page.get(0)).getId());
            RuntimeServiceTest.assertEquals((long)(executions - 1), (long)this.runtimeService.createExecutionQuery().signalEventSubscriptionName("panic").count());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/RuntimeServiceTest.catchAlertMessage.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/RuntimeServiceTest.catchPanicMessage.bpmn20.xml"})
    public void testMessageEventReceived() {
        List page;
        int executions;
        this.startMessageCatchProcesses();
        RuntimeServiceTest.assertEquals((long)12L, (long)this.runtimeService.createExecutionQuery().count());
        for (executions = 3; executions > 0; --executions) {
            page = this.runtimeService.createExecutionQuery().messageEventSubscriptionName("alert").listPage(0, 1);
            this.runtimeService.messageEventReceived("alert", ((Execution)page.get(0)).getId());
            RuntimeServiceTest.assertEquals((long)(executions - 1), (long)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("alert").count());
        }
        for (executions = 3; executions > 0; --executions) {
            page = this.runtimeService.createExecutionQuery().messageEventSubscriptionName("panic").listPage(0, 1);
            this.runtimeService.messageEventReceived("panic", ((Execution)page.get(0)).getId());
            RuntimeServiceTest.assertEquals((long)(executions - 1), (long)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("panic").count());
        }
    }

    public void testSignalEventReceivedNonExistingExecution() {
        try {
            this.runtimeService.signalEventReceived("alert", "nonexistingExecution");
            RuntimeServiceTest.fail((String)"exeception expected");
        }
        catch (ProcessEngineException e) {
            RuntimeServiceTest.assertTrue((boolean)e.getMessage().contains("Cannot find execution with id 'nonexistingExecution'"));
        }
    }

    public void testMessageEventReceivedNonExistingExecution() {
        try {
            this.runtimeService.messageEventReceived("alert", "nonexistingExecution");
            RuntimeServiceTest.fail((String)"exeception expected");
        }
        catch (ProcessEngineException e) {
            RuntimeServiceTest.assertTrue((boolean)e.getMessage().contains("Execution with id 'nonexistingExecution' does not have a subscription to a message event with name 'alert'"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/RuntimeServiceTest.catchAlertSignal.bpmn20.xml"})
    public void testExecutionWaitingForDifferentSignal() {
        this.runtimeService.startProcessInstanceByKey("catchAlertSignal");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().signalEventSubscriptionName("alert").singleResult();
        try {
            this.runtimeService.signalEventReceived("bogusSignal", execution.getId());
            RuntimeServiceTest.fail((String)"exeception expected");
        }
        catch (ProcessEngineException e) {
            RuntimeServiceTest.assertTrue((boolean)e.getMessage().contains("has not subscribed to a signal event with name 'bogusSignal'"));
        }
    }

    private void startSignalCatchProcesses() {
        for (int i = 0; i < 3; ++i) {
            this.runtimeService.startProcessInstanceByKey("catchAlertSignal");
            this.runtimeService.startProcessInstanceByKey("catchPanicSignal");
        }
    }

    private void startMessageCatchProcesses() {
        for (int i = 0; i < 3; ++i) {
            this.runtimeService.startProcessInstanceByKey("catchAlertMessage");
            this.runtimeService.startProcessInstanceByKey("catchPanicMessage");
        }
    }

    public void testActivityInstanceForNonExistingProcessInstanceId() {
        RuntimeServiceTest.assertNull((Object)this.runtimeService.getActivityInstance("some-nonexisting-id"));
    }

    public void testActivityInstanceForNullProcessInstanceId() {
        try {
            this.runtimeService.getActivityInstance(null);
            RuntimeServiceTest.fail((String)"PEE expected!");
        }
        catch (ProcessEngineException engineException) {
            RuntimeServiceTest.assertTrue((boolean)engineException.getMessage().contains("processInstanceId cannot be null"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testActivityInstancePopulated() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", "business-key");
        ActivityInstance rootActInstance = this.runtimeService.getActivityInstance(processInstance.getId());
        RuntimeServiceTest.assertEquals((String)processInstance.getId(), (String)rootActInstance.getProcessInstanceId());
        RuntimeServiceTest.assertEquals((String)processInstance.getProcessDefinitionId(), (String)rootActInstance.getProcessDefinitionId());
        RuntimeServiceTest.assertEquals((String)processInstance.getId(), (String)rootActInstance.getProcessInstanceId());
        RuntimeServiceTest.assertTrue((boolean)rootActInstance.getExecutionIds()[0].equals(processInstance.getId()));
        RuntimeServiceTest.assertEquals((String)rootActInstance.getProcessDefinitionId(), (String)rootActInstance.getActivityId());
        RuntimeServiceTest.assertNull((Object)rootActInstance.getParentActivityInstanceId());
        RuntimeServiceTest.assertEquals((String)"processDefinition", (String)rootActInstance.getActivityType());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        ActivityInstance childActivityInstance = rootActInstance.getChildActivityInstances()[0];
        RuntimeServiceTest.assertEquals((String)processInstance.getId(), (String)childActivityInstance.getProcessInstanceId());
        RuntimeServiceTest.assertEquals((String)processInstance.getProcessDefinitionId(), (String)childActivityInstance.getProcessDefinitionId());
        RuntimeServiceTest.assertEquals((String)processInstance.getId(), (String)childActivityInstance.getProcessInstanceId());
        RuntimeServiceTest.assertTrue((boolean)childActivityInstance.getExecutionIds()[0].equals(task.getExecutionId()));
        RuntimeServiceTest.assertEquals((String)"theTask", (String)childActivityInstance.getActivityId());
        RuntimeServiceTest.assertEquals((String)rootActInstance.getId(), (String)childActivityInstance.getParentActivityInstanceId());
        RuntimeServiceTest.assertEquals((String)"userTask", (String)childActivityInstance.getActivityType());
        RuntimeServiceTest.assertNotNull((Object)childActivityInstance.getChildActivityInstances());
        RuntimeServiceTest.assertNotNull((Object)childActivityInstance.getChildTransitionInstances());
        RuntimeServiceTest.assertEquals((int)0, (int)childActivityInstance.getChildActivityInstances().length);
        RuntimeServiceTest.assertEquals((int)0, (int)childActivityInstance.getChildTransitionInstances().length);
    }
}

