/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.task;

import java.util.Date;
import java.util.List;
import junit.framework.TestCase;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.CommentEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.task.Attachment;
import org.camunda.bpm.engine.task.Event;
import org.camunda.bpm.engine.task.Task;

public class TaskEventsTest
extends PluggableProcessEngineTestCase {
    static String JONNY = "jonny";
    static String ACCOUNTING = "accounting";
    static String IMAGE_PNG = "application/png";
    static String IMAGE_NAME = "my-image.png";
    static String IMAGE_DESC = "a super duper image";
    static String IMAGE_URL = "file://some/location/my-image.png";
    private Task task;

    protected void setUp() throws Exception {
        this.task = this.taskService.newTask();
        this.taskService.saveTask(this.task);
    }

    protected void tearDown() throws Exception {
        this.taskService.deleteTask(this.task.getId());
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                commandContext.getHistoricTaskInstanceManager().deleteHistoricTaskInstanceById(TaskEventsTest.this.task.getId());
                return null;
            }
        });
    }

    public void testAddUserLinkEvents() {
        TaskEventsTest.assertTrue((boolean)this.taskService.getTaskEvents(this.task.getId()).isEmpty());
        this.taskService.addCandidateUser(this.task.getId(), JONNY);
        List events = this.taskService.getTaskEvents(this.task.getId());
        TaskEventsTest.assertEquals((int)1, (int)events.size());
        Event event = (Event)events.get(0);
        TaskEventsTest.assertEquals((String)JONNY, (String)((String)event.getMessageParts().get(0)));
        TaskEventsTest.assertEquals((String)"candidate", (String)((String)event.getMessageParts().get(1)));
        TaskEventsTest.assertEquals((String)this.task.getId(), (String)event.getTaskId());
        TaskEventsTest.assertEquals((String)"AddUserLink", (String)event.getAction());
        TaskEventsTest.assertEquals((String)(JONNY + CommentEntity.MESSAGE_PARTS_MARKER + "candidate"), (String)event.getMessage());
        TaskEventsTest.assertEquals(null, (String)event.getProcessInstanceId());
        TaskEventsTest.assertNotNull((Object)(event.getTime().getTime() <= ClockUtil.getCurrentTime().getTime() ? 1 : 0));
        this.assertNoCommentsForTask();
    }

    public void testDeleteUserLinkEvents() {
        TaskEventsTest.assertTrue((boolean)this.taskService.getTaskEvents(this.task.getId()).isEmpty());
        this.taskService.addCandidateUser(this.task.getId(), JONNY);
        ClockUtil.setCurrentTime((Date)new Date(ClockUtil.getCurrentTime().getTime() + 5000L));
        this.taskService.deleteCandidateUser(this.task.getId(), JONNY);
        List events = this.taskService.getTaskEvents(this.task.getId());
        TaskEventsTest.assertEquals((int)2, (int)events.size());
        Event event = (Event)events.get(0);
        TaskEventsTest.assertEquals((String)JONNY, (String)((String)event.getMessageParts().get(0)));
        TaskEventsTest.assertEquals((String)"candidate", (String)((String)event.getMessageParts().get(1)));
        TaskEventsTest.assertEquals((String)this.task.getId(), (String)event.getTaskId());
        TaskEventsTest.assertEquals((String)"DeleteUserLink", (String)event.getAction());
        TaskEventsTest.assertEquals((String)(JONNY + CommentEntity.MESSAGE_PARTS_MARKER + "candidate"), (String)event.getMessage());
        TaskEventsTest.assertEquals(null, (String)event.getProcessInstanceId());
        TaskEventsTest.assertNotNull((Object)(event.getTime().getTime() <= ClockUtil.getCurrentTime().getTime() ? 1 : 0));
        this.assertNoCommentsForTask();
    }

    public void testAddGroupLinkEvents() {
        TaskEventsTest.assertTrue((boolean)this.taskService.getTaskEvents(this.task.getId()).isEmpty());
        this.taskService.addCandidateGroup(this.task.getId(), ACCOUNTING);
        List events = this.taskService.getTaskEvents(this.task.getId());
        TaskEventsTest.assertEquals((int)1, (int)events.size());
        Event event = (Event)events.get(0);
        TaskEventsTest.assertEquals((String)ACCOUNTING, (String)((String)event.getMessageParts().get(0)));
        TaskEventsTest.assertEquals((String)"candidate", (String)((String)event.getMessageParts().get(1)));
        TaskEventsTest.assertEquals((String)this.task.getId(), (String)event.getTaskId());
        TaskEventsTest.assertEquals((String)"AddGroupLink", (String)event.getAction());
        TaskEventsTest.assertEquals((String)(ACCOUNTING + CommentEntity.MESSAGE_PARTS_MARKER + "candidate"), (String)event.getMessage());
        TaskEventsTest.assertEquals(null, (String)event.getProcessInstanceId());
        TaskEventsTest.assertNotNull((Object)(event.getTime().getTime() <= ClockUtil.getCurrentTime().getTime() ? 1 : 0));
        this.assertNoCommentsForTask();
    }

    public void testDeleteGroupLinkEvents() {
        TaskEventsTest.assertTrue((boolean)this.taskService.getTaskEvents(this.task.getId()).isEmpty());
        this.taskService.addCandidateGroup(this.task.getId(), ACCOUNTING);
        ClockUtil.setCurrentTime((Date)new Date(ClockUtil.getCurrentTime().getTime() + 5000L));
        this.taskService.deleteCandidateGroup(this.task.getId(), ACCOUNTING);
        List events = this.taskService.getTaskEvents(this.task.getId());
        TaskEventsTest.assertEquals((int)2, (int)events.size());
        Event event = (Event)events.get(0);
        TaskEventsTest.assertEquals((String)ACCOUNTING, (String)((String)event.getMessageParts().get(0)));
        TaskEventsTest.assertEquals((String)"candidate", (String)((String)event.getMessageParts().get(1)));
        TaskEventsTest.assertEquals((String)this.task.getId(), (String)event.getTaskId());
        TaskEventsTest.assertEquals((String)"DeleteGroupLink", (String)event.getAction());
        TaskEventsTest.assertEquals((String)(ACCOUNTING + CommentEntity.MESSAGE_PARTS_MARKER + "candidate"), (String)event.getMessage());
        TaskEventsTest.assertEquals(null, (String)event.getProcessInstanceId());
        TaskEventsTest.assertNotNull((Object)(event.getTime().getTime() <= ClockUtil.getCurrentTime().getTime() ? 1 : 0));
        this.assertNoCommentsForTask();
    }

    public void testAddAttachmentEvents() {
        TaskEventsTest.assertTrue((boolean)this.taskService.getTaskEvents(this.task.getId()).isEmpty());
        this.identityService.setAuthenticatedUserId(JONNY);
        this.taskService.createAttachment(IMAGE_PNG, this.task.getId(), null, IMAGE_NAME, IMAGE_DESC, IMAGE_URL);
        List events = this.taskService.getTaskEvents(this.task.getId());
        TaskEventsTest.assertEquals((int)1, (int)events.size());
        Event event = (Event)events.get(0);
        TaskEventsTest.assertEquals((int)1, (int)event.getMessageParts().size());
        TaskEventsTest.assertEquals((String)IMAGE_NAME, (String)((String)event.getMessageParts().get(0)));
        TaskEventsTest.assertEquals((String)this.task.getId(), (String)event.getTaskId());
        TaskEventsTest.assertEquals((String)"AddAttachment", (String)event.getAction());
        TaskEventsTest.assertEquals((String)IMAGE_NAME, (String)event.getMessage());
        TaskEventsTest.assertEquals(null, (String)event.getProcessInstanceId());
        TaskEventsTest.assertNotNull((Object)(event.getTime().getTime() <= ClockUtil.getCurrentTime().getTime() ? 1 : 0));
        this.assertNoCommentsForTask();
    }

    public void testDeleteAttachmentEvents() {
        TaskEventsTest.assertTrue((boolean)this.taskService.getTaskEvents(this.task.getId()).isEmpty());
        this.identityService.setAuthenticatedUserId(JONNY);
        Attachment attachment = this.taskService.createAttachment(IMAGE_PNG, this.task.getId(), null, IMAGE_NAME, IMAGE_DESC, IMAGE_URL);
        ClockUtil.setCurrentTime((Date)new Date(ClockUtil.getCurrentTime().getTime() + 5000L));
        this.taskService.deleteAttachment(attachment.getId());
        List events = this.taskService.getTaskEvents(this.task.getId());
        TaskEventsTest.assertEquals((int)2, (int)events.size());
        Event event = (Event)events.get(0);
        TaskEventsTest.assertEquals((int)1, (int)event.getMessageParts().size());
        TaskEventsTest.assertEquals((String)IMAGE_NAME, (String)((String)event.getMessageParts().get(0)));
        TaskEventsTest.assertEquals((String)this.task.getId(), (String)event.getTaskId());
        TaskEventsTest.assertEquals((String)"DeleteAttachment", (String)event.getAction());
        TaskEventsTest.assertEquals((String)IMAGE_NAME, (String)event.getMessage());
        TaskEventsTest.assertEquals(null, (String)event.getProcessInstanceId());
        TaskEventsTest.assertNotNull((Object)(event.getTime().getTime() <= ClockUtil.getCurrentTime().getTime() ? 1 : 0));
        this.assertNoCommentsForTask();
    }

    private void assertNoCommentsForTask() {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                TestCase.assertTrue((boolean)commandContext.getCommentManager().findCommentsByTaskId(TaskEventsTest.this.task.getId()).isEmpty());
                return null;
            }
        });
    }
}

