/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.async;

import java.util.Date;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class AsyncTaskTest
extends PluggableProcessEngineTestCase {
    public static boolean INVOCATION;

    @Deployment
    public void testAsycServiceNoListeners() {
        INVOCATION = false;
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("asyncService");
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstance.getId());
        AsyncTaskTest.assertEquals((int)1, (int)activityInstance.getChildTransitionInstances().length);
        AsyncTaskTest.assertEquals((int)0, (int)activityInstance.getChildActivityInstances().length);
        AsyncTaskTest.assertNotNull((Object)activityInstance.getChildTransitionInstances()[0]);
        AsyncTaskTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        AsyncTaskTest.assertFalse((boolean)INVOCATION);
        this.executeAvailableJobs();
        AsyncTaskTest.assertTrue((boolean)INVOCATION);
        AsyncTaskTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    public void testAsycServiceListeners() {
        String pid = this.runtimeService.startProcessInstanceByKey("asyncService").getProcessInstanceId();
        AsyncTaskTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        AsyncTaskTest.assertNull((Object)this.runtimeService.getVariable(pid, "listener"));
        this.executeAvailableJobs();
        AsyncTaskTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    public void testAsycServiceConcurrent() {
        INVOCATION = false;
        this.runtimeService.startProcessInstanceByKey("asyncService");
        AsyncTaskTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        AsyncTaskTest.assertFalse((boolean)INVOCATION);
        this.executeAvailableJobs();
        AsyncTaskTest.assertTrue((boolean)INVOCATION);
        AsyncTaskTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    public void testAsyncServiceMultiInstance() {
        INVOCATION = false;
        this.runtimeService.startProcessInstanceByKey("asyncService");
        AsyncTaskTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        AsyncTaskTest.assertFalse((boolean)INVOCATION);
        this.executeAvailableJobs();
        AsyncTaskTest.assertTrue((boolean)INVOCATION);
        AsyncTaskTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    public void testFailingAsycServiceTimer() {
        this.runtimeService.startProcessInstanceByKey("asyncService");
        AsyncTaskTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        if (!(job instanceof MessageEntity)) {
            AsyncTaskTest.fail((String)"the job must be a message");
        }
        this.executeAvailableJobs();
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().singleResult();
        AsyncTaskTest.assertNotNull((Object)execution);
        AsyncTaskTest.assertEquals((String)"service", (String)((String)this.runtimeService.getActiveActivityIds(execution.getId()).get(0)));
        AsyncTaskTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        this.runtimeService.deleteProcessInstance(execution.getId(), "dead");
    }

    @Deployment
    public void FAILING_testFailingAsycServiceTimer() {
        this.runtimeService.startProcessInstanceByKey("asyncService");
        AsyncTaskTest.assertEquals((long)2L, (long)this.managementService.createJobQuery().count());
        this.executeAvailableJobs();
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().singleResult();
        AsyncTaskTest.assertNotNull((Object)execution);
        AsyncTaskTest.assertEquals((String)"service", (String)((String)this.runtimeService.getActiveActivityIds(execution.getId()).get(0)));
        AsyncTaskTest.assertEquals((long)2L, (long)this.managementService.createJobQuery().count());
        ClockUtil.setCurrentTime((Date)new Date(System.currentTimeMillis() + 10000L));
        this.executeAvailableJobs();
        AsyncTaskTest.assertNull((Object)this.runtimeService.createExecutionQuery().singleResult());
        AsyncTaskTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    public void testAsycServiceSubProcessTimer() {
        INVOCATION = false;
        this.runtimeService.startProcessInstanceByKey("asyncService");
        AsyncTaskTest.assertEquals((long)2L, (long)this.managementService.createJobQuery().count());
        AsyncTaskTest.assertFalse((boolean)INVOCATION);
        Job job = (Job)this.managementService.createJobQuery().messages().singleResult();
        this.managementService.executeJob(job.getId());
        AsyncTaskTest.assertTrue((boolean)INVOCATION);
        AsyncTaskTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    public void testAsycServiceSubProcess() {
        this.runtimeService.startProcessInstanceByKey("asyncService");
        AsyncTaskTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        this.executeAvailableJobs();
        AsyncTaskTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    public void testAsycTask() {
        this.runtimeService.startProcessInstanceByKey("asyncTask");
        AsyncTaskTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        this.executeAvailableJobs();
        AsyncTaskTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    public void testAsycScript() {
        this.runtimeService.startProcessInstanceByKey("asyncScript").getProcessInstanceId();
        AsyncTaskTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        String eid = ((Execution)this.runtimeService.createExecutionQuery().singleResult()).getId();
        AsyncTaskTest.assertNull((Object)this.runtimeService.getVariable(eid, "invoked"));
        this.executeAvailableJobs();
        AsyncTaskTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
        AsyncTaskTest.assertEquals((Object)"true", (Object)this.runtimeService.getVariable(eid, "invoked"));
        this.runtimeService.signal(eid);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/AsyncTaskTest.testAsycCallActivity.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/async/AsyncTaskTest.testAsycServiceNoListeners.bpmn20.xml"})
    public void testAsycCallActivity() {
        this.runtimeService.startProcessInstanceByKey("asyncCallactivity");
        AsyncTaskTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        this.executeAvailableJobs();
        AsyncTaskTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    public void testAsyncUserTask() {
        String pid = this.runtimeService.startProcessInstanceByKey("asyncUserTask").getProcessInstanceId();
        AsyncTaskTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        AsyncTaskTest.assertNull((Object)this.runtimeService.getVariable(pid, "listener"));
        AsyncTaskTest.assertNull((Object)this.taskService.createTaskQuery().singleResult());
        this.executeAvailableJobs();
        AsyncTaskTest.assertNotNull((Object)this.runtimeService.getVariable(pid, "listener"));
        AsyncTaskTest.assertNotNull((Object)this.taskService.createTaskQuery().singleResult());
        AsyncTaskTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
    }
}

