/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.error;

import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class ErrorEventSubProcessTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testEventSubprocessTakesPrecedence() {
        String procId = this.runtimeService.startProcessInstanceByKey("CatchErrorInEmbeddedSubProcess").getId();
        this.assertThatErrorHasBeenCaught(procId);
    }

    @Deployment
    public void testErrorCodeTakesPrecedence() {
        String procId = this.runtimeService.startProcessInstanceByKey("CatchErrorInEmbeddedSubProcess").getId();
        ErrorEventSubProcessTest.assertEquals((String)"No tasks found in task list.", (long)1L, (long)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterErrorCatch2").count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        ErrorEventSubProcessTest.assertEquals((String)"Escalated Task", (String)task.getName());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(procId);
    }

    @Deployment
    public void testCatchErrorInEmbeddedSubProcess() {
        String procId = this.runtimeService.startProcessInstanceByKey("CatchErrorInEmbeddedSubProcess").getId();
        this.assertThatErrorHasBeenCaught(procId);
    }

    @Deployment
    public void testCatchErrorThrownByScriptTaskInEmbeddedSubProcess() {
        String procId = this.runtimeService.startProcessInstanceByKey("CatchErrorThrownByScriptTaskInEmbeddedSubProcess").getId();
        this.assertThatErrorHasBeenCaught(procId);
    }

    @Deployment
    public void testCatchErrorThrownByScriptTaskInEmbeddedSubProcessWithErrorCode() {
        String procId = this.runtimeService.startProcessInstanceByKey("CatchErrorThrownByScriptTaskInEmbeddedSubProcessWithErrorCode").getId();
        this.assertThatErrorHasBeenCaught(procId);
    }

    @Deployment
    public void testCatchErrorThrownByScriptTaskInTopLevelProcess() {
        String procId = this.runtimeService.startProcessInstanceByKey("CatchErrorThrownByScriptTaskInTopLevelProcess").getId();
        this.assertThatErrorHasBeenCaught(procId);
    }

    @Deployment
    public void testCatchErrorThrownByScriptTaskInsideSubProcessInTopLevelProcess() {
        String procId = this.runtimeService.startProcessInstanceByKey("CatchErrorThrownByScriptTaskInsideSubProcessInTopLevelProcess").getId();
        this.assertThatErrorHasBeenCaught(procId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/error/ErrorEventSubProcessTest.testThrowErrorInScriptTaskInsideCallActivitiCatchInTopLevelProcess.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/error/BoundaryErrorEventTest.testCatchErrorThrownByJavaDelegateOnCallActivity-child.bpmn20.xml"})
    public void testThrowErrorInScriptTaskInsideCallActivitiCatchInTopLevelProcess() {
        String procId = this.runtimeService.startProcessInstanceByKey("testThrowErrorInScriptTaskInsideCallActivitiCatchInTopLevelProcess").getId();
        this.assertThatErrorHasBeenCaught(procId);
    }

    private void assertThatErrorHasBeenCaught(String procId) {
        ErrorEventSubProcessTest.assertEquals((String)"No tasks found in task list.", (long)1L, (long)this.taskService.createTaskQuery().count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        ErrorEventSubProcessTest.assertEquals((String)"Escalated Task", (String)task.getName());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(procId);
    }
}

