/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.iomapping;

import java.util.List;
import java.util.TreeMap;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.test.Deployment;

public class InputOutputTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testInputNullValue() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        InputOutputTest.assertEquals((String)"null", (String)variable.getTypeName());
        InputOutputTest.assertEquals((String)execution.getId(), (String)variable.getExecutionId());
    }

    @Deployment
    public void testInputStringConstantValue() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        InputOutputTest.assertEquals((Object)"stringValue", (Object)variable.getValue());
        InputOutputTest.assertEquals((String)execution.getId(), (String)variable.getExecutionId());
    }

    @Deployment
    public void testInputElValue() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        InputOutputTest.assertEquals((Object)2L, (Object)variable.getValue());
        InputOutputTest.assertEquals((String)execution.getId(), (String)variable.getExecutionId());
    }

    @Deployment
    public void testInputScriptValue() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        InputOutputTest.assertEquals((Object)2, (Object)variable.getValue());
        InputOutputTest.assertEquals((String)execution.getId(), (String)variable.getExecutionId());
    }

    @Deployment
    public void testInputListElValues() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        List value = (List)variable.getValue();
        InputOutputTest.assertEquals((Object)2L, value.get(0));
        InputOutputTest.assertEquals((Object)3L, value.get(1));
        InputOutputTest.assertEquals((Object)4L, value.get(2));
    }

    @Deployment
    public void testInputListMixedValues() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        List value = (List)variable.getValue();
        InputOutputTest.assertEquals((Object)"constantStringValue", value.get(0));
        InputOutputTest.assertEquals((Object)"elValue", value.get(1));
        InputOutputTest.assertEquals((Object)"scriptValue", value.get(2));
    }

    @Deployment
    public void testInputMapElValues() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        TreeMap value = (TreeMap)variable.getValue();
        InputOutputTest.assertEquals((Object)2L, value.get("a"));
        InputOutputTest.assertEquals((Object)3L, value.get("b"));
        InputOutputTest.assertEquals((Object)4L, value.get("c"));
    }

    @Deployment
    public void testInputMultipleElValue() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance var1 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)var1);
        InputOutputTest.assertEquals((Object)2L, (Object)var1.getValue());
        InputOutputTest.assertEquals((String)execution.getId(), (String)var1.getExecutionId());
        VariableInstance var2 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var2").singleResult();
        InputOutputTest.assertNotNull((Object)var2);
        InputOutputTest.assertEquals((Object)3L, (Object)var2.getValue());
        InputOutputTest.assertEquals((String)execution.getId(), (String)var2.getExecutionId());
    }

    @Deployment
    public void testInputMultipleMixedValue() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance var1 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)var1);
        InputOutputTest.assertEquals((Object)2L, (Object)var1.getValue());
        InputOutputTest.assertEquals((String)execution.getId(), (String)var1.getExecutionId());
        VariableInstance var2 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var2").singleResult();
        InputOutputTest.assertNotNull((Object)var2);
        InputOutputTest.assertEquals((Object)"stringConstantValue", (Object)var2.getValue());
        InputOutputTest.assertEquals((String)execution.getId(), (String)var2.getExecutionId());
    }

    @Deployment
    public void testInputNested() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance var1 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        TreeMap value = (TreeMap)var1.getValue();
        List nestedList = (List)value.get("a");
        InputOutputTest.assertEquals((Object)"stringInListNestedInMap", nestedList.get(0));
        InputOutputTest.assertEquals((Object)"b", nestedList.get(1));
        VariableInstance var2 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var2").singleResult();
        InputOutputTest.assertNotNull((Object)var2);
        InputOutputTest.assertEquals((Object)"stringConstantValue", (Object)var2.getValue());
        InputOutputTest.assertEquals((String)execution.getId(), (String)var2.getExecutionId());
    }

    @Deployment
    public void testOutputNullValue() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        InputOutputTest.assertEquals((String)"null", (String)variable.getTypeName());
        InputOutputTest.assertEquals((String)pi.getId(), (String)variable.getExecutionId());
    }

    @Deployment
    public void testOutputStringConstantValue() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        InputOutputTest.assertEquals((Object)"stringValue", (Object)variable.getValue());
        InputOutputTest.assertEquals((String)pi.getId(), (String)variable.getExecutionId());
    }

    @Deployment
    public void testOutputElValue() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        InputOutputTest.assertEquals((Object)2L, (Object)variable.getValue());
        InputOutputTest.assertEquals((String)pi.getId(), (String)variable.getExecutionId());
    }

    @Deployment
    public void testOutputScriptValue() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        InputOutputTest.assertEquals((Object)2, (Object)variable.getValue());
        InputOutputTest.assertEquals((String)pi.getId(), (String)variable.getExecutionId());
    }

    @Deployment
    public void testOutputListElValues() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        List value = (List)variable.getValue();
        InputOutputTest.assertEquals((Object)2L, value.get(0));
        InputOutputTest.assertEquals((Object)3L, value.get(1));
        InputOutputTest.assertEquals((Object)4L, value.get(2));
    }

    @Deployment
    public void testOutputListMixedValues() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        List value = (List)variable.getValue();
        InputOutputTest.assertEquals((Object)"constantStringValue", value.get(0));
        InputOutputTest.assertEquals((Object)"elValue", value.get(1));
        InputOutputTest.assertEquals((Object)"scriptValue", value.get(2));
    }

    @Deployment
    public void testOutputMapElValues() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        TreeMap value = (TreeMap)variable.getValue();
        InputOutputTest.assertEquals((Object)2L, value.get("a"));
        InputOutputTest.assertEquals((Object)3L, value.get("b"));
        InputOutputTest.assertEquals((Object)4L, value.get("c"));
    }

    @Deployment
    public void testOutputMultipleElValue() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance var1 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)var1);
        InputOutputTest.assertEquals((Object)2L, (Object)var1.getValue());
        InputOutputTest.assertEquals((String)pi.getId(), (String)var1.getExecutionId());
        VariableInstance var2 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var2").singleResult();
        InputOutputTest.assertNotNull((Object)var2);
        InputOutputTest.assertEquals((Object)3L, (Object)var2.getValue());
        InputOutputTest.assertEquals((String)pi.getId(), (String)var2.getExecutionId());
    }

    @Deployment
    public void testOutputMultipleMixedValue() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance var1 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)var1);
        InputOutputTest.assertEquals((Object)2L, (Object)var1.getValue());
        InputOutputTest.assertEquals((String)pi.getId(), (String)var1.getExecutionId());
        VariableInstance var2 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var2").singleResult();
        InputOutputTest.assertNotNull((Object)var2);
        InputOutputTest.assertEquals((Object)"stringConstantValue", (Object)var2.getValue());
        InputOutputTest.assertEquals((String)pi.getId(), (String)var2.getExecutionId());
    }

    @Deployment
    public void testOutputNested() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance var1 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        TreeMap value = (TreeMap)var1.getValue();
        List nestedList = (List)value.get("a");
        InputOutputTest.assertEquals((Object)"stringInListNestedInMap", nestedList.get(0));
        InputOutputTest.assertEquals((Object)"b", nestedList.get(1));
        InputOutputTest.assertEquals((String)pi.getId(), (String)var1.getExecutionId());
        VariableInstance var2 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var2").singleResult();
        InputOutputTest.assertNotNull((Object)var2);
        InputOutputTest.assertEquals((Object)"stringConstantValue", (Object)var2.getValue());
        InputOutputTest.assertEquals((String)pi.getId(), (String)var2.getExecutionId());
    }

    @Deployment
    public void testNonInterruptingEventSubprocessIoSupport() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.runtimeService.correlateMessage("msg");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        InputOutputTest.assertEquals((Object)"stringValue", (Object)variable.getValue());
    }

    @Deployment
    public void testInterruptingEventSubprocessIoSupport() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.runtimeService.correlateMessage("msg");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        InputOutputTest.assertEquals((Object)"stringValue", (Object)variable.getValue());
    }
}

