/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.deployment;

import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.CaseDefinitionQuery;
import org.camunda.bpm.engine.repository.DeploymentQuery;

public class CmmnDeployerTest
extends PluggableProcessEngineTestCase {
    public void testCmmnDeployment() {
        ProcessEngineConfigurationImpl config = (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"camunda.cfg.xml");
        ProcessEngine engine = config.buildProcessEngine();
        String deploymentId = engine.getRepositoryService().createDeployment().addClasspathResource("org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testSimpleDeployment.cmmn").deploy().getId();
        RepositoryService repositoryService = engine.getRepositoryService();
        DeploymentQuery deploymentQuery = repositoryService.createDeploymentQuery();
        CmmnDeployerTest.assertEquals((long)1L, (long)deploymentQuery.count());
        CaseDefinitionQuery query = engine.getRepositoryService().createCaseDefinitionQuery();
        CmmnDeployerTest.assertEquals((long)1L, (long)query.count());
        CaseDefinition caseDefinition = (CaseDefinition)query.singleResult();
        CmmnDeployerTest.assertEquals((String)"Case_1", (String)caseDefinition.getKey());
        engine.getRepositoryService().deleteDeployment(deploymentId);
    }

    public void testDeployTwoCasesWithDuplicateIdAtTheSameTime() {
        try {
            String cmmnResourceName1 = "org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testSimpleDeployment.cmmn";
            String cmmnResourceName2 = "org/camunda/bpm/engine/test/cmmn/deployment/CmmnDeploymentTest.testSimpleDeployment2.cmmn";
            this.repositoryService.createDeployment().addClasspathResource(cmmnResourceName1).addClasspathResource(cmmnResourceName2).name("duplicateAtTheSameTime").deploy();
            CmmnDeployerTest.fail();
        }
        catch (Exception e) {
            CmmnDeployerTest.assertEquals((long)0L, (long)this.repositoryService.createDeploymentQuery().count());
        }
    }
}

