/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.handler;

import org.camunda.bpm.engine.impl.cmmn.behavior.HumanTaskBehavior;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.handler.CmmnHandlerContext;
import org.camunda.bpm.engine.impl.cmmn.handler.HumanTaskDiscretionaryItemHandler;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.test.cmmn.handler.CmmnElementHandlerTest;
import org.camunda.bpm.model.cmmn.instance.CmmnModelElementInstance;
import org.camunda.bpm.model.cmmn.instance.DiscretionaryItem;
import org.camunda.bpm.model.cmmn.instance.HumanTask;
import org.camunda.bpm.model.cmmn.instance.PlanItemDefinition;
import org.camunda.bpm.model.cmmn.instance.PlanningTable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HumanTaskDicretionaryItemHandlerTest
extends CmmnElementHandlerTest {
    protected HumanTask humanTask;
    protected PlanningTable planningTable;
    protected DiscretionaryItem discretionaryItem;
    protected HumanTaskDiscretionaryItemHandler handler = new HumanTaskDiscretionaryItemHandler();
    protected CmmnHandlerContext context;

    @Before
    public void setUp() {
        this.humanTask = this.createElement((CmmnModelElementInstance)this.casePlanModel, "aHumanTask", HumanTask.class);
        this.planningTable = this.createElement((CmmnModelElementInstance)this.humanTask, "aPlanningTable", PlanningTable.class);
        this.discretionaryItem = this.createElement((CmmnModelElementInstance)this.planningTable, "DI_aHumanTask", DiscretionaryItem.class);
        this.discretionaryItem.setDefinition((PlanItemDefinition)this.humanTask);
        this.context = new CmmnHandlerContext();
    }

    @Test
    public void testHumanTaskActivityName() {
        String name = "A HumanTask";
        this.humanTask.setName(name);
        CmmnActivity activity = this.handler.handleElement(this.discretionaryItem, this.context);
        Assert.assertEquals((Object)name, (Object)activity.getName());
    }

    @Test
    public void testActivityBehavior() {
        CmmnActivity activity = this.handler.handleElement(this.discretionaryItem, this.context);
        CmmnActivityBehavior behavior = activity.getActivityBehavior();
        Assert.assertTrue((boolean)(behavior instanceof HumanTaskBehavior));
    }

    @Test
    public void testIsBlockingEqualsTrueProperty() {
        CmmnActivity activity = this.handler.handleElement(this.discretionaryItem, this.context);
        Boolean isBlocking = (Boolean)activity.getProperty("isBlocking");
        Assert.assertTrue((boolean)isBlocking);
    }

    @Test
    public void testIsBlockingEqualsFalseProperty() {
        this.humanTask.setIsBlocking(false);
        CmmnActivity activity = this.handler.handleElement(this.discretionaryItem, this.context);
        Boolean isBlocking = (Boolean)activity.getProperty("isBlocking");
        Assert.assertFalse((boolean)isBlocking);
    }

    @Test
    public void testIsDiscretionaryProperty() {
        CmmnActivity activity = this.handler.handleElement(this.discretionaryItem, this.context);
        Boolean discretionary = (Boolean)activity.getProperty("discretionary");
        Assert.assertTrue((boolean)discretionary);
    }

    @Test
    public void testWithoutParent() {
        CmmnActivity activity = this.handler.handleElement(this.discretionaryItem, this.context);
        Assert.assertNull((Object)activity.getParent());
    }

    @Test
    public void testWithParent() {
        CmmnCaseDefinition parent = new CmmnCaseDefinition("aParentActivity");
        this.context.setParent((CmmnActivity)parent);
        CmmnActivity activity = this.handler.handleElement(this.discretionaryItem, this.context);
        Assert.assertEquals((Object)parent, (Object)activity.getParent());
        Assert.assertTrue((boolean)parent.getActivities().contains(activity));
    }
}

