/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.handler;

import org.camunda.bpm.engine.impl.cmmn.behavior.StageActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.handler.CmmnHandlerContext;
import org.camunda.bpm.engine.impl.cmmn.handler.StageDiscretionaryItemHandler;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.test.cmmn.handler.CmmnElementHandlerTest;
import org.camunda.bpm.model.cmmn.instance.CmmnModelElementInstance;
import org.camunda.bpm.model.cmmn.instance.DiscretionaryItem;
import org.camunda.bpm.model.cmmn.instance.PlanItemDefinition;
import org.camunda.bpm.model.cmmn.instance.PlanningTable;
import org.camunda.bpm.model.cmmn.instance.Stage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StageDiscretionaryItemHandlerTest
extends CmmnElementHandlerTest {
    protected Stage stage;
    protected PlanningTable planningTable;
    protected DiscretionaryItem discretionaryItem;
    protected StageDiscretionaryItemHandler handler = new StageDiscretionaryItemHandler();
    protected CmmnHandlerContext context;

    @Before
    public void setUp() {
        this.stage = this.createElement((CmmnModelElementInstance)this.casePlanModel, "aStage", Stage.class);
        this.planningTable = this.createElement((CmmnModelElementInstance)this.stage, "aPlanningTable", PlanningTable.class);
        this.discretionaryItem = this.createElement((CmmnModelElementInstance)this.planningTable, "DI_aStage", DiscretionaryItem.class);
        this.discretionaryItem.setDefinition((PlanItemDefinition)this.stage);
        this.context = new CmmnHandlerContext();
    }

    @Test
    public void testStageActivityName() {
        String name = "A Stage";
        this.stage.setName(name);
        CmmnActivity activity = this.handler.handleElement(this.discretionaryItem, this.context);
        Assert.assertEquals((Object)name, (Object)activity.getName());
    }

    @Test
    public void testActivityBehavior() {
        CmmnActivity activity = this.handler.handleElement(this.discretionaryItem, this.context);
        CmmnActivityBehavior behavior = activity.getActivityBehavior();
        Assert.assertTrue((boolean)(behavior instanceof StageActivityBehavior));
    }

    @Test
    public void testWithoutParent() {
        CmmnActivity activity = this.handler.handleElement(this.discretionaryItem, this.context);
        Assert.assertNull((Object)activity.getParent());
    }

    @Test
    public void testWithParent() {
        CmmnCaseDefinition parent = new CmmnCaseDefinition("aParentActivity");
        this.context.setParent((CmmnActivity)parent);
        CmmnActivity activity = this.handler.handleElement(this.discretionaryItem, this.context);
        Assert.assertEquals((Object)parent, (Object)activity.getParent());
        Assert.assertTrue((boolean)parent.getActivities().contains(activity));
    }
}

