/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.handler;

import org.camunda.bpm.engine.impl.cmmn.behavior.TaskActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.handler.CmmnHandlerContext;
import org.camunda.bpm.engine.impl.cmmn.handler.TaskPlanItemHandler;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.test.cmmn.handler.CmmnElementHandlerTest;
import org.camunda.bpm.model.cmmn.instance.CmmnModelElementInstance;
import org.camunda.bpm.model.cmmn.instance.PlanItem;
import org.camunda.bpm.model.cmmn.instance.PlanItemDefinition;
import org.camunda.bpm.model.cmmn.instance.Task;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TaskPlanItemHandlerTest
extends CmmnElementHandlerTest {
    protected Task task;
    protected PlanItem planItem;
    protected TaskPlanItemHandler handler = new TaskPlanItemHandler();
    protected CmmnHandlerContext context;

    @Before
    public void setUp() {
        this.task = this.createElement((CmmnModelElementInstance)this.casePlanModel, "aTask", Task.class);
        this.planItem = this.createElement((CmmnModelElementInstance)this.casePlanModel, "PI_aTask", PlanItem.class);
        this.planItem.setDefinition((PlanItemDefinition)this.task);
        this.context = new CmmnHandlerContext();
    }

    @Test
    public void testTaskActivityName() {
        String name = "A Task";
        this.task.setName(name);
        CmmnActivity activity = this.handler.handleElement(this.planItem, this.context);
        Assert.assertEquals((Object)name, (Object)activity.getName());
    }

    @Test
    public void testPlanItemActivityName() {
        String taskName = "A Task";
        this.task.setName(taskName);
        String planItemName = "My LocalName";
        this.planItem.setName(planItemName);
        CmmnActivity activity = this.handler.handleElement(this.planItem, this.context);
        Assert.assertNotEquals((Object)taskName, (Object)activity.getName());
        Assert.assertEquals((Object)planItemName, (Object)activity.getName());
    }

    @Test
    public void testActivityBehavior() {
        CmmnActivity activity = this.handler.handleElement(this.planItem, this.context);
        CmmnActivityBehavior behavior = activity.getActivityBehavior();
        Assert.assertTrue((boolean)(behavior instanceof TaskActivityBehavior));
    }

    @Test
    public void testIsBlockingEqualsTrueProperty() {
        CmmnActivity activity = this.handler.handleElement(this.planItem, this.context);
        Boolean isBlocking = (Boolean)activity.getProperty("isBlocking");
        Assert.assertTrue((boolean)isBlocking);
    }

    @Test
    public void testIsBlockingEqualsFalseProperty() {
        this.task.setIsBlocking(false);
        CmmnActivity activity = this.handler.handleElement(this.planItem, this.context);
        Boolean isBlocking = (Boolean)activity.getProperty("isBlocking");
        Assert.assertFalse((boolean)isBlocking);
    }

    @Test
    public void testWithoutParent() {
        CmmnActivity activity = this.handler.handleElement(this.planItem, this.context);
        Assert.assertNull((Object)activity.getParent());
    }

    @Test
    public void testWithParent() {
        CmmnCaseDefinition parent = new CmmnCaseDefinition("aParentActivity");
        this.context.setParent((CmmnActivity)parent);
        CmmnActivity activity = this.handler.handleElement(this.planItem, this.context);
        Assert.assertEquals((Object)parent, (Object)activity.getParent());
        Assert.assertTrue((boolean)parent.getActivities().contains(activity));
    }
}

