/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.operation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.camunda.bpm.engine.delegate.CaseExecutionListener;
import org.camunda.bpm.engine.delegate.DelegateCaseExecution;
import org.camunda.bpm.engine.impl.cmmn.execution.CaseExecutionState;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnExecution;

public class CaseExecutionStateTransitionCollector
implements CaseExecutionListener {
    private static Logger log = Logger.getLogger(CaseExecutionStateTransitionCollector.class.getName());
    protected static Map<Integer, CaseExecutionState> states = new HashMap<Integer, CaseExecutionState>();
    public List<String> stateTransitions = new ArrayList<String>();

    public void notify(DelegateCaseExecution planItem) throws Exception {
        CmmnExecution execution = (CmmnExecution)planItem;
        String activityId = execution.getEventSource().getId();
        CaseExecutionState previousState = states.get(execution.getPreviousState());
        String previousStateName = "()";
        if (previousState != null) {
            previousStateName = previousState.toString();
        }
        CaseExecutionState newState = states.get(execution.getCurrentState());
        String stateTransition = previousStateName + " --" + execution.getEventName() + "(" + activityId + ")--> " + newState;
        log.fine("collecting state transition: " + stateTransition);
        this.stateTransitions.add(stateTransition);
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        for (String event : this.stateTransitions) {
            text.append(event);
            text.append("\n");
        }
        return text.toString();
    }

    static {
        states.put(CaseExecutionState.ACTIVE.getStateCode(), CaseExecutionState.ACTIVE);
        states.put(CaseExecutionState.AVAILABLE.getStateCode(), CaseExecutionState.AVAILABLE);
        states.put(CaseExecutionState.CLOSED.getStateCode(), CaseExecutionState.CLOSED);
        states.put(CaseExecutionState.COMPLETED.getStateCode(), CaseExecutionState.COMPLETED);
        states.put(CaseExecutionState.DISABLED.getStateCode(), CaseExecutionState.DISABLED);
        states.put(CaseExecutionState.ENABLED.getStateCode(), CaseExecutionState.ENABLED);
        states.put(CaseExecutionState.FAILED.getStateCode(), CaseExecutionState.FAILED);
        states.put(CaseExecutionState.SUSPENDED.getStateCode(), CaseExecutionState.SUSPENDED);
        states.put(CaseExecutionState.TERMINATED.getStateCode(), CaseExecutionState.TERMINATED);
    }
}

