/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.operation;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.delegate.CaseExecutionListener;
import org.camunda.bpm.engine.impl.cmmn.behavior.StageActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.execution.CaseExecutionImpl;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnCaseInstance;
import org.camunda.bpm.engine.impl.cmmn.model.CaseDefinitionBuilder;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.impl.test.PvmTestCase;
import org.camunda.bpm.engine.test.cmmn.operation.CaseExecutionStateTransitionCollector;
import org.camunda.bpm.engine.test.cmmn.operation.WaitState;
import org.junit.Test;

public class CaseInstanceTest
extends PvmTestCase {
    @Test
    public void testCaseInstanceWithOneTask() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("create", (CaseExecutionListener)stateTransitionCollector).createActivity("A").listener("create", (CaseExecutionListener)stateTransitionCollector).listener("enable", (CaseExecutionListener)stateTransitionCollector).listener("manualStart", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new WaitState()).endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        ArrayList<String> expectedStateTransitions = new ArrayList<String>();
        expectedStateTransitions.add("() --create(Case1)--> active");
        expectedStateTransitions.add("() --create(A)--> available");
        expectedStateTransitions.add("available --enable(A)--> enabled");
        CaseInstanceTest.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
        expectedStateTransitions.clear();
        stateTransitionCollector.stateTransitions.clear();
        CaseInstanceTest.assertTrue((boolean)caseInstance.isActive());
        CaseExecutionImpl instance = (CaseExecutionImpl)caseInstance;
        List childPlanItems = instance.getCaseExecutions();
        CaseInstanceTest.assertEquals((int)1, (int)childPlanItems.size());
        CaseExecutionImpl planItemA = (CaseExecutionImpl)childPlanItems.get(0);
        CaseInstanceTest.assertTrue((boolean)planItemA.isEnabled());
        CaseInstanceTest.assertEquals((Object)caseInstance, (Object)planItemA.getParent());
        planItemA.manualStart();
        expectedStateTransitions.add("enabled --manualStart(A)--> active");
        CaseInstanceTest.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
        CaseInstanceTest.assertTrue((boolean)planItemA.isActive());
    }

    @Test
    public void testCaseInstanceWithOneState() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("create", (CaseExecutionListener)stateTransitionCollector).createActivity("X").listener("create", (CaseExecutionListener)stateTransitionCollector).listener("enable", (CaseExecutionListener)stateTransitionCollector).listener("manualStart", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new StageActivityBehavior()).createActivity("A").listener("create", (CaseExecutionListener)stateTransitionCollector).listener("enable", (CaseExecutionListener)stateTransitionCollector).listener("manualStart", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new WaitState()).endActivity().createActivity("B").listener("create", (CaseExecutionListener)stateTransitionCollector).listener("enable", (CaseExecutionListener)stateTransitionCollector).listener("manualStart", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new WaitState()).endActivity().endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        ArrayList<String> expectedStateTransitions = new ArrayList<String>();
        expectedStateTransitions.add("() --create(Case1)--> active");
        expectedStateTransitions.add("() --create(X)--> available");
        expectedStateTransitions.add("available --enable(X)--> enabled");
        CaseInstanceTest.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
        expectedStateTransitions.clear();
        stateTransitionCollector.stateTransitions.clear();
        CaseInstanceTest.assertTrue((boolean)caseInstance.isActive());
        CaseExecutionImpl instance = (CaseExecutionImpl)caseInstance;
        List childPlanItems = instance.getCaseExecutions();
        CaseInstanceTest.assertEquals((int)1, (int)childPlanItems.size());
        CaseExecutionImpl planItemX = (CaseExecutionImpl)childPlanItems.get(0);
        CaseInstanceTest.assertEquals((Object)caseInstance, (Object)planItemX.getParent());
        CaseInstanceTest.assertTrue((boolean)planItemX.isEnabled());
        CaseInstanceTest.assertTrue((boolean)planItemX.getCaseExecutions().isEmpty());
        planItemX.manualStart();
        CaseInstanceTest.assertTrue((boolean)planItemX.isActive());
        expectedStateTransitions.add("enabled --manualStart(X)--> active");
        expectedStateTransitions.add("() --create(A)--> available");
        expectedStateTransitions.add("available --enable(A)--> enabled");
        expectedStateTransitions.add("() --create(B)--> available");
        expectedStateTransitions.add("available --enable(B)--> enabled");
        CaseInstanceTest.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
        expectedStateTransitions.clear();
        stateTransitionCollector.stateTransitions.clear();
        childPlanItems = planItemX.getCaseExecutions();
        CaseInstanceTest.assertEquals((int)2, (int)childPlanItems.size());
        for (CaseExecutionImpl childPlanItem : childPlanItems) {
            CaseInstanceTest.assertTrue((boolean)childPlanItem.isEnabled());
            childPlanItem.manualStart();
            CaseInstanceTest.assertTrue((boolean)childPlanItem.isActive());
            CaseInstanceTest.assertEquals((Object)planItemX, (Object)childPlanItem.getParent());
        }
        expectedStateTransitions.add("enabled --manualStart(A)--> active");
        expectedStateTransitions.add("enabled --manualStart(B)--> active");
        CaseInstanceTest.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
    }

    @Test
    public void testStartComplexCaseInstance() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("create", (CaseExecutionListener)stateTransitionCollector).createActivity("A1").listener("create", (CaseExecutionListener)stateTransitionCollector).listener("enable", (CaseExecutionListener)stateTransitionCollector).listener("manualStart", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new WaitState()).endActivity().createActivity("X1").listener("create", (CaseExecutionListener)stateTransitionCollector).listener("enable", (CaseExecutionListener)stateTransitionCollector).listener("manualStart", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new StageActivityBehavior()).createActivity("A2").listener("create", (CaseExecutionListener)stateTransitionCollector).listener("enable", (CaseExecutionListener)stateTransitionCollector).listener("manualStart", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new WaitState()).endActivity().createActivity("B1").listener("create", (CaseExecutionListener)stateTransitionCollector).listener("enable", (CaseExecutionListener)stateTransitionCollector).listener("manualStart", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new WaitState()).endActivity().endActivity().createActivity("Y").listener("create", (CaseExecutionListener)stateTransitionCollector).listener("enable", (CaseExecutionListener)stateTransitionCollector).listener("manualStart", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new StageActivityBehavior()).createActivity("C").listener("create", (CaseExecutionListener)stateTransitionCollector).listener("enable", (CaseExecutionListener)stateTransitionCollector).listener("manualStart", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new WaitState()).endActivity().createActivity("X2").listener("create", (CaseExecutionListener)stateTransitionCollector).listener("enable", (CaseExecutionListener)stateTransitionCollector).listener("manualStart", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new StageActivityBehavior()).createActivity("A3").listener("create", (CaseExecutionListener)stateTransitionCollector).listener("enable", (CaseExecutionListener)stateTransitionCollector).listener("manualStart", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new WaitState()).endActivity().createActivity("B2").listener("create", (CaseExecutionListener)stateTransitionCollector).listener("enable", (CaseExecutionListener)stateTransitionCollector).listener("manualStart", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new WaitState()).endActivity().endActivity().endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        ArrayList<String> expectedStateTransitions = new ArrayList<String>();
        expectedStateTransitions.add("() --create(Case1)--> active");
        expectedStateTransitions.add("() --create(A1)--> available");
        expectedStateTransitions.add("available --enable(A1)--> enabled");
        expectedStateTransitions.add("() --create(X1)--> available");
        expectedStateTransitions.add("available --enable(X1)--> enabled");
        expectedStateTransitions.add("() --create(Y)--> available");
        expectedStateTransitions.add("available --enable(Y)--> enabled");
        CaseInstanceTest.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
        expectedStateTransitions.clear();
        stateTransitionCollector.stateTransitions.clear();
        CaseExecutionImpl instance = (CaseExecutionImpl)caseInstance;
        CaseInstanceTest.assertTrue((boolean)instance.isActive());
        List childPlanItems = instance.getCaseExecutions();
        CaseInstanceTest.assertEquals((int)3, (int)childPlanItems.size());
        CaseExecutionImpl planItemA1 = (CaseExecutionImpl)instance.findCaseExecution("A1");
        CaseInstanceTest.assertEquals((Object)caseInstance, (Object)planItemA1.getParent());
        CaseInstanceTest.assertTrue((boolean)planItemA1.isEnabled());
        planItemA1.manualStart();
        CaseInstanceTest.assertTrue((boolean)planItemA1.isActive());
        expectedStateTransitions.add("enabled --manualStart(A1)--> active");
        CaseInstanceTest.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
        expectedStateTransitions.clear();
        stateTransitionCollector.stateTransitions.clear();
        CaseExecutionImpl planItemX1 = (CaseExecutionImpl)instance.findCaseExecution("X1");
        CaseInstanceTest.assertEquals((Object)caseInstance, (Object)planItemX1.getParent());
        CaseInstanceTest.assertTrue((boolean)planItemX1.isEnabled());
        planItemX1.manualStart();
        CaseInstanceTest.assertTrue((boolean)planItemX1.isActive());
        childPlanItems = planItemX1.getCaseExecutions();
        CaseInstanceTest.assertEquals((int)2, (int)childPlanItems.size());
        expectedStateTransitions.add("enabled --manualStart(X1)--> active");
        expectedStateTransitions.add("() --create(A2)--> available");
        expectedStateTransitions.add("available --enable(A2)--> enabled");
        expectedStateTransitions.add("() --create(B1)--> available");
        expectedStateTransitions.add("available --enable(B1)--> enabled");
        CaseInstanceTest.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
        expectedStateTransitions.clear();
        stateTransitionCollector.stateTransitions.clear();
        CaseExecutionImpl planItemA2 = (CaseExecutionImpl)instance.findCaseExecution("A2");
        CaseInstanceTest.assertEquals((Object)planItemX1, (Object)planItemA2.getParent());
        CaseInstanceTest.assertTrue((boolean)planItemA2.isEnabled());
        planItemA2.manualStart();
        CaseInstanceTest.assertTrue((boolean)planItemA2.isActive());
        expectedStateTransitions.add("enabled --manualStart(A2)--> active");
        CaseInstanceTest.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
        expectedStateTransitions.clear();
        stateTransitionCollector.stateTransitions.clear();
        CaseExecutionImpl planItemB1 = (CaseExecutionImpl)instance.findCaseExecution("B1");
        CaseInstanceTest.assertEquals((Object)planItemX1, (Object)planItemB1.getParent());
        CaseInstanceTest.assertTrue((boolean)planItemB1.isEnabled());
        planItemB1.manualStart();
        CaseInstanceTest.assertTrue((boolean)planItemB1.isActive());
        expectedStateTransitions.add("enabled --manualStart(B1)--> active");
        CaseInstanceTest.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
        expectedStateTransitions.clear();
        stateTransitionCollector.stateTransitions.clear();
        CaseExecutionImpl planItemY = (CaseExecutionImpl)instance.findCaseExecution("Y");
        CaseInstanceTest.assertEquals((Object)caseInstance, (Object)planItemY.getParent());
        CaseInstanceTest.assertTrue((boolean)planItemY.isEnabled());
        planItemY.manualStart();
        CaseInstanceTest.assertTrue((boolean)planItemY.isActive());
        childPlanItems = planItemY.getCaseExecutions();
        CaseInstanceTest.assertEquals((int)2, (int)childPlanItems.size());
        expectedStateTransitions.add("enabled --manualStart(Y)--> active");
        expectedStateTransitions.add("() --create(C)--> available");
        expectedStateTransitions.add("available --enable(C)--> enabled");
        expectedStateTransitions.add("() --create(X2)--> available");
        expectedStateTransitions.add("available --enable(X2)--> enabled");
        CaseInstanceTest.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
        expectedStateTransitions.clear();
        stateTransitionCollector.stateTransitions.clear();
        CaseExecutionImpl planItemC = (CaseExecutionImpl)instance.findCaseExecution("C");
        CaseInstanceTest.assertEquals((Object)planItemY, (Object)planItemC.getParent());
        CaseInstanceTest.assertTrue((boolean)planItemC.isEnabled());
        planItemC.manualStart();
        CaseInstanceTest.assertTrue((boolean)planItemC.isActive());
        expectedStateTransitions.add("enabled --manualStart(C)--> active");
        CaseInstanceTest.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
        expectedStateTransitions.clear();
        stateTransitionCollector.stateTransitions.clear();
        CaseExecutionImpl planItemX2 = (CaseExecutionImpl)instance.findCaseExecution("X2");
        CaseInstanceTest.assertEquals((Object)planItemY, (Object)planItemX2.getParent());
        CaseInstanceTest.assertTrue((boolean)planItemX2.isEnabled());
        planItemX2.manualStart();
        CaseInstanceTest.assertTrue((boolean)planItemX2.isActive());
        childPlanItems = planItemX2.getCaseExecutions();
        CaseInstanceTest.assertEquals((int)2, (int)childPlanItems.size());
        expectedStateTransitions.add("enabled --manualStart(X2)--> active");
        expectedStateTransitions.add("() --create(A3)--> available");
        expectedStateTransitions.add("available --enable(A3)--> enabled");
        expectedStateTransitions.add("() --create(B2)--> available");
        expectedStateTransitions.add("available --enable(B2)--> enabled");
        CaseInstanceTest.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
        expectedStateTransitions.clear();
        stateTransitionCollector.stateTransitions.clear();
        CaseExecutionImpl planItemA3 = (CaseExecutionImpl)instance.findCaseExecution("A3");
        CaseInstanceTest.assertEquals((Object)planItemX2, (Object)planItemA3.getParent());
        CaseInstanceTest.assertTrue((boolean)planItemA3.isEnabled());
        planItemA3.manualStart();
        CaseInstanceTest.assertTrue((boolean)planItemA3.isActive());
        expectedStateTransitions.add("enabled --manualStart(A3)--> active");
        CaseInstanceTest.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
        expectedStateTransitions.clear();
        stateTransitionCollector.stateTransitions.clear();
        CaseExecutionImpl planItemB2 = (CaseExecutionImpl)instance.findCaseExecution("B2");
        CaseInstanceTest.assertEquals((Object)planItemX2, (Object)planItemB2.getParent());
        CaseInstanceTest.assertTrue((boolean)planItemB2.isEnabled());
        planItemB2.manualStart();
        CaseInstanceTest.assertTrue((boolean)planItemB2.isActive());
        expectedStateTransitions.add("enabled --manualStart(B2)--> active");
        CaseInstanceTest.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
        expectedStateTransitions.clear();
        stateTransitionCollector.stateTransitions.clear();
    }
}

