/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.transformer;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.cmmn.handler.DefaultCmmnElementHandlerRegistry;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.impl.cmmn.transformer.CmmnTransform;
import org.camunda.bpm.engine.impl.cmmn.transformer.CmmnTransformer;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceEntity;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.model.cmmn.Cmmn;
import org.camunda.bpm.model.cmmn.CmmnModelInstance;
import org.camunda.bpm.model.cmmn.impl.instance.CasePlanModel;
import org.camunda.bpm.model.cmmn.instance.Case;
import org.camunda.bpm.model.cmmn.instance.CmmnModelElementInstance;
import org.camunda.bpm.model.cmmn.instance.Definitions;
import org.camunda.bpm.model.cmmn.instance.HumanTask;
import org.camunda.bpm.model.cmmn.instance.PlanItem;
import org.camunda.bpm.model.cmmn.instance.PlanItemDefinition;
import org.camunda.bpm.model.cmmn.instance.Stage;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CmmnTranformerTest {
    protected CmmnTransform transformer;
    protected CmmnModelInstance modelInstance;
    protected Definitions definitions;
    protected Case caseDefinition;
    protected CasePlanModel casePlanModel;
    protected DeploymentEntity deployment;

    @Before
    public void setup() {
        CmmnTransformer transformerWrapper = new CmmnTransformer(null, new DefaultCmmnElementHandlerRegistry(), null);
        this.transformer = new CmmnTransform(transformerWrapper);
        this.deployment = new DeploymentEntity();
        this.deployment.setId("aDeploymentId");
        this.transformer.setDeployment(this.deployment);
        this.modelInstance = Cmmn.createEmptyModel();
        this.definitions = (Definitions)this.modelInstance.newInstance(Definitions.class);
        this.definitions.setTargetNamespace("http://camunda.org/examples");
        this.modelInstance.setDefinitions(this.definitions);
        this.caseDefinition = this.createElement((CmmnModelElementInstance)this.definitions, "aCaseDefinition", Case.class);
        this.casePlanModel = this.createElement((CmmnModelElementInstance)this.caseDefinition, "aCasePlanModel", CasePlanModel.class);
    }

    protected <T extends CmmnModelElementInstance> T createElement(CmmnModelElementInstance parentElement, String id, Class<T> elementClass) {
        CmmnModelElementInstance element = (CmmnModelElementInstance)this.modelInstance.newInstance(elementClass);
        element.setAttributeValue("id", id, true);
        parentElement.addChildElement((ModelElementInstance)element);
        return (T)element;
    }

    protected List<CaseDefinitionEntity> transform() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Cmmn.writeModelToStream((OutputStream)outputStream, (CmmnModelInstance)this.modelInstance);
        InputStream inputStream = org.camunda.bpm.model.xml.impl.util.IoUtil.convertOutputStreamToInputStream((OutputStream)outputStream);
        byte[] model = IoUtil.readInputStream((InputStream)inputStream, (String)"model");
        ResourceEntity resource = new ResourceEntity();
        resource.setBytes(model);
        resource.setName("test");
        this.transformer.setResource(resource);
        List definitions = this.transformer.transform();
        org.camunda.bpm.model.xml.impl.util.IoUtil.closeSilently((Closeable)outputStream);
        org.camunda.bpm.model.xml.impl.util.IoUtil.closeSilently((Closeable)inputStream);
        return definitions;
    }

    @Test
    public void testCasePlanModel() {
        List<CaseDefinitionEntity> caseDefinitions = this.transform();
        Assert.assertEquals((long)1L, (long)caseDefinitions.size());
        CmmnCaseDefinition caseModel = (CmmnCaseDefinition)caseDefinitions.get(0);
        List activities = caseModel.getActivities();
        Assert.assertEquals((long)1L, (long)activities.size());
        CmmnActivity casePlanModelActivity = (CmmnActivity)activities.get(0);
        Assert.assertEquals((Object)this.casePlanModel.getId(), (Object)casePlanModelActivity.getId());
        Assert.assertTrue((boolean)casePlanModelActivity.getActivities().isEmpty());
    }

    @Test
    public void testActivityTreeWithOneHumanTask() {
        HumanTask humanTask = this.createElement((CmmnModelElementInstance)this.casePlanModel, "A", HumanTask.class);
        PlanItem planItem = this.createElement((CmmnModelElementInstance)this.casePlanModel, "PI_A", PlanItem.class);
        planItem.setDefinition((PlanItemDefinition)humanTask);
        List<CaseDefinitionEntity> caseDefinitions = this.transform();
        Assert.assertEquals((long)1L, (long)caseDefinitions.size());
        CaseDefinitionEntity caseDefinition = caseDefinitions.get(0);
        List activities = caseDefinition.getActivities();
        CmmnActivity casePlanModelActivity = (CmmnActivity)activities.get(0);
        List planItemActivities = casePlanModelActivity.getActivities();
        Assert.assertEquals((long)1L, (long)planItemActivities.size());
        CmmnActivity child = (CmmnActivity)planItemActivities.get(0);
        Assert.assertEquals((Object)planItem.getId(), (Object)child.getId());
        Assert.assertTrue((boolean)child.getActivities().isEmpty());
    }

    @Test
    public void testActivityTreeWithOneStageAndNestedHumanTasks() {
        Stage stage = this.createElement((CmmnModelElementInstance)this.casePlanModel, "X", Stage.class);
        HumanTask humanTaskA = this.createElement((CmmnModelElementInstance)this.casePlanModel, "A", HumanTask.class);
        HumanTask humanTaskB = this.createElement((CmmnModelElementInstance)this.casePlanModel, "B", HumanTask.class);
        PlanItem planItemX = this.createElement((CmmnModelElementInstance)this.casePlanModel, "PI_X", PlanItem.class);
        PlanItem planItemA = this.createElement((CmmnModelElementInstance)stage, "PI_A", PlanItem.class);
        PlanItem planItemB = this.createElement((CmmnModelElementInstance)stage, "PI_B", PlanItem.class);
        planItemX.setDefinition((PlanItemDefinition)stage);
        planItemA.setDefinition((PlanItemDefinition)humanTaskA);
        planItemB.setDefinition((PlanItemDefinition)humanTaskB);
        List<CaseDefinitionEntity> caseDefinitions = this.transform();
        Assert.assertEquals((long)1L, (long)caseDefinitions.size());
        CaseDefinitionEntity caseDefinition = caseDefinitions.get(0);
        List activities = caseDefinition.getActivities();
        CmmnActivity casePlanModelActivity = (CmmnActivity)activities.get(0);
        List children = casePlanModelActivity.getActivities();
        Assert.assertEquals((long)1L, (long)children.size());
        CmmnActivity planItemStage = (CmmnActivity)children.get(0);
        Assert.assertEquals((Object)planItemX.getId(), (Object)planItemStage.getId());
        children = planItemStage.getActivities();
        Assert.assertEquals((long)2L, (long)children.size());
        CmmnActivity childPlanItem = (CmmnActivity)children.get(0);
        Assert.assertEquals((Object)planItemA.getId(), (Object)childPlanItem.getId());
        Assert.assertTrue((boolean)childPlanItem.getActivities().isEmpty());
        childPlanItem = (CmmnActivity)children.get(1);
        Assert.assertEquals((Object)planItemB.getId(), (Object)childPlanItem.getId());
        Assert.assertTrue((boolean)childPlanItem.getActivities().isEmpty());
    }

    @Test
    public void testNestedStages() {
        Stage stageX = this.createElement((CmmnModelElementInstance)this.casePlanModel, "X", Stage.class);
        Stage stageY = this.createElement((CmmnModelElementInstance)this.casePlanModel, "Y", Stage.class);
        HumanTask humanTaskA = this.createElement((CmmnModelElementInstance)this.casePlanModel, "A", HumanTask.class);
        HumanTask humanTaskB = this.createElement((CmmnModelElementInstance)this.casePlanModel, "B", HumanTask.class);
        HumanTask humanTaskC = this.createElement((CmmnModelElementInstance)this.casePlanModel, "C", HumanTask.class);
        PlanItem planItemA1 = this.createElement((CmmnModelElementInstance)this.casePlanModel, "PI_A1", PlanItem.class);
        planItemA1.setDefinition((PlanItemDefinition)humanTaskA);
        PlanItem planItemX1 = this.createElement((CmmnModelElementInstance)this.casePlanModel, "PI_X1", PlanItem.class);
        planItemX1.setDefinition((PlanItemDefinition)stageX);
        PlanItem planItemA2 = this.createElement((CmmnModelElementInstance)stageX, "PI_A2", PlanItem.class);
        planItemA2.setDefinition((PlanItemDefinition)humanTaskA);
        PlanItem planItemB = this.createElement((CmmnModelElementInstance)stageX, "PI_B", PlanItem.class);
        planItemB.setDefinition((PlanItemDefinition)humanTaskB);
        PlanItem planItemY = this.createElement((CmmnModelElementInstance)this.casePlanModel, "PI_Y", PlanItem.class);
        planItemY.setDefinition((PlanItemDefinition)stageY);
        PlanItem planItemC = this.createElement((CmmnModelElementInstance)stageY, "PI_C", PlanItem.class);
        planItemC.setDefinition((PlanItemDefinition)humanTaskC);
        PlanItem planItemX2 = this.createElement((CmmnModelElementInstance)stageY, "PI_X2", PlanItem.class);
        planItemX2.setDefinition((PlanItemDefinition)stageX);
        List<CaseDefinitionEntity> caseDefinitions = this.transform();
        Assert.assertEquals((long)1L, (long)caseDefinitions.size());
        CaseDefinitionEntity caseDefinition = caseDefinitions.get(0);
        List activities = caseDefinition.getActivities();
        CmmnActivity casePlanModelActivity = (CmmnActivity)activities.get(0);
        List children = casePlanModelActivity.getActivities();
        Assert.assertEquals((long)3L, (long)children.size());
        CmmnActivity childPlanItem = (CmmnActivity)children.get(0);
        Assert.assertEquals((Object)planItemA1.getId(), (Object)childPlanItem.getId());
        Assert.assertTrue((boolean)childPlanItem.getActivities().isEmpty());
        childPlanItem = (CmmnActivity)children.get(1);
        Assert.assertEquals((Object)planItemX1.getId(), (Object)childPlanItem.getId());
        List childrenOfX1 = childPlanItem.getActivities();
        Assert.assertFalse((boolean)childrenOfX1.isEmpty());
        Assert.assertEquals((long)2L, (long)childrenOfX1.size());
        childPlanItem = (CmmnActivity)childrenOfX1.get(0);
        Assert.assertEquals((Object)planItemA2.getId(), (Object)childPlanItem.getId());
        Assert.assertTrue((boolean)childPlanItem.getActivities().isEmpty());
        childPlanItem = (CmmnActivity)childrenOfX1.get(1);
        Assert.assertEquals((Object)planItemB.getId(), (Object)childPlanItem.getId());
        Assert.assertTrue((boolean)childPlanItem.getActivities().isEmpty());
        childPlanItem = (CmmnActivity)children.get(2);
        Assert.assertEquals((Object)planItemY.getId(), (Object)childPlanItem.getId());
        List childrenOfY = childPlanItem.getActivities();
        Assert.assertFalse((boolean)childrenOfY.isEmpty());
        Assert.assertEquals((long)2L, (long)childrenOfY.size());
        childPlanItem = (CmmnActivity)childrenOfY.get(0);
        Assert.assertEquals((Object)planItemC.getId(), (Object)childPlanItem.getId());
        Assert.assertTrue((boolean)childPlanItem.getActivities().isEmpty());
        childPlanItem = (CmmnActivity)childrenOfY.get(1);
        Assert.assertEquals((Object)planItemX2.getId(), (Object)childPlanItem.getId());
        List childrenOfX2 = childPlanItem.getActivities();
        Assert.assertFalse((boolean)childrenOfX2.isEmpty());
        Assert.assertEquals((long)2L, (long)childrenOfX2.size());
        childPlanItem = (CmmnActivity)childrenOfX2.get(0);
        Assert.assertEquals((Object)planItemA2.getId(), (Object)childPlanItem.getId());
        Assert.assertTrue((boolean)childPlanItem.getActivities().isEmpty());
        childPlanItem = (CmmnActivity)childrenOfX2.get(1);
        Assert.assertEquals((Object)planItemB.getId(), (Object)childPlanItem.getId());
        Assert.assertTrue((boolean)childPlanItem.getActivities().isEmpty());
    }
}

