/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.db;

import java.util.Date;
import org.camunda.bpm.engine.impl.cmd.AcquireJobsCmd;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.AcquiredJobs;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;

public class ProcessInstanceSuspensionTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/db/oneJobProcess.bpmn20.xml"})
    public void testJobsNotVisisbleToAcquisitionIfInstanceSuspended() {
        ProcessDefinition pd = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey(pd.getKey());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        ProcessInstanceSuspensionTest.assertNotNull((Object)job);
        this.makeSureJobDue(job);
        AcquiredJobs acquiredJobs = this.executeAcquireJobsCommand();
        ProcessInstanceSuspensionTest.assertEquals((int)1, (int)acquiredJobs.size());
        this.runtimeService.suspendProcessInstanceById(pi.getId());
        acquiredJobs = this.executeAcquireJobsCommand();
        ProcessInstanceSuspensionTest.assertEquals((int)0, (int)acquiredJobs.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/db/oneJobProcess.bpmn20.xml"})
    public void testJobsNotVisisbleToAcquisitionIfDefinitionSuspended() {
        ProcessDefinition pd = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceByKey(pd.getKey());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        ProcessInstanceSuspensionTest.assertNotNull((Object)job);
        this.makeSureJobDue(job);
        AcquiredJobs acquiredJobs = this.executeAcquireJobsCommand();
        ProcessInstanceSuspensionTest.assertEquals((int)1, (int)acquiredJobs.size());
        this.repositoryService.suspendProcessDefinitionById(pd.getId());
        acquiredJobs = this.executeAcquireJobsCommand();
        ProcessInstanceSuspensionTest.assertEquals((int)0, (int)acquiredJobs.size());
    }

    protected void makeSureJobDue(final Job job) {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                Date currentTime = ClockUtil.getCurrentTime();
                commandContext.getJobManager().findJobById(job.getId()).setDuedate(new Date(currentTime.getTime() - 10000L));
                return null;
            }
        });
    }

    private AcquiredJobs executeAcquireJobsCommand() {
        return (AcquiredJobs)this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new AcquireJobsCmd(this.processEngineConfiguration.getJobExecutor()));
    }
}

