/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.el;

import java.util.HashMap;
import org.camunda.bpm.engine.delegate.Expression;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.el.util.TestVariableScope;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.spin.xml.tree.SpinXmlTreeElement;

public class SpinElSupportTest
extends PluggableProcessEngineTestCase {
    String xmlString = "<elementName attrName=\"attrValue\" />";

    protected <T> T executeExpression(String expression) {
        final TestVariableScope varScope = new TestVariableScope();
        final Expression compiledExpression = this.processEngineConfiguration.getExpressionManager().createExpression(expression);
        return (T)this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                return compiledExpression.getValue((VariableScope)varScope);
            }
        });
    }

    public void testSpin_S_Available() {
        SpinXmlTreeElement spinXmlEl = (SpinXmlTreeElement)this.executeExpression("${ S('" + this.xmlString + "') }");
        SpinElSupportTest.assertNotNull((Object)spinXmlEl);
        SpinElSupportTest.assertEquals((String)"elementName", (String)spinXmlEl.name());
    }

    public void testSpin_XML_Available() {
        SpinXmlTreeElement spinXmlEl = (SpinXmlTreeElement)this.executeExpression("${ XML('" + this.xmlString + "') }");
        SpinElSupportTest.assertNotNull((Object)spinXmlEl);
        SpinElSupportTest.assertEquals((String)"elementName", (String)spinXmlEl.name());
    }

    public void testSpin_XPath_Available() {
        String elName = (String)this.executeExpression("${ S('" + this.xmlString + "').xPath('/elementName').element().name() }");
        SpinElSupportTest.assertNotNull((Object)elName);
        SpinElSupportTest.assertEquals((String)"elementName", (String)elName);
    }

    public void testSpinAvailableInBpmn() {
        BpmnModelInstance bpmnModelInstance = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().serviceTask().camundaExpression("${ execution.setVariable('customer', S(xmlVar).xPath('/customers/customer').element().toString())}")).receiveTask("wait").endEvent().done();
        Deployment deployment = this.repositoryService.createDeployment().addModelInstance("process.bpmn", bpmnModelInstance).deploy();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("xmlVar", "<customers><customer /></customers>");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        String customerXml = (String)this.runtimeService.getVariable(pi.getId(), "customer");
        SpinElSupportTest.assertNotNull((Object)customerXml);
        SpinElSupportTest.assertTrue((boolean)customerXml.contains("customer"));
        SpinElSupportTest.assertFalse((boolean)customerXml.contains("customers"));
        this.runtimeService.signal(pi.getId());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }
}

