/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.examples.bpmn.gateway;

import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class InclusiveGatewayTest
extends PluggableProcessEngineTestCase {
    private static final String TASK1_NAME = "Send e-mail for more information";
    private static final String TASK2_NAME = "Check account balance";
    private static final String TASK3_NAME = "Call customer";

    @Deployment
    public void testDecisionFunctionality() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("input", 1);
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("inclusiveGateway", variables);
        List tasks = this.taskService.createTaskQuery().processInstanceId(pi.getId()).list();
        InclusiveGatewayTest.assertEquals((int)3, (int)tasks.size());
        HashMap<String, String> expectedMessages = new HashMap<String, String>();
        expectedMessages.put(TASK1_NAME, TASK1_NAME);
        expectedMessages.put(TASK2_NAME, TASK2_NAME);
        expectedMessages.put(TASK3_NAME, TASK3_NAME);
        for (Task task : tasks) {
            expectedMessages.remove(task.getName());
        }
        InclusiveGatewayTest.assertEquals((int)0, (int)expectedMessages.size());
        variables.put("input", 2);
        pi = this.runtimeService.startProcessInstanceByKey("inclusiveGateway", variables);
        tasks = this.taskService.createTaskQuery().processInstanceId(pi.getId()).list();
        InclusiveGatewayTest.assertEquals((int)2, (int)tasks.size());
        expectedMessages = new HashMap();
        expectedMessages.put(TASK2_NAME, TASK2_NAME);
        expectedMessages.put(TASK3_NAME, TASK3_NAME);
        for (Task task : tasks) {
            expectedMessages.remove(task.getName());
        }
        InclusiveGatewayTest.assertEquals((int)0, (int)expectedMessages.size());
        variables.put("input", 3);
        pi = this.runtimeService.startProcessInstanceByKey("inclusiveGateway", variables);
        tasks = this.taskService.createTaskQuery().processInstanceId(pi.getId()).list();
        InclusiveGatewayTest.assertEquals((int)1, (int)tasks.size());
        expectedMessages = new HashMap();
        expectedMessages.put(TASK3_NAME, TASK3_NAME);
        for (Task task : tasks) {
            expectedMessages.remove(task.getName());
        }
        InclusiveGatewayTest.assertEquals((int)0, (int)expectedMessages.size());
        variables.put("input", 4);
        try {
            this.runtimeService.startProcessInstanceByKey("inclusiveGateway", variables);
            InclusiveGatewayTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }
}

