/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.examples.bpmn.servicetask;

import java.util.HashMap;
import org.camunda.bpm.engine.ClassLoadingException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.CollectionUtil;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.examples.bpmn.servicetask.GenderBean;

public class JavaServiceTaskTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testJavaServiceDelegation() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("javaServiceDelegation", CollectionUtil.singletonMap((String)"input", (Object)"Activiti BPM Engine"));
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi.getId()).activityId("waitState").singleResult();
        JavaServiceTaskTest.assertEquals((Object)"ACTIVITI BPM ENGINE", (Object)this.runtimeService.getVariable(execution.getId(), "input"));
    }

    @Deployment
    public void testFieldInjection() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("fieldInjection");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi.getId()).activityId("waitState").singleResult();
        JavaServiceTaskTest.assertEquals((Object)"HELLO WORLD", (Object)this.runtimeService.getVariable(execution.getId(), "var"));
        JavaServiceTaskTest.assertEquals((Object)"HELLO SETTER", (Object)this.runtimeService.getVariable(execution.getId(), "setterVar"));
    }

    @Deployment
    public void testExpressionFieldInjection() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("name", "kermit");
        vars.put("gender", "male");
        vars.put("genderBean", new GenderBean());
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("expressionFieldInjection", vars);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi.getId()).activityId("waitState").singleResult();
        JavaServiceTaskTest.assertEquals((Object)"timrek .rM olleH", (Object)this.runtimeService.getVariable(execution.getId(), "var2"));
        JavaServiceTaskTest.assertEquals((Object)"elam :si redneg ruoY", (Object)this.runtimeService.getVariable(execution.getId(), "var1"));
    }

    @Deployment
    public void testUnexistingClassDelegation() {
        try {
            this.runtimeService.startProcessInstanceByKey("unexistingClassDelegation");
            JavaServiceTaskTest.fail();
        }
        catch (ProcessEngineException e) {
            JavaServiceTaskTest.assertTrue((boolean)e.getMessage().contains("couldn't instantiate class org.camunda.bpm.engine.test.BogusClass"));
            JavaServiceTaskTest.assertNotNull((Object)e.getCause());
            JavaServiceTaskTest.assertTrue((boolean)(e.getCause() instanceof ClassLoadingException));
        }
    }

    public void testIllegalUseOfResultVariableName() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/examples/bpmn/servicetask/JavaServiceTaskTest.testIllegalUseOfResultVariableName.bpmn20.xml").deploy();
            JavaServiceTaskTest.fail();
        }
        catch (ProcessEngineException e) {
            JavaServiceTaskTest.assertTrue((boolean)e.getMessage().contains("resultVariable"));
        }
    }

    @Deployment
    public void testExceptionHandling() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("var", "no-exception");
        this.runtimeService.startProcessInstanceByKey("exceptionHandling", vars);
        JavaServiceTaskTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        vars.put("var", "throw-exception");
        this.runtimeService.startProcessInstanceByKey("exceptionHandling", vars);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        JavaServiceTaskTest.assertEquals((String)"Fix Exception", (String)task.getName());
    }

    @Deployment
    public void testGetBusinessKeyFromDelegateExecution() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("businessKeyProcess", "1234567890");
        JavaServiceTaskTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("businessKeyProcess").count());
        String key = (String)this.runtimeService.getVariable(processInstance.getId(), "businessKeySetOnExecution");
        JavaServiceTaskTest.assertNotNull((Object)key);
        JavaServiceTaskTest.assertEquals((String)"1234567890", (String)key);
    }
}

