/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.examples.bpmn.subprocess;

import java.util.List;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;

public class SubProcessTest
extends PluggableProcessEngineTestCase {
    public void testSimpleSubProcess() {
        Deployment deployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/examples/bpmn/subprocess/SubProcessTest.fixSystemFailureProcess.bpmn20.xml").deploy();
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("fixSystemFailure");
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(pi.getId()).orderByTaskName().asc()).list();
        SubProcessTest.assertEquals((int)2, (int)tasks.size());
        Task investigateHardwareTask = (Task)tasks.get(0);
        Task investigateSoftwareTask = (Task)tasks.get(1);
        SubProcessTest.assertEquals((String)"Investigate hardware", (String)investigateHardwareTask.getName());
        SubProcessTest.assertEquals((String)"Investigate software", (String)investigateSoftwareTask.getName());
        this.taskService.complete(investigateHardwareTask.getId());
        this.taskService.complete(investigateSoftwareTask.getId());
        Task writeReportTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        SubProcessTest.assertEquals((String)"Write report", (String)writeReportTask.getName());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }
}

