/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.examples.mgmt;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.management.TablePage;
import org.camunda.bpm.engine.task.Task;

public class TablePageQueryTest
extends PluggableProcessEngineTestCase {
    public void testGetTablePage() {
        String tablePrefix = this.processEngineConfiguration.getDatabaseTablePrefix();
        List<String> taskIds = this.generateDummyTasks(20);
        TablePage tablePage = this.managementService.createTablePageQuery().tableName(tablePrefix + "ACT_RU_TASK").listPage(0, 5);
        TablePageQueryTest.assertEquals((long)0L, (long)tablePage.getFirstResult());
        TablePageQueryTest.assertEquals((long)5L, (long)tablePage.getSize());
        TablePageQueryTest.assertEquals((int)5, (int)tablePage.getRows().size());
        TablePageQueryTest.assertEquals((long)20L, (long)tablePage.getTotal());
        tablePage = this.managementService.createTablePageQuery().tableName(tablePrefix + "ACT_RU_TASK").listPage(14, 10);
        TablePageQueryTest.assertEquals((long)14L, (long)tablePage.getFirstResult());
        TablePageQueryTest.assertEquals((long)6L, (long)tablePage.getSize());
        TablePageQueryTest.assertEquals((int)6, (int)tablePage.getRows().size());
        TablePageQueryTest.assertEquals((long)20L, (long)tablePage.getTotal());
        this.taskService.deleteTasks(taskIds, true);
    }

    public void testGetSortedTablePage() {
        String tablePrefix = this.processEngineConfiguration.getDatabaseTablePrefix();
        List<String> taskIds = this.generateDummyTasks(15);
        TablePage tablePage = this.managementService.createTablePageQuery().tableName(tablePrefix + "ACT_RU_TASK").orderAsc("NAME_").listPage(1, 7);
        String[] expectedTaskNames = new String[]{"B", "C", "D", "E", "F", "G", "H"};
        this.verifyTaskNames(expectedTaskNames, tablePage.getRows());
        tablePage = this.managementService.createTablePageQuery().tableName(tablePrefix + "ACT_RU_TASK").orderDesc("NAME_").listPage(6, 8);
        expectedTaskNames = new String[]{"I", "H", "G", "F", "E", "D", "C", "B"};
        this.verifyTaskNames(expectedTaskNames, tablePage.getRows());
        this.taskService.deleteTasks(taskIds, true);
    }

    private void verifyTaskNames(String[] expectedTaskNames, List<Map<String, Object>> rowData) {
        TablePageQueryTest.assertEquals((int)expectedTaskNames.length, (int)rowData.size());
        String columnKey = "NAME_";
        if (this.processEngineConfiguration.getDatabaseType().equals("postgres")) {
            columnKey = "name_";
        }
        for (int i = 0; i < expectedTaskNames.length; ++i) {
            TablePageQueryTest.assertEquals((Object)expectedTaskNames[i], (Object)rowData.get(i).get(columnKey));
        }
    }

    private List<String> generateDummyTasks(int nrOfTasks) {
        ArrayList<String> taskIds = new ArrayList<String>();
        for (int i = 0; i < nrOfTasks; ++i) {
            Task task = this.taskService.newTask();
            task.setName((char)(65 + i) + "");
            this.taskService.saveTask(task);
            taskIds.add(task.getId());
        }
        return taskIds;
    }
}

