/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstanceQuery;
import org.camunda.bpm.engine.history.HistoricVariableUpdate;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.camunda.bpm.engine.impl.test.AbstractProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.CollectionUtil;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.runtime.util.FailingSerializable;

public class HistoricVariableInstanceTest
extends AbstractProcessEngineTestCase {
    protected void initializeProcessEngine() {
        this.processEngineConfiguration = (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createStandaloneProcessEngineConfiguration().setProcessEngineName("HistoricVariableInstanceTest-engine").setJdbcDriver("org.h2.Driver").setJdbcUrl("jdbc:h2:mem:HistoricVariableInstanceTest;DB_CLOSE_DELAY=1000").setJdbcUsername("sa").setJdbcPassword("").setDatabaseSchemaUpdate("true").setJobExecutorActivate(false).setHistory("full");
        this.processEngine = this.processEngineConfiguration.buildProcessEngine();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/examples/bpmn/callactivity/orderProcess.bpmn20.xml", "org/camunda/bpm/engine/test/examples/bpmn/callactivity/checkCreditProcess.bpmn20.xml"})
    public void testOrderProcessWithCallActivity() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("orderProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task verifyCreditTask = (Task)taskQuery.singleResult();
        HistoricVariableInstanceTest.assertEquals((String)"Verify credit history", (String)verifyCreditTask.getName());
        ProcessInstance subProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(pi.getId()).singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)subProcessInstance);
        HistoricVariableInstanceTest.assertEquals((String)pi.getId(), (String)((ProcessInstance)this.runtimeService.createProcessInstanceQuery().subProcessInstanceId(subProcessInstance.getId()).singleResult()).getId());
        this.taskService.complete(verifyCreditTask.getId(), CollectionUtil.singletonMap((String)"creditApproved", (Object)true));
        Task prepareAndShipTask = (Task)taskQuery.singleResult();
        HistoricVariableInstanceTest.assertEquals((String)"Prepare and Ship", (String)prepareAndShipTask.getName());
    }

    @Deployment
    public void testSimple() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("myProc");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task userTask = (Task)taskQuery.singleResult();
        HistoricVariableInstanceTest.assertEquals((String)"userTask1", (String)userTask.getName());
        this.taskService.complete(userTask.getId(), CollectionUtil.singletonMap((String)"myVar", (Object)"test789"));
        this.assertProcessEnded(processInstance.getId());
        List variables = this.historyService.createHistoricVariableInstanceQuery().list();
        HistoricVariableInstanceTest.assertEquals((int)1, (int)variables.size());
        HistoricVariableInstanceEntity historicVariable = (HistoricVariableInstanceEntity)variables.get(0);
        HistoricVariableInstanceTest.assertEquals((String)"test456", (String)historicVariable.getTextValue());
        HistoricVariableInstanceTest.assertEquals((long)5L, (long)this.historyService.createHistoricActivityInstanceQuery().count());
        HistoricVariableInstanceTest.assertEquals((long)3L, (long)this.historyService.createHistoricDetailQuery().count());
    }

    @Deployment
    public void testSimpleNoWaitState() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("myProc");
        this.assertProcessEnded(processInstance.getId());
        List variables = this.historyService.createHistoricVariableInstanceQuery().list();
        HistoricVariableInstanceTest.assertEquals((int)1, (int)variables.size());
        HistoricVariableInstanceEntity historicVariable = (HistoricVariableInstanceEntity)variables.get(0);
        HistoricVariableInstanceTest.assertEquals((String)"test456", (String)historicVariable.getTextValue());
        HistoricVariableInstanceTest.assertEquals((long)4L, (long)this.historyService.createHistoricActivityInstanceQuery().count());
        HistoricVariableInstanceTest.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().count());
    }

    @Deployment
    public void testParallel() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("myProc");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task userTask = (Task)taskQuery.singleResult();
        HistoricVariableInstanceTest.assertEquals((String)"userTask1", (String)userTask.getName());
        this.taskService.complete(userTask.getId(), CollectionUtil.singletonMap((String)"myVar", (Object)"test789"));
        this.assertProcessEnded(processInstance.getId());
        List variables = ((HistoricVariableInstanceQuery)this.historyService.createHistoricVariableInstanceQuery().orderByVariableName().asc()).list();
        HistoricVariableInstanceTest.assertEquals((int)2, (int)variables.size());
        HistoricVariableInstanceEntity historicVariable = (HistoricVariableInstanceEntity)variables.get(0);
        HistoricVariableInstanceTest.assertEquals((String)"myVar", (String)historicVariable.getName());
        HistoricVariableInstanceTest.assertEquals((String)"test789", (String)historicVariable.getTextValue());
        HistoricVariableInstanceEntity historicVariable1 = (HistoricVariableInstanceEntity)variables.get(1);
        HistoricVariableInstanceTest.assertEquals((String)"myVar1", (String)historicVariable1.getName());
        HistoricVariableInstanceTest.assertEquals((String)"test456", (String)historicVariable1.getTextValue());
        HistoricVariableInstanceTest.assertEquals((long)8L, (long)this.historyService.createHistoricActivityInstanceQuery().count());
        HistoricVariableInstanceTest.assertEquals((long)5L, (long)this.historyService.createHistoricDetailQuery().count());
    }

    @Deployment
    public void testParallelNoWaitState() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("myProc");
        this.assertProcessEnded(processInstance.getId());
        List variables = this.historyService.createHistoricVariableInstanceQuery().list();
        HistoricVariableInstanceTest.assertEquals((int)1, (int)variables.size());
        HistoricVariableInstanceEntity historicVariable = (HistoricVariableInstanceEntity)variables.get(0);
        HistoricVariableInstanceTest.assertEquals((String)"test456", (String)historicVariable.getTextValue());
        HistoricVariableInstanceTest.assertEquals((long)7L, (long)this.historyService.createHistoricActivityInstanceQuery().count());
        HistoricVariableInstanceTest.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().count());
    }

    @Deployment
    public void testTwoSubProcessInParallelWithinSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("twoSubProcessInParallelWithinSubProcess");
        this.assertProcessEnded(processInstance.getId());
        List variables = ((HistoricVariableInstanceQuery)this.historyService.createHistoricVariableInstanceQuery().orderByVariableName().asc()).list();
        HistoricVariableInstanceTest.assertEquals((int)2, (int)variables.size());
        HistoricVariableInstanceEntity historicVariable = (HistoricVariableInstanceEntity)variables.get(0);
        HistoricVariableInstanceTest.assertEquals((String)"myVar", (String)historicVariable.getName());
        HistoricVariableInstanceTest.assertEquals((String)"test101112", (String)historicVariable.getTextValue());
        HistoricVariableInstanceTest.assertEquals((String)"string", (String)historicVariable.getVariableTypeName());
        HistoricVariableInstanceEntity historicVariable1 = (HistoricVariableInstanceEntity)variables.get(1);
        HistoricVariableInstanceTest.assertEquals((String)"myVar1", (String)historicVariable1.getName());
        HistoricVariableInstanceTest.assertEquals((String)"test789", (String)historicVariable1.getTextValue());
        HistoricVariableInstanceTest.assertEquals((String)"string", (String)historicVariable1.getVariableTypeName());
        HistoricVariableInstanceTest.assertEquals((long)18L, (long)this.historyService.createHistoricActivityInstanceQuery().count());
        HistoricVariableInstanceTest.assertEquals((long)7L, (long)this.historyService.createHistoricDetailQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricVariableInstanceTest.testCallSimpleSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/history/simpleSubProcess.bpmn20.xml"})
    public void testHistoricVariableInstanceQuery() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callSimpleSubProcess");
        this.assertProcessEnded(processInstance.getId());
        HistoricVariableInstanceTest.assertEquals((long)4L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        HistoricVariableInstanceTest.assertEquals((int)4, (int)this.historyService.createHistoricVariableInstanceQuery().list().size());
        HistoricVariableInstanceTest.assertEquals((long)4L, (long)((HistoricVariableInstanceQuery)this.historyService.createHistoricVariableInstanceQuery().orderByProcessInstanceId().asc()).count());
        HistoricVariableInstanceTest.assertEquals((int)4, (int)((HistoricVariableInstanceQuery)this.historyService.createHistoricVariableInstanceQuery().orderByProcessInstanceId().asc()).list().size());
        HistoricVariableInstanceTest.assertEquals((long)4L, (long)((HistoricVariableInstanceQuery)this.historyService.createHistoricVariableInstanceQuery().orderByVariableName().asc()).count());
        HistoricVariableInstanceTest.assertEquals((int)4, (int)((HistoricVariableInstanceQuery)this.historyService.createHistoricVariableInstanceQuery().orderByVariableName().asc()).list().size());
        HistoricVariableInstanceTest.assertEquals((long)2L, (long)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).count());
        HistoricVariableInstanceTest.assertEquals((int)2, (int)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).list().size());
        HistoricVariableInstanceTest.assertEquals((long)2L, (long)this.historyService.createHistoricVariableInstanceQuery().variableName("myVar").count());
        HistoricVariableInstanceTest.assertEquals((int)2, (int)this.historyService.createHistoricVariableInstanceQuery().variableName("myVar").list().size());
        HistoricVariableInstanceTest.assertEquals((long)2L, (long)this.historyService.createHistoricVariableInstanceQuery().variableNameLike("myVar1").count());
        HistoricVariableInstanceTest.assertEquals((int)2, (int)this.historyService.createHistoricVariableInstanceQuery().variableNameLike("myVar1").list().size());
        List variables = this.historyService.createHistoricVariableInstanceQuery().list();
        HistoricVariableInstanceTest.assertEquals((int)4, (int)variables.size());
        HistoricVariableInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("myVar", (Object)"test123").count());
        HistoricVariableInstanceTest.assertEquals((int)1, (int)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("myVar", (Object)"test123").list().size());
        HistoricVariableInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("myVar1", (Object)"test456").count());
        HistoricVariableInstanceTest.assertEquals((int)1, (int)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("myVar1", (Object)"test456").list().size());
        HistoricVariableInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("myVar", (Object)"test666").count());
        HistoricVariableInstanceTest.assertEquals((int)1, (int)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("myVar", (Object)"test666").list().size());
        HistoricVariableInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("myVar1", (Object)"test666").count());
        HistoricVariableInstanceTest.assertEquals((int)1, (int)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("myVar1", (Object)"test666").list().size());
        HistoricVariableInstanceTest.assertEquals((long)8L, (long)this.historyService.createHistoricActivityInstanceQuery().count());
        HistoricVariableInstanceTest.assertEquals((long)5L, (long)this.historyService.createHistoricDetailQuery().count());
        HistoricVariableInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricVariableInstanceQuery().variableId("non-existing").count());
        List variable = this.historyService.createHistoricVariableInstanceQuery().listPage(0, 1);
        HistoricVariableInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableId(((HistoricVariableInstance)variable.get(0)).getId()).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testHistoricProcessVariableOnDeletion() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("testVar", "Hallo Christian");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "deleted");
        this.assertProcessEnded(processInstance.getId());
        HistoricVariableInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).variableValueEquals("testVar", (Object)"Hallo Christian").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/standalone/history/FullHistoryTest.testVariableUpdatesAreLinkedToActivity.bpmn20.xml"})
    public void testVariableUpdatesLinkedToActivity() throws Exception {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("ProcessWithSubProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("test", "1");
        this.taskService.complete(task.getId(), variables);
        task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        variables.clear();
        variables.put("test", "2");
        this.taskService.complete(task.getId(), variables);
        this.assertProcessEnded(pi.getId());
        List updates = this.historyService.createHistoricDetailQuery().variableUpdates().list();
        HistoricVariableInstanceTest.assertEquals((int)2, (int)updates.size());
        HashMap<String, HistoricVariableUpdate> updatesMap = new HashMap<String, HistoricVariableUpdate>();
        HistoricVariableUpdate update = (HistoricVariableUpdate)updates.get(0);
        updatesMap.put((String)update.getValue(), update);
        update = (HistoricVariableUpdate)updates.get(1);
        updatesMap.put((String)update.getValue(), update);
        HistoricVariableUpdate update1 = (HistoricVariableUpdate)updatesMap.get("1");
        HistoricVariableUpdate update2 = (HistoricVariableUpdate)updatesMap.get("2");
        HistoricVariableInstanceTest.assertNotNull((Object)update1.getActivityInstanceId());
        HistoricVariableInstanceTest.assertNotNull((Object)update1.getExecutionId());
        HistoricActivityInstance historicActivityInstance1 = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityInstanceId(update1.getActivityInstanceId()).singleResult();
        HistoricVariableInstanceTest.assertEquals((String)historicActivityInstance1.getExecutionId(), (String)update1.getExecutionId());
        HistoricVariableInstanceTest.assertEquals((String)"usertask1", (String)historicActivityInstance1.getActivityId());
        HistoricVariableInstanceTest.assertNotNull((Object)update2.getActivityInstanceId());
        HistoricActivityInstance historicActivityInstance2 = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityInstanceId(update2.getActivityInstanceId()).singleResult();
        HistoricVariableInstanceTest.assertEquals((String)"usertask2", (String)historicActivityInstance2.getActivityId());
        HistoricVariableInstanceTest.assertFalse((boolean)historicActivityInstance2.getExecutionId().equals(update2.getExecutionId()));
    }

    @Deployment
    public void testHistoricProcessInstanceDeleteCascadesCorrectly() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("var1", "value1");
        variables.put("var2", "value2");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("myProcess", variables);
        HistoricVariableInstanceTest.assertNotNull((Object)processInstance);
        variables = new HashMap();
        variables.put("var3", "value3");
        variables.put("var4", "value4");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("myProcess", variables);
        HistoricVariableInstanceTest.assertNotNull((Object)processInstance2);
        long count = this.historyService.createHistoricVariableInstanceQuery().count();
        HistoricVariableInstanceTest.assertEquals((long)4L, (long)count);
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "reason 1");
        this.historyService.deleteHistoricProcessInstance(processInstance.getId());
        count = this.historyService.createHistoricVariableInstanceQuery().count();
        HistoricVariableInstanceTest.assertEquals((long)2L, (long)count);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricVariableInstanceTest.testParallel.bpmn20.xml"})
    public void testHistoricVariableInstanceQueryByTaskIds() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("myProc");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task userTask = (Task)taskQuery.singleResult();
        HistoricVariableInstanceTest.assertEquals((String)"userTask1", (String)userTask.getName());
        this.taskService.setVariableLocal(userTask.getId(), "taskVariable", (Object)"aCustomValue");
        this.taskService.complete(userTask.getId());
        this.assertProcessEnded(processInstance.getId());
        List tasks = this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstance.getProcessInstanceId()).list();
        HistoricVariableInstanceTest.assertEquals((int)1, (int)tasks.size());
        HistoricVariableInstanceTest.assertEquals((long)3L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        HistoricVariableInstanceTest.assertEquals((int)1, (int)this.historyService.createHistoricVariableInstanceQuery().taskIdIn(new String[]{((HistoricTaskInstance)tasks.get(0)).getId()}).list().size());
        HistoricVariableInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().taskIdIn(new String[]{((HistoricTaskInstance)tasks.get(0)).getId()}).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testHistoricVariableInstanceQueryByExecutionIds() {
        HashMap<String, String> variables1 = new HashMap<String, String>();
        variables1.put("stringVar", "test");
        variables1.put("myVar", "test123");
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HistoricVariableInstanceTest.assertEquals((int)2, (int)this.historyService.createHistoricVariableInstanceQuery().executionIdIn(new String[]{processInstance1.getId()}).list().size());
        HistoricVariableInstanceTest.assertEquals((long)2L, (long)this.historyService.createHistoricVariableInstanceQuery().executionIdIn(new String[]{processInstance1.getId()}).count());
        HashMap<String, String> variables2 = new HashMap<String, String>();
        variables2.put("myVar", "test123");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables2);
        HistoricVariableInstanceTest.assertEquals((int)3, (int)this.historyService.createHistoricVariableInstanceQuery().executionIdIn(new String[]{processInstance1.getId(), processInstance2.getId()}).list().size());
        HistoricVariableInstanceTest.assertEquals((long)3L, (long)this.historyService.createHistoricVariableInstanceQuery().executionIdIn(new String[]{processInstance1.getId(), processInstance2.getId()}).count());
    }

    public void testQueryByInvalidExecutionIdIn() {
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery().executionIdIn(new String[]{"invalid"});
        HistoricVariableInstanceTest.assertEquals((long)0L, (long)query.count());
        try {
            this.historyService.createHistoricVariableInstanceQuery().executionIdIn(null);
            HistoricVariableInstanceTest.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.historyService.createHistoricVariableInstanceQuery().executionIdIn(new String[]{null});
            HistoricVariableInstanceTest.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByInvalidTaskIdIn() {
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery().taskIdIn(new String[]{"invalid"});
        HistoricVariableInstanceTest.assertEquals((long)0L, (long)query.count());
        try {
            this.historyService.createHistoricVariableInstanceQuery().taskIdIn(null);
            HistoricVariableInstanceTest.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.historyService.createHistoricVariableInstanceQuery().taskIdIn(new String[]{null});
            HistoricVariableInstanceTest.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByActivityInstanceIdIn() {
        HashMap<String, String> variables1 = new HashMap<String, String>();
        variables1.put("stringVar", "test");
        variables1.put("myVar", "test123");
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        query.activityInstanceIdIn(new String[]{processInstance1.getId()});
        HistoricVariableInstanceTest.assertEquals((int)2, (int)query.list().size());
        HistoricVariableInstanceTest.assertEquals((long)2L, (long)query.count());
        HashMap<String, String> variables2 = new HashMap<String, String>();
        variables2.put("myVar", "test123");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables2);
        query.activityInstanceIdIn(new String[]{processInstance1.getId(), processInstance2.getId()});
        HistoricVariableInstanceTest.assertEquals((int)3, (int)query.list().size());
        HistoricVariableInstanceTest.assertEquals((long)3L, (long)query.count());
    }

    public void testQueryByInvalidActivityInstanceIdIn() {
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        query.taskIdIn(new String[]{"invalid"});
        HistoricVariableInstanceTest.assertEquals((long)0L, (long)query.count());
        try {
            query.taskIdIn(null);
            HistoricVariableInstanceTest.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            query.taskIdIn(new String[]{null});
            HistoricVariableInstanceTest.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testBinaryFetchingEnabled() {
        Task newTask = this.taskService.newTask();
        this.taskService.saveTask(newTask);
        String variableName = "binaryVariableName";
        this.taskService.setVariable(newTask.getId(), variableName, (Object)"some bytes".getBytes());
        HistoricVariableInstance variableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName(variableName).singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)variableInstance.getValue());
        this.taskService.deleteTask(newTask.getId(), true);
    }

    public void testBinaryFetchingDisabled() {
        Task newTask = this.taskService.newTask();
        this.taskService.saveTask(newTask);
        String variableName = "binaryVariableName";
        this.taskService.setVariable(newTask.getId(), variableName, (Object)"some bytes".getBytes());
        HistoricVariableInstance variableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName(variableName).disableBinaryFetching().singleResult();
        HistoricVariableInstanceTest.assertNull((Object)variableInstance.getValue());
        this.taskService.deleteTask(newTask.getId(), true);
    }

    public void testErrorMessage() {
        Task newTask = this.taskService.newTask();
        this.taskService.saveTask(newTask);
        String variableName = "failingSerializable";
        this.taskService.setVariable(newTask.getId(), variableName, (Object)new FailingSerializable());
        HistoricVariableInstance variableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName(variableName).singleResult();
        HistoricVariableInstanceTest.assertNull((Object)variableInstance.getValue());
        HistoricVariableInstanceTest.assertNotNull((Object)variableInstance.getErrorMessage());
        this.taskService.deleteTask(newTask.getId(), true);
    }
}

