/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.history.UserOperationLogQuery;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Attachment;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class OperationLogQueryTest
extends PluggableProcessEngineTestCase {
    private ProcessInstance process;
    private Task userTask;
    private Execution execution;
    private String processTaskId;
    private Date today = new Date(ClockUtil.getCurrentTime().getTime() / 1000L * 1000L);
    private Date tomorrow = new Date((ClockUtil.getCurrentTime().getTime() + 86400000L) / 1000L * 1000L);
    private Date yesterday = new Date((ClockUtil.getCurrentTime().getTime() - 86400000L) / 1000L * 1000L);

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testQuery() {
        int i;
        int i2;
        this.createLogEntries();
        OperationLogQueryTest.assertEquals((long)17L, (long)this.query().count());
        OperationLogQueryTest.assertEquals((long)11L, (long)this.query().entityType("Task").count());
        OperationLogQueryTest.assertEquals((long)4L, (long)this.query().entityType("IdentityLink").count());
        OperationLogQueryTest.assertEquals((long)2L, (long)this.query().entityType("Attachment").count());
        OperationLogQueryTest.assertEquals((long)0L, (long)this.query().entityType("unknown entity type").count());
        OperationLogQueryTest.assertEquals((long)1L, (long)this.query().operationType("Create").count());
        OperationLogQueryTest.assertEquals((long)1L, (long)this.query().operationType("SetPriority").count());
        OperationLogQueryTest.assertEquals((long)4L, (long)this.query().operationType("Update").count());
        OperationLogQueryTest.assertEquals((long)1L, (long)this.query().operationType("AddUserLink").count());
        OperationLogQueryTest.assertEquals((long)1L, (long)this.query().operationType("DeleteUserLink").count());
        OperationLogQueryTest.assertEquals((long)1L, (long)this.query().operationType("AddGroupLink").count());
        OperationLogQueryTest.assertEquals((long)1L, (long)this.query().operationType("DeleteGroupLink").count());
        OperationLogQueryTest.assertEquals((long)1L, (long)this.query().operationType("AddAttachment").count());
        OperationLogQueryTest.assertEquals((long)1L, (long)this.query().operationType("DeleteAttachment").count());
        OperationLogQueryTest.assertEquals((long)11L, (long)this.query().processDefinitionId(this.process.getProcessDefinitionId()).count());
        OperationLogQueryTest.assertEquals((long)11L, (long)this.query().processInstanceId(this.process.getId()).count());
        OperationLogQueryTest.assertEquals((long)11L, (long)this.query().executionId(this.execution.getId()).count());
        OperationLogQueryTest.assertEquals((long)11L, (long)this.query().taskId(this.processTaskId).count());
        OperationLogQueryTest.assertEquals((long)6L, (long)this.query().taskId(this.userTask.getId()).count());
        OperationLogQueryTest.assertEquals((long)11L, (long)this.query().userId("icke").count());
        OperationLogQueryTest.assertEquals((long)6L, (long)this.query().userId("er").count());
        UserOperationLogQuery updates = this.query().operationType("Update");
        String updateOperationId = ((UserOperationLogEntry)updates.list().get(0)).getOperationId();
        OperationLogQueryTest.assertEquals((long)updates.count(), (long)this.query().operationId(updateOperationId).count());
        OperationLogQueryTest.assertEquals((long)3L, (long)this.query().property("assignee").count());
        OperationLogQueryTest.assertEquals((long)2L, (long)this.query().property("owner").count());
        List ascLog = ((UserOperationLogQuery)this.query().orderByTimestamp().asc()).list();
        for (i2 = 0; i2 < 4; ++i2) {
            OperationLogQueryTest.assertTrue((this.yesterday.getTime() <= ((UserOperationLogEntry)ascLog.get(i2)).getTimestamp().getTime() ? 1 : 0) != 0);
        }
        for (i2 = 4; i2 < 12; ++i2) {
            OperationLogQueryTest.assertTrue((this.today.getTime() <= ((UserOperationLogEntry)ascLog.get(i2)).getTimestamp().getTime() ? 1 : 0) != 0);
        }
        for (i2 = 12; i2 < 16; ++i2) {
            OperationLogQueryTest.assertTrue((this.tomorrow.getTime() <= ((UserOperationLogEntry)ascLog.get(i2)).getTimestamp().getTime() ? 1 : 0) != 0);
        }
        List descLog = ((UserOperationLogQuery)this.query().orderByTimestamp().desc()).list();
        for (i = 0; i < 4; ++i) {
            OperationLogQueryTest.assertTrue((this.tomorrow.getTime() <= ((UserOperationLogEntry)descLog.get(i)).getTimestamp().getTime() ? 1 : 0) != 0);
        }
        for (i = 4; i < 11; ++i) {
            OperationLogQueryTest.assertTrue((this.today.getTime() <= ((UserOperationLogEntry)descLog.get(i)).getTimestamp().getTime() ? 1 : 0) != 0);
        }
        for (i = 11; i < 15; ++i) {
            OperationLogQueryTest.assertTrue((this.yesterday.getTime() <= ((UserOperationLogEntry)descLog.get(i)).getTimestamp().getTime() ? 1 : 0) != 0);
        }
        OperationLogQueryTest.assertEquals((long)4L, (long)this.query().beforeTimestamp(this.today).count());
        OperationLogQueryTest.assertEquals((long)12L, (long)this.query().beforeTimestamp(this.tomorrow).count());
        OperationLogQueryTest.assertEquals((long)13L, (long)this.query().afterTimestamp(this.yesterday).count());
        OperationLogQueryTest.assertEquals((long)5L, (long)this.query().afterTimestamp(this.today).count());
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getHistoricTaskInstanceManager().deleteHistoricTaskInstanceById(OperationLogQueryTest.this.userTask.getId());
                return null;
            }
        });
    }

    private UserOperationLogQuery query() {
        return this.historyService.createUserOperationLogQuery();
    }

    private void createLogEntries() {
        ClockUtil.setCurrentTime((Date)this.yesterday);
        this.process = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.execution = (Execution)this.processEngine.getRuntimeService().createExecutionQuery().processInstanceId(this.process.getId()).singleResult();
        this.processTaskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId("icke");
        this.taskService.addCandidateUser(this.processTaskId, "er");
        this.taskService.deleteCandidateUser(this.processTaskId, "er");
        this.taskService.addCandidateGroup(this.processTaskId, "wir");
        this.taskService.deleteCandidateGroup(this.processTaskId, "wir");
        ClockUtil.setCurrentTime((Date)this.today);
        this.taskService.setOwner(this.processTaskId, "icke");
        this.taskService.claim(this.processTaskId, "icke");
        this.taskService.setAssignee(this.processTaskId, "er");
        this.taskService.setPriority(this.processTaskId, 10);
        Attachment attachment = this.taskService.createAttachment("image/ico", this.processTaskId, this.process.getId(), "favicon.ico", "favicon", "http://camunda.com/favicon.ico");
        this.taskService.deleteAttachment(attachment.getId());
        this.taskService.complete(this.processTaskId);
        this.assertProcessEnded(this.process.getId());
        this.identityService.setAuthenticatedUserId("er");
        this.userTask = this.taskService.newTask();
        this.userTask.setName("to do");
        this.taskService.saveTask(this.userTask);
        ClockUtil.setCurrentTime((Date)this.tomorrow);
        this.userTask.setDescription("desc");
        this.userTask.setOwner("icke");
        this.userTask.setAssignee("er");
        this.userTask.setDueDate(new Date());
        this.taskService.saveTask(this.userTask);
        this.taskService.complete(this.userTask.getId());
    }
}

