/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.history.UserOperationLogQuery;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.task.DelegationState;
import org.camunda.bpm.engine.task.Task;

public class OperationLogTaskServiceAndBeanTest
extends PluggableProcessEngineTestCase {
    private Task task;

    public void testBeanPropertyChanges() {
        TaskEntity entity = new TaskEntity();
        entity.setAssignee("icke");
        Map changes = entity.getPropertyChanges();
        OperationLogTaskServiceAndBeanTest.assertEquals((int)1, (int)changes.size());
        OperationLogTaskServiceAndBeanTest.assertNull((Object)((PropertyChange)changes.get("assignee")).getOrgValue());
        OperationLogTaskServiceAndBeanTest.assertEquals((Object)"icke", (Object)((PropertyChange)changes.get("assignee")).getNewValue());
        entity.setAssignee("er");
        changes = entity.getPropertyChanges();
        OperationLogTaskServiceAndBeanTest.assertEquals((int)1, (int)changes.size());
        OperationLogTaskServiceAndBeanTest.assertNull((Object)((PropertyChange)changes.get("assignee")).getOrgValue());
        OperationLogTaskServiceAndBeanTest.assertEquals((Object)"er", (Object)((PropertyChange)changes.get("assignee")).getNewValue());
        entity.setDueDate(new Date());
        changes = entity.getPropertyChanges();
        OperationLogTaskServiceAndBeanTest.assertEquals((int)2, (int)changes.size());
    }

    public void testNotTrackChangeToTheSameValue() {
        TaskEntity entity = new TaskEntity();
        entity.setPriority(entity.getPriority());
        entity.setOwner(entity.getOwner());
        entity.setFollowUpDate(entity.getFollowUpDate());
        OperationLogTaskServiceAndBeanTest.assertTrue((boolean)entity.getPropertyChanges().isEmpty());
    }

    public void testRemoveChangeWhenSetBackToTheOrgValue() {
        TaskEntity entity = new TaskEntity();
        entity.setOwner("icke");
        OperationLogTaskServiceAndBeanTest.assertFalse((boolean)entity.getPropertyChanges().isEmpty());
        entity.setOwner(null);
        OperationLogTaskServiceAndBeanTest.assertTrue((boolean)entity.getPropertyChanges().isEmpty());
    }

    public void testAllTrackedProperties() {
        Date yesterday = new Date(new Date().getTime() - 86400000L);
        Date tomorrow = new Date(new Date().getTime() + 86400000L);
        TaskEntity entity = new TaskEntity();
        entity.setAssignee("er");
        entity.setDelegationState(DelegationState.PENDING);
        entity.setDeleted(true);
        entity.setDescription("a description");
        entity.setDueDate(tomorrow);
        entity.setFollowUpDate(yesterday);
        entity.setName("to do");
        entity.setOwner("icke");
        entity.setParentTaskId("parent");
        entity.setPriority(73);
        Map changes = entity.getPropertyChanges();
        OperationLogTaskServiceAndBeanTest.assertEquals((Object)"er", (Object)((PropertyChange)changes.get("assignee")).getNewValue());
        OperationLogTaskServiceAndBeanTest.assertSame((Object)DelegationState.PENDING, (Object)((PropertyChange)changes.get("delegation")).getNewValue());
        OperationLogTaskServiceAndBeanTest.assertTrue((boolean)((Boolean)((PropertyChange)changes.get("delete")).getNewValue()));
        OperationLogTaskServiceAndBeanTest.assertEquals((Object)"a description", (Object)((PropertyChange)changes.get("description")).getNewValue());
        OperationLogTaskServiceAndBeanTest.assertEquals((Object)tomorrow, (Object)((PropertyChange)changes.get("dueDate")).getNewValue());
        OperationLogTaskServiceAndBeanTest.assertEquals((Object)yesterday, (Object)((PropertyChange)changes.get("followUpDate")).getNewValue());
        OperationLogTaskServiceAndBeanTest.assertEquals((Object)"to do", (Object)((PropertyChange)changes.get("name")).getNewValue());
        OperationLogTaskServiceAndBeanTest.assertEquals((Object)"icke", (Object)((PropertyChange)changes.get("owner")).getNewValue());
        OperationLogTaskServiceAndBeanTest.assertEquals((Object)"parent", (Object)((PropertyChange)changes.get("parentTask")).getNewValue());
        OperationLogTaskServiceAndBeanTest.assertEquals((Object)73, (Object)((PropertyChange)changes.get("priority")).getNewValue());
    }

    public void testDeleteTask() {
        this.task = this.taskService.newTask();
        this.taskService.saveTask(this.task);
        this.taskService.deleteTask(this.task.getId(), "duplicated");
        UserOperationLogQuery query = this.queryOperationDetails("Delete");
        OperationLogTaskServiceAndBeanTest.assertEquals((long)1L, (long)query.count());
        UserOperationLogEntry delete = (UserOperationLogEntry)query.singleResult();
        OperationLogTaskServiceAndBeanTest.assertEquals((String)"delete", (String)delete.getProperty());
        OperationLogTaskServiceAndBeanTest.assertFalse((boolean)Boolean.parseBoolean(delete.getOrgValue()));
        OperationLogTaskServiceAndBeanTest.assertTrue((boolean)Boolean.parseBoolean(delete.getNewValue()));
        this.cleanupHistory();
    }

    public void testCompositeBeanInteraction() {
        this.task = this.taskService.newTask();
        this.taskService.saveTask(this.task);
        UserOperationLogQuery query = this.queryOperationDetails("Create");
        UserOperationLogEntry create = (UserOperationLogEntry)query.singleResult();
        OperationLogTaskServiceAndBeanTest.assertNotNull((Object)create);
        OperationLogTaskServiceAndBeanTest.assertEquals((String)"Task", (String)create.getEntityType());
        OperationLogTaskServiceAndBeanTest.assertNull((Object)create.getOrgValue());
        OperationLogTaskServiceAndBeanTest.assertNull((Object)create.getNewValue());
        OperationLogTaskServiceAndBeanTest.assertNull((Object)create.getProperty());
        this.task.setAssignee("icke");
        this.task.setName("to do");
        this.taskService.saveTask(this.task);
        List entries = this.queryOperationDetails("Update").list();
        OperationLogTaskServiceAndBeanTest.assertEquals((int)2, (int)entries.size());
        OperationLogTaskServiceAndBeanTest.assertEquals((String)((UserOperationLogEntry)entries.get(0)).getOperationId(), (String)((UserOperationLogEntry)entries.get(1)).getOperationId());
        this.taskService.deleteTask(this.task.getId());
        this.cleanupHistory();
    }

    public void testMultipleValueChange() {
        this.task = this.taskService.newTask();
        this.taskService.saveTask(this.task);
        this.task.setName("a task");
        this.task.setName("to do");
        this.taskService.saveTask(this.task);
        UserOperationLogEntry update = (UserOperationLogEntry)this.queryOperationDetails("Update").singleResult();
        OperationLogTaskServiceAndBeanTest.assertNull((Object)update.getOrgValue());
        OperationLogTaskServiceAndBeanTest.assertEquals((String)"to do", (String)update.getNewValue());
        this.taskService.deleteTask(this.task.getId());
        this.cleanupHistory();
    }

    public void testSetDateProperty() {
        this.task = this.taskService.newTask();
        Date now = ClockUtil.getCurrentTime();
        this.task.setDueDate(now);
        this.taskService.saveTask(this.task);
        UserOperationLogEntry logEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        OperationLogTaskServiceAndBeanTest.assertEquals((String)String.valueOf(now.getTime()), (String)logEntry.getNewValue());
        this.taskService.deleteTask(this.task.getId());
        this.cleanupHistory();
    }

    public void testResetChange() {
        this.task = this.taskService.newTask();
        this.taskService.saveTask(this.task);
        String name = "a task";
        this.task.setName(name);
        this.taskService.saveTask(this.task);
        UserOperationLogEntry update = (UserOperationLogEntry)this.queryOperationDetails("Update").singleResult();
        OperationLogTaskServiceAndBeanTest.assertNull((Object)update.getOrgValue());
        OperationLogTaskServiceAndBeanTest.assertEquals((String)name, (String)update.getNewValue());
        this.task.setName("to do 1");
        this.task.setName("to do 2");
        this.task.setName(name);
        this.taskService.saveTask(this.task);
        update = (UserOperationLogEntry)this.queryOperationDetails("Update").singleResult();
        OperationLogTaskServiceAndBeanTest.assertNull((Object)update.getOrgValue());
        OperationLogTaskServiceAndBeanTest.assertEquals((String)name, (String)update.getNewValue());
        this.taskService.deleteTask(this.task.getId());
        this.cleanupHistory();
    }

    public void testConcurrentTaskChange() {
        this.task = this.taskService.newTask();
        this.taskService.saveTask(this.task);
        this.task.setAssignee("icke");
        this.taskService.setAssignee(this.task.getId(), "er");
        try {
            this.taskService.saveTask(this.task);
        }
        catch (Exception e) {
            OperationLogTaskServiceAndBeanTest.assertNotNull((Object)e);
        }
        this.taskService.deleteTask(this.task.getId());
        this.cleanupHistory();
    }

    private UserOperationLogQuery queryOperationDetails(String type) {
        return this.historyService.createUserOperationLogQuery().operationType(type);
    }

    private void cleanupHistory() {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getHistoricTaskInstanceManager().deleteHistoricTaskInstanceById(OperationLogTaskServiceAndBeanTest.this.task.getId());
                return null;
            }
        });
    }
}

