/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.io.FileNotFoundException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.cmd.AcquireJobsCmd;
import org.camunda.bpm.engine.impl.cmd.DeleteJobsCmd;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.AcquiredJobs;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;
import org.camunda.bpm.engine.impl.test.AbstractProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.Deployment;
import org.junit.Assert;

public class DeploymentAwareJobExecutorTest
extends AbstractProcessEngineTestCase {
    protected void initializeProcessEngine() {
        try {
            this.processEngine = ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"camunda.cfg.xml").setJobExecutorDeploymentAware(true).buildProcessEngine();
        }
        catch (RuntimeException ex) {
            if (ex.getCause() != null && ex.getCause() instanceof FileNotFoundException) {
                this.processEngine = ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"activiti.cfg.xml").buildProcessEngine();
            }
            throw ex;
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/simpleAsyncProcess.bpmn20.xml"})
    public void testProcessingOfJobsWithMatchingDeployment() {
        this.runtimeService.startProcessInstanceByKey("simpleAsyncProcess");
        Set registeredDeployments = this.managementService.getRegisteredDeployments();
        Assert.assertEquals((long)1L, (long)registeredDeployments.size());
        Assert.assertTrue((boolean)registeredDeployments.contains(this.deploymentId));
        Job executableJob = (Job)this.managementService.createJobQuery().singleResult();
        String otherDeploymentId = this.deployAndInstantiateWithNewEngineConfiguration("org/camunda/bpm/engine/test/jobexecutor/simpleAsyncProcessVersion2.bpmn20.xml");
        List jobs = this.managementService.createJobQuery().list();
        Assert.assertEquals((long)2L, (long)jobs.size());
        HashSet<String> jobDeploymentIds = new HashSet<String>();
        jobDeploymentIds.add(((Job)jobs.get(0)).getDeploymentId());
        jobDeploymentIds.add(((Job)jobs.get(1)).getDeploymentId());
        Assert.assertTrue((boolean)jobDeploymentIds.contains(this.deploymentId));
        Assert.assertTrue((boolean)jobDeploymentIds.contains(otherDeploymentId));
        AcquiredJobs acquiredJobs = this.getExecutableJobs(this.processEngineConfiguration.getJobExecutor());
        Assert.assertEquals((long)1L, (long)acquiredJobs.size());
        Assert.assertTrue((boolean)acquiredJobs.contains(executableJob.getId()));
        this.repositoryService.deleteDeployment(otherDeploymentId, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/simpleAsyncProcess.bpmn20.xml"})
    public void testExplicitDeploymentRegistration() {
        this.runtimeService.startProcessInstanceByKey("simpleAsyncProcess");
        String otherDeploymentId = this.deployAndInstantiateWithNewEngineConfiguration("org/camunda/bpm/engine/test/jobexecutor/simpleAsyncProcessVersion2.bpmn20.xml");
        this.processEngine.getManagementService().registerDeploymentForJobExecutor(otherDeploymentId);
        List jobs = this.managementService.createJobQuery().list();
        AcquiredJobs acquiredJobs = this.getExecutableJobs(this.processEngineConfiguration.getJobExecutor());
        Assert.assertEquals((long)2L, (long)acquiredJobs.size());
        for (Job job : jobs) {
            Assert.assertTrue((boolean)acquiredJobs.contains(job.getId()));
        }
        this.repositoryService.deleteDeployment(otherDeploymentId, true);
    }

    public void testRegistrationOfNonExistingDeployment() {
        String nonExistingDeploymentId = "some non-existing id";
        try {
            this.processEngine.getManagementService().registerDeploymentForJobExecutor(nonExistingDeploymentId);
            Assert.fail((String)"Registering a non-existing deployment should not succeed");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Deployment " + nonExistingDeploymentId + " does not exist", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/simpleAsyncProcess.bpmn20.xml"})
    public void testDeploymentUnregistrationOnUndeployment() {
        Assert.assertEquals((long)1L, (long)this.managementService.getRegisteredDeployments().size());
        this.repositoryService.deleteDeployment(this.deploymentId, true);
        Assert.assertEquals((long)0L, (long)this.managementService.getRegisteredDeployments().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/simpleAsyncProcess.bpmn20.xml"})
    public void testNoUnregistrationOnFailingUndeployment() {
        this.runtimeService.startProcessInstanceByKey("simpleAsyncProcess");
        try {
            this.repositoryService.deleteDeployment(this.deploymentId, false);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((long)1L, (long)this.managementService.getRegisteredDeployments().size());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/simpleAsyncProcess.bpmn20.xml"})
    public void testExplicitDeploymentUnregistration() {
        this.runtimeService.startProcessInstanceByKey("simpleAsyncProcess");
        this.processEngine.getManagementService().unregisterDeploymentForJobExecutor(this.deploymentId);
        AcquiredJobs acquiredJobs = this.getExecutableJobs(this.processEngineConfiguration.getJobExecutor());
        Assert.assertEquals((long)0L, (long)acquiredJobs.size());
    }

    public void testJobsWithoutDeploymentIdAreAlwaysProcessed() {
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        String messageId = (String)commandExecutor.execute((Command)new Command<String>(){

            public String execute(CommandContext commandContext) {
                MessageEntity message = new MessageEntity();
                commandContext.getJobManager().send(message);
                return message.getId();
            }
        });
        AcquiredJobs acquiredJobs = this.getExecutableJobs(this.processEngineConfiguration.getJobExecutor());
        Assert.assertEquals((long)1L, (long)acquiredJobs.size());
        Assert.assertTrue((boolean)acquiredJobs.contains(messageId));
        commandExecutor.execute((Command)new DeleteJobsCmd(messageId));
    }

    private AcquiredJobs getExecutableJobs(JobExecutor jobExecutor) {
        return (AcquiredJobs)this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new AcquireJobsCmd(jobExecutor));
    }

    private String deployAndInstantiateWithNewEngineConfiguration(String resource) {
        ProcessEngineConfiguration otherProcessEngineConfiguration = null;
        try {
            otherProcessEngineConfiguration = ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"camunda.cfg.xml").setJobExecutorDeploymentAware(true);
        }
        catch (RuntimeException ex) {
            if (ex.getCause() != null && ex.getCause() instanceof FileNotFoundException) {
                otherProcessEngineConfiguration = ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"activiti.cfg.xml").setJobExecutorDeploymentAware(true);
            }
            throw ex;
        }
        ProcessEngine otherEngine = otherProcessEngineConfiguration.buildProcessEngine();
        RepositoryService otherRepositoryService = otherEngine.getRepositoryService();
        String deploymentId = otherRepositoryService.createDeployment().addClasspathResource(resource).deploy().getId();
        ProcessDefinition newDefinition = (ProcessDefinition)otherRepositoryService.createProcessDefinitionQuery().deploymentId(deploymentId).singleResult();
        otherEngine.getRuntimeService().startProcessInstanceById(newDefinition.getId());
        return deploymentId;
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/processWithTimerCatch.bpmn20.xml"})
    public void testIntermediateTimerEvent() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Set registeredDeployments = this.processEngineConfiguration.getRegisteredDeployments();
        Job existingJob = (Job)this.managementService.createJobQuery().singleResult();
        ClockUtil.setCurrentTime((Date)new Date(System.currentTimeMillis() + 1000L));
        List<JobEntity> acquirableJobs = this.findAcquirableJobs();
        DeploymentAwareJobExecutorTest.assertEquals((int)1, (int)acquirableJobs.size());
        DeploymentAwareJobExecutorTest.assertEquals((String)existingJob.getId(), (String)acquirableJobs.get(0).getId());
        registeredDeployments.clear();
        acquirableJobs = this.findAcquirableJobs();
        DeploymentAwareJobExecutorTest.assertEquals((int)0, (int)acquirableJobs.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/processWithTimerStart.bpmn20.xml"})
    public void testTimerStartEvent() {
        Set registeredDeployments = this.processEngineConfiguration.getRegisteredDeployments();
        Job existingJob = (Job)this.managementService.createJobQuery().singleResult();
        ClockUtil.setCurrentTime((Date)new Date(System.currentTimeMillis() + 1000L));
        List<JobEntity> acquirableJobs = this.findAcquirableJobs();
        DeploymentAwareJobExecutorTest.assertEquals((int)1, (int)acquirableJobs.size());
        DeploymentAwareJobExecutorTest.assertEquals((String)existingJob.getId(), (String)acquirableJobs.get(0).getId());
        registeredDeployments.clear();
        acquirableJobs = this.findAcquirableJobs();
        DeploymentAwareJobExecutorTest.assertEquals((int)0, (int)acquirableJobs.size());
    }

    protected List<JobEntity> findAcquirableJobs() {
        return (List)this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<List<JobEntity>>(){

            public List<JobEntity> execute(CommandContext commandContext) {
                return commandContext.getJobManager().findNextJobsToExecute(new Page(0, 100));
            }
        });
    }
}

