/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.pvm;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.impl.pvm.ProcessDefinitionBuilder;
import org.camunda.bpm.engine.impl.pvm.PvmExecution;
import org.camunda.bpm.engine.impl.pvm.PvmProcessDefinition;
import org.camunda.bpm.engine.impl.pvm.PvmProcessInstance;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.camunda.bpm.engine.impl.test.PvmTestCase;
import org.camunda.bpm.engine.test.pvm.EventCollector;
import org.camunda.bpm.engine.test.pvm.activities.Automatic;
import org.camunda.bpm.engine.test.pvm.activities.End;
import org.camunda.bpm.engine.test.pvm.activities.ParallelGateway;
import org.camunda.bpm.engine.test.pvm.activities.WaitState;

public class PvmScopesAndConcurrencyTest
extends PvmTestCase {
    public void testConcurrentPathsComingOutOfScope() {
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder().createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).transition("fork").endActivity().createActivity("scope").scope().createActivity("fork").behavior((ActivityBehavior)new ParallelGateway()).transition("c1").transition("c2").transition("c3").endActivity().endActivity().createActivity("c1").behavior((ActivityBehavior)new WaitState()).endActivity().createActivity("c2").behavior((ActivityBehavior)new WaitState()).endActivity().createActivity("c3").behavior((ActivityBehavior)new WaitState()).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        List activeActivityIds = processInstance.findActiveActivityIds();
        ArrayList<String> expectedActiveActivityIds = new ArrayList<String>();
        expectedActiveActivityIds.add("c3");
        expectedActiveActivityIds.add("c1");
        expectedActiveActivityIds.add("c2");
        PvmScopesAndConcurrencyTest.assertEquals(expectedActiveActivityIds, (Object)activeActivityIds);
    }

    public void testConcurrentPathsGoingIntoScope() {
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder().createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).transition("parallel").endActivity().createActivity("parallel").behavior((ActivityBehavior)new ParallelGateway()).transition("inside").transition("inside").transition("inside").endActivity().createActivity("scope").scope().createActivity("inside").behavior((ActivityBehavior)new WaitState()).endActivity().endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        List activeActivityIds = processInstance.findActiveActivityIds();
        ArrayList<String> expectedActiveActivityIds = new ArrayList<String>();
        expectedActiveActivityIds.add("inside");
        expectedActiveActivityIds.add("inside");
        expectedActiveActivityIds.add("inside");
        PvmScopesAndConcurrencyTest.assertEquals(expectedActiveActivityIds, (Object)activeActivityIds);
    }

    public void testConcurrentPathsThroughNonScopeNestedActivity() {
        EventCollector eventCollector = new EventCollector();
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder("scopes and concurrency").executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).transition("fork").endActivity().createActivity("fork").behavior((ActivityBehavior)new ParallelGateway()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).transition("c1").transition("c2").endActivity().createActivity("noscope").executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).createActivity("c1").behavior((ActivityBehavior)new WaitState()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).transition("join").endActivity().createActivity("c2").behavior((ActivityBehavior)new WaitState()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).transition("join").endActivity().endActivity().createActivity("join").behavior((ActivityBehavior)new ParallelGateway()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).transition("end").endActivity().createActivity("end").behavior((ActivityBehavior)new End()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        ArrayList<String> expectedEvents = new ArrayList<String>();
        expectedEvents.add("start on ProcessDefinition(scopes and concurrency)");
        expectedEvents.add("start on Activity(start)");
        expectedEvents.add("end on Activity(start)");
        expectedEvents.add("start on Activity(fork)");
        expectedEvents.add("end on Activity(fork)");
        expectedEvents.add("start on Activity(noscope)");
        expectedEvents.add("start on Activity(c1)");
        expectedEvents.add("end on Activity(fork)");
        expectedEvents.add("start on Activity(noscope)");
        expectedEvents.add("start on Activity(c2)");
        PvmScopesAndConcurrencyTest.assertEquals((String)("expected " + expectedEvents + ", but was \n" + eventCollector + "\n"), expectedEvents, eventCollector.events);
        eventCollector.events.clear();
        PvmExecution execution = processInstance.findExecution("c1");
        execution.signal(null, null);
        expectedEvents = new ArrayList();
        expectedEvents.add("end on Activity(c1)");
        expectedEvents.add("end on Activity(noscope)");
        expectedEvents.add("start on Activity(join)");
        PvmScopesAndConcurrencyTest.assertEquals((String)("expected " + expectedEvents + ", but was \n" + eventCollector + "\n"), expectedEvents, eventCollector.events);
        eventCollector.events.clear();
        execution = processInstance.findExecution("c2");
        execution.signal(null, null);
        expectedEvents = new ArrayList();
        expectedEvents.add("end on Activity(c2)");
        expectedEvents.add("end on Activity(noscope)");
        expectedEvents.add("start on Activity(join)");
        expectedEvents.add("end on Activity(join)");
        expectedEvents.add("end on Activity(join)");
        expectedEvents.add("start on Activity(end)");
        expectedEvents.add("end on Activity(end)");
        expectedEvents.add("end on ProcessDefinition(scopes and concurrency)");
        PvmScopesAndConcurrencyTest.assertEquals((String)("expected " + expectedEvents + ", but was \n" + eventCollector + "\n"), expectedEvents, eventCollector.events);
        eventCollector.events.clear();
        PvmScopesAndConcurrencyTest.assertTrue((boolean)processInstance.isEnded());
    }

    public void testConcurrentPathsThroughScope() {
        EventCollector eventCollector = new EventCollector();
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder("scopes and concurrency").executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).transition("fork").endActivity().createActivity("fork").behavior((ActivityBehavior)new ParallelGateway()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).transition("c1").transition("c2").endActivity().createActivity("scope").scope().executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).createActivity("c1").behavior((ActivityBehavior)new WaitState()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).transition("join").endActivity().createActivity("c2").behavior((ActivityBehavior)new WaitState()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).transition("join").endActivity().endActivity().createActivity("join").behavior((ActivityBehavior)new ParallelGateway()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).transition("end").endActivity().createActivity("end").behavior((ActivityBehavior)new End()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        ArrayList<String> expectedEvents = new ArrayList<String>();
        expectedEvents.add("start on ProcessDefinition(scopes and concurrency)");
        expectedEvents.add("start on Activity(start)");
        expectedEvents.add("end on Activity(start)");
        expectedEvents.add("start on Activity(fork)");
        expectedEvents.add("end on Activity(fork)");
        expectedEvents.add("start on Activity(scope)");
        expectedEvents.add("start on Activity(c1)");
        expectedEvents.add("end on Activity(fork)");
        expectedEvents.add("start on Activity(scope)");
        expectedEvents.add("start on Activity(c2)");
        PvmScopesAndConcurrencyTest.assertEquals((String)("expected " + expectedEvents + ", but was \n" + eventCollector + "\n"), expectedEvents, eventCollector.events);
        eventCollector.events.clear();
        PvmExecution execution = processInstance.findExecution("c1");
        execution.signal(null, null);
        expectedEvents = new ArrayList();
        expectedEvents.add("end on Activity(c1)");
        expectedEvents.add("end on Activity(scope)");
        expectedEvents.add("start on Activity(join)");
        PvmScopesAndConcurrencyTest.assertEquals((String)("expected " + expectedEvents + ", but was \n" + eventCollector + "\n"), expectedEvents, eventCollector.events);
        eventCollector.events.clear();
        execution = processInstance.findExecution("c2");
        execution.signal(null, null);
        expectedEvents = new ArrayList();
        expectedEvents.add("end on Activity(c2)");
        expectedEvents.add("end on Activity(scope)");
        expectedEvents.add("start on Activity(join)");
        expectedEvents.add("end on Activity(join)");
        expectedEvents.add("end on Activity(join)");
        expectedEvents.add("start on Activity(end)");
        expectedEvents.add("end on Activity(end)");
        expectedEvents.add("end on ProcessDefinition(scopes and concurrency)");
        PvmScopesAndConcurrencyTest.assertEquals((String)("expected " + expectedEvents + ", but was \n" + eventCollector + "\n"), expectedEvents, eventCollector.events);
        eventCollector.events.clear();
        PvmScopesAndConcurrencyTest.assertTrue((boolean)processInstance.isEnded());
    }

    public void testConcurrentPathsGoingOutOfScope() {
        EventCollector eventCollector = new EventCollector();
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder("scopes and concurrency").executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).transition("fork").endActivity().createActivity("scope").scope().createActivity("fork").behavior((ActivityBehavior)new ParallelGateway()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).transition("c1").transition("c2").endActivity().executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).createActivity("c1").behavior((ActivityBehavior)new WaitState()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).transition("join").endActivity().createActivity("c2").behavior((ActivityBehavior)new WaitState()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).transition("join").endActivity().endActivity().createActivity("join").behavior((ActivityBehavior)new ParallelGateway()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).transition("end").endActivity().createActivity("end").behavior((ActivityBehavior)new End()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        ArrayList<String> expectedEvents = new ArrayList<String>();
        expectedEvents.add("start on ProcessDefinition(scopes and concurrency)");
        expectedEvents.add("start on Activity(start)");
        expectedEvents.add("end on Activity(start)");
        expectedEvents.add("start on Activity(scope)");
        expectedEvents.add("start on Activity(fork)");
        expectedEvents.add("end on Activity(fork)");
        expectedEvents.add("start on Activity(c1)");
        expectedEvents.add("end on Activity(fork)");
        expectedEvents.add("start on Activity(c2)");
        PvmScopesAndConcurrencyTest.assertEquals((String)("expected " + expectedEvents + ", but was \n" + eventCollector + "\n"), expectedEvents, eventCollector.events);
        eventCollector.events.clear();
        PvmExecution execution = processInstance.findExecution("c1");
        execution.signal(null, null);
        expectedEvents = new ArrayList();
        expectedEvents.add("end on Activity(c1)");
        expectedEvents.add("end on Activity(scope)");
        expectedEvents.add("start on Activity(join)");
        PvmScopesAndConcurrencyTest.assertEquals((String)("expected " + expectedEvents + ", but was \n" + eventCollector + "\n"), expectedEvents, eventCollector.events);
        eventCollector.events.clear();
        execution = processInstance.findExecution("c2");
        execution.signal(null, null);
        expectedEvents = new ArrayList();
        expectedEvents.add("end on Activity(c2)");
        expectedEvents.add("end on Activity(scope)");
        expectedEvents.add("start on Activity(join)");
        expectedEvents.add("end on Activity(join)");
        expectedEvents.add("end on Activity(join)");
        expectedEvents.add("start on Activity(end)");
        expectedEvents.add("end on Activity(end)");
        expectedEvents.add("end on ProcessDefinition(scopes and concurrency)");
        PvmScopesAndConcurrencyTest.assertEquals((String)("expected " + expectedEvents + ", but was \n" + eventCollector + "\n"), expectedEvents, eventCollector.events);
        eventCollector.events.clear();
        PvmScopesAndConcurrencyTest.assertTrue((boolean)processInstance.isEnded());
    }

    public void testConcurrentPathsJoiningInsideScope() {
        EventCollector eventCollector = new EventCollector();
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder("scopes and concurrency").executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).transition("fork").endActivity().createActivity("fork").behavior((ActivityBehavior)new ParallelGateway()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).transition("c1").transition("c2").endActivity().createActivity("scope").scope().executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).createActivity("c1").behavior((ActivityBehavior)new WaitState()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).transition("join").endActivity().createActivity("c2").behavior((ActivityBehavior)new WaitState()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).transition("join").endActivity().createActivity("join").behavior((ActivityBehavior)new ParallelGateway()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).transition("end").endActivity().endActivity().createActivity("end").behavior((ActivityBehavior)new End()).executionListener("start", (ExecutionListener)eventCollector).executionListener("end", (ExecutionListener)eventCollector).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        ArrayList<String> expectedEvents = new ArrayList<String>();
        expectedEvents.add("start on ProcessDefinition(scopes and concurrency)");
        expectedEvents.add("start on Activity(start)");
        expectedEvents.add("end on Activity(start)");
        expectedEvents.add("start on Activity(fork)");
        expectedEvents.add("end on Activity(fork)");
        expectedEvents.add("start on Activity(scope)");
        expectedEvents.add("start on Activity(c1)");
        expectedEvents.add("end on Activity(fork)");
        expectedEvents.add("start on Activity(scope)");
        expectedEvents.add("start on Activity(c2)");
        PvmScopesAndConcurrencyTest.assertEquals((String)("expected " + expectedEvents + ", but was \n" + eventCollector + "\n"), expectedEvents, eventCollector.events);
        eventCollector.events.clear();
        PvmExecution execution = processInstance.findExecution("c1");
        execution.signal(null, null);
        expectedEvents = new ArrayList();
        expectedEvents.add("end on Activity(c1)");
        expectedEvents.add("start on Activity(join)");
        PvmScopesAndConcurrencyTest.assertEquals((String)("expected " + expectedEvents + ", but was \n" + eventCollector + "\n"), expectedEvents, eventCollector.events);
        eventCollector.events.clear();
        execution = processInstance.findExecution("c2");
        execution.signal(null, null);
    }
}

