/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.pvm.activities;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;

public class ParallelGateway
implements ActivityBehavior {
    private static Logger log = Logger.getLogger(ParallelGateway.class.getName());

    public void execute(ActivityExecution execution) {
        PvmActivity activity = execution.getActivity();
        List outgoingTransitions = execution.getActivity().getOutgoingTransitions();
        execution.inactivate();
        List joinedExecutions = execution.findInactiveConcurrentExecutions(activity);
        int nbrOfExecutionsToJoin = execution.getActivity().getIncomingTransitions().size();
        int nbrOfExecutionsJoined = joinedExecutions.size();
        if (nbrOfExecutionsJoined == nbrOfExecutionsToJoin) {
            log.fine("parallel gateway '" + activity.getId() + "' activates: " + nbrOfExecutionsJoined + " of " + nbrOfExecutionsToJoin + " joined");
            execution.takeAll(outgoingTransitions, joinedExecutions);
        } else if (log.isLoggable(Level.FINE)) {
            log.fine("parallel gateway '" + activity.getId() + "' does not activate: " + nbrOfExecutionsJoined + " of " + nbrOfExecutionsToJoin + " joined");
        }
    }
}

