/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.jmx.deployment.scanning;

import java.net.URL;
import java.util.Map;
import org.camunda.bpm.container.impl.jmx.deployment.scanning.ClassPathProcessApplicationScanner;
import org.camunda.bpm.container.impl.jmx.deployment.scanning.VfsProcessApplicationScanner;
import org.camunda.bpm.container.impl.jmx.deployment.scanning.spi.ProcessApplicationScanner;
import org.camunda.bpm.engine.impl.bpmn.deployer.BpmnDeployer;
import org.camunda.bpm.engine.impl.cmmn.deployer.CmmnDeployer;

public class ProcessApplicationScanningUtil {
    public static Map<String, byte[]> findResources(ClassLoader classLoader, String paResourceRootPath, URL metaFileUrl) {
        ProcessApplicationScanner scanner = null;
        try {
            classLoader.loadClass("org.jboss.vfs.VFS");
            scanner = new VfsProcessApplicationScanner();
        }
        catch (Throwable t) {
            scanner = new ClassPathProcessApplicationScanner();
        }
        return scanner.findResources(classLoader, paResourceRootPath, metaFileUrl);
    }

    public static boolean isDeployable(String filename) {
        for (String bpmnResourceSuffix : BpmnDeployer.BPMN_RESOURCE_SUFFIXES) {
            if (!filename.endsWith(bpmnResourceSuffix)) continue;
            return true;
        }
        for (String cmmnResourceSuffix : CmmnDeployer.CMMN_RESOURCE_SUFFIXES) {
            if (!filename.endsWith(cmmnResourceSuffix)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDiagramForProcess(String diagramFileName, String processFileName) {
        for (String bpmnResourceSuffix : BpmnDeployer.BPMN_RESOURCE_SUFFIXES) {
            String processFilePrefix;
            if (!processFileName.endsWith(bpmnResourceSuffix) || !diagramFileName.startsWith(processFilePrefix = processFileName.substring(0, processFileName.length() - bpmnResourceSuffix.length()))) continue;
            for (String diagramResourceSuffix : BpmnDeployer.DIAGRAM_SUFFIXES) {
                if (!diagramFileName.endsWith(diagramResourceSuffix)) continue;
                return true;
            }
        }
        return false;
    }
}

