/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.behavior;

import java.util.List;
import java.util.concurrent.Callable;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.delegate.Expression;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.ServiceTaskJavaDelegateActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.helper.ClassDelegate;
import org.camunda.bpm.engine.impl.bpmn.helper.ErrorPropagation;
import org.camunda.bpm.engine.impl.bpmn.parser.FieldDeclaration;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.context.ProcessApplicationContextUtil;
import org.camunda.bpm.engine.impl.delegate.ActivityBehaviorInvocation;
import org.camunda.bpm.engine.impl.delegate.JavaDelegateInvocation;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.delegate.SignallableActivityBehavior;

public class ServiceTaskDelegateExpressionActivityBehavior
extends TaskActivityBehavior {
    protected Expression expression;
    private final List<FieldDeclaration> fieldDeclarations;

    public ServiceTaskDelegateExpressionActivityBehavior(Expression expression, List<FieldDeclaration> fieldDeclarations) {
        this.expression = expression;
        this.fieldDeclarations = fieldDeclarations;
    }

    @Override
    public void signal(final ActivityExecution execution, final String signalName, final Object signalData) throws Exception {
        ProcessApplicationReference targetProcessApplication = ProcessApplicationContextUtil.getTargetProcessApplication((ExecutionEntity)execution);
        if (!ProcessApplicationContextUtil.requiresContextSwitch(targetProcessApplication)) {
            Object delegate = this.expression.getValue(execution);
            ClassDelegate.applyFieldDeclaration(this.fieldDeclarations, delegate);
            ActivityBehavior activityBehaviorInstance = this.getActivityBehaviorInstance(execution, delegate);
            if (activityBehaviorInstance instanceof SignallableActivityBehavior) {
                ((SignallableActivityBehavior)activityBehaviorInstance).signal(execution, signalName, signalData);
            }
        } else {
            Context.executeWithinProcessApplication(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ServiceTaskDelegateExpressionActivityBehavior.this.signal(execution, signalName, signalData);
                    return null;
                }
            }, targetProcessApplication);
        }
    }

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        block6: {
            try {
                Object delegate = this.expression.getValue(execution);
                ClassDelegate.applyFieldDeclaration(this.fieldDeclarations, delegate);
                if (delegate instanceof ActivityBehavior) {
                    Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new ActivityBehaviorInvocation((ActivityBehavior)delegate, execution));
                    break block6;
                }
                if (delegate instanceof JavaDelegate) {
                    Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new JavaDelegateInvocation((JavaDelegate)delegate, execution));
                    this.leave(execution);
                    break block6;
                }
                throw new ProcessEngineException("Delegate expression " + this.expression + " did neither resolve to an implementation of " + ActivityBehavior.class + " nor " + JavaDelegate.class);
            }
            catch (Exception exc) {
                BpmnError error = null;
                for (Throwable cause = exc; cause != null; cause = cause.getCause()) {
                    if (!(cause instanceof BpmnError)) continue;
                    error = (BpmnError)cause;
                    break;
                }
                if (error != null) {
                    ErrorPropagation.propagateError(error, execution);
                }
                ErrorPropagation.propagateException(exc, execution);
            }
        }
    }

    protected ActivityBehavior getActivityBehaviorInstance(ActivityExecution execution, Object delegateInstance) {
        if (delegateInstance instanceof ActivityBehavior) {
            return this.determineBehaviour((ActivityBehavior)delegateInstance, execution);
        }
        if (delegateInstance instanceof JavaDelegate) {
            return this.determineBehaviour(new ServiceTaskJavaDelegateActivityBehavior((JavaDelegate)delegateInstance), execution);
        }
        throw new ProcessEngineException(delegateInstance.getClass().getName() + " doesn't implement " + JavaDelegate.class.getName() + " nor " + ActivityBehavior.class.getName());
    }

    protected ActivityBehavior determineBehaviour(ActivityBehavior delegateInstance, ActivityExecution execution) {
        if (this.hasMultiInstanceCharacteristics()) {
            this.multiInstanceActivityBehavior.setInnerActivityBehavior((AbstractBpmnActivityBehavior)delegateInstance);
            return this.multiInstanceActivityBehavior;
        }
        return delegateInstance;
    }
}

