/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.helper;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.Callable;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.ServiceTaskJavaDelegateActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.helper.ErrorPropagation;
import org.camunda.bpm.engine.impl.bpmn.parser.FieldDeclaration;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.context.ProcessApplicationContextUtil;
import org.camunda.bpm.engine.impl.delegate.ExecutionListenerInvocation;
import org.camunda.bpm.engine.impl.delegate.TaskListenerInvocation;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.delegate.SignallableActivityBehavior;
import org.camunda.bpm.engine.impl.util.ReflectUtil;

public class ClassDelegate
extends AbstractBpmnActivityBehavior
implements TaskListener,
ExecutionListener {
    protected String className;
    protected List<FieldDeclaration> fieldDeclarations;

    public ClassDelegate(String className, List<FieldDeclaration> fieldDeclarations) {
        this.className = className;
        this.fieldDeclarations = fieldDeclarations;
    }

    public ClassDelegate(Class<?> clazz, List<FieldDeclaration> fieldDeclarations) {
        this(clazz.getName(), fieldDeclarations);
    }

    @Override
    public void notify(DelegateExecution execution) throws Exception {
        ExecutionListener executionListenerInstance = this.getExecutionListenerInstance();
        Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new ExecutionListenerInvocation(executionListenerInstance, execution));
    }

    protected ExecutionListener getExecutionListenerInstance() {
        Object delegateInstance = ClassDelegate.instantiateDelegate(this.className, this.fieldDeclarations);
        if (delegateInstance instanceof ExecutionListener) {
            return (ExecutionListener)delegateInstance;
        }
        if (delegateInstance instanceof JavaDelegate) {
            return new ServiceTaskJavaDelegateActivityBehavior((JavaDelegate)delegateInstance);
        }
        throw new ProcessEngineException(delegateInstance.getClass().getName() + " doesn't implement " + ExecutionListener.class + " nor " + JavaDelegate.class);
    }

    @Override
    public void notify(DelegateTask delegateTask) {
        TaskListener taskListenerInstance = this.getTaskListenerInstance();
        try {
            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new TaskListenerInvocation(taskListenerInstance, delegateTask));
        }
        catch (Exception e) {
            throw new ProcessEngineException("Exception while invoking TaskListener: " + e.getMessage(), e);
        }
    }

    protected TaskListener getTaskListenerInstance() {
        Object delegateInstance = ClassDelegate.instantiateDelegate(this.className, this.fieldDeclarations);
        if (delegateInstance instanceof TaskListener) {
            return (TaskListener)delegateInstance;
        }
        throw new ProcessEngineException(delegateInstance.getClass().getName() + " doesn't implement " + TaskListener.class);
    }

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        ActivityBehavior activityBehaviorInstance = this.getActivityBehaviorInstance(execution);
        try {
            activityBehaviorInstance.execute(execution);
        }
        catch (BpmnError error) {
            ErrorPropagation.propagateError(error, execution);
        }
        catch (Exception ex) {
            ErrorPropagation.propagateException(ex, execution);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void signal(final ActivityExecution execution, final String signalName, final Object signalData) throws Exception {
        ProcessApplicationReference targetProcessApplication = ProcessApplicationContextUtil.getTargetProcessApplication((ExecutionEntity)execution);
        if (!ProcessApplicationContextUtil.requiresContextSwitch(targetProcessApplication)) {
            ActivityBehavior activityBehaviorInstance = this.getActivityBehaviorInstance(execution);
            if (!(activityBehaviorInstance instanceof SignallableActivityBehavior)) throw new ProcessEngineException("signal() can only be called on a " + SignallableActivityBehavior.class.getName() + " instance");
            ((SignallableActivityBehavior)activityBehaviorInstance).signal(execution, signalName, signalData);
            return;
        } else {
            Context.executeWithinProcessApplication(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ClassDelegate.this.signal(execution, signalName, signalData);
                    return null;
                }
            }, targetProcessApplication);
        }
    }

    protected ActivityBehavior getActivityBehaviorInstance(ActivityExecution execution) {
        Object delegateInstance = ClassDelegate.instantiateDelegate(this.className, this.fieldDeclarations);
        if (delegateInstance instanceof ActivityBehavior) {
            return this.determineBehaviour((ActivityBehavior)delegateInstance, execution);
        }
        if (delegateInstance instanceof JavaDelegate) {
            return this.determineBehaviour(new ServiceTaskJavaDelegateActivityBehavior((JavaDelegate)delegateInstance), execution);
        }
        throw new ProcessEngineException(delegateInstance.getClass().getName() + " doesn't implement " + JavaDelegate.class.getName() + " nor " + ActivityBehavior.class.getName());
    }

    protected ActivityBehavior determineBehaviour(ActivityBehavior delegateInstance, ActivityExecution execution) {
        if (this.hasMultiInstanceCharacteristics()) {
            this.multiInstanceActivityBehavior.setInnerActivityBehavior((AbstractBpmnActivityBehavior)delegateInstance);
            return this.multiInstanceActivityBehavior;
        }
        return delegateInstance;
    }

    public static Object instantiateDelegate(Class<?> clazz, List<FieldDeclaration> fieldDeclarations) {
        return ClassDelegate.instantiateDelegate(clazz.getName(), fieldDeclarations);
    }

    public static Object instantiateDelegate(String className, List<FieldDeclaration> fieldDeclarations) {
        Object object = ReflectUtil.instantiate(className);
        ClassDelegate.applyFieldDeclaration(fieldDeclarations, object);
        return object;
    }

    public static void applyFieldDeclaration(List<FieldDeclaration> fieldDeclarations, Object target) {
        if (fieldDeclarations != null) {
            for (FieldDeclaration declaration : fieldDeclarations) {
                ClassDelegate.applyFieldDeclaration(declaration, target);
            }
        }
    }

    public static void applyFieldDeclaration(FieldDeclaration declaration, Object target) {
        Method setterMethod = ReflectUtil.getSetter(declaration.getName(), target.getClass(), declaration.getValue().getClass());
        if (setterMethod != null) {
            try {
                setterMethod.invoke(target, declaration.getValue());
            }
            catch (IllegalArgumentException e) {
                throw new ProcessEngineException("Error while invoking '" + declaration.getName() + "' on class " + target.getClass().getName(), e);
            }
            catch (IllegalAccessException e) {
                throw new ProcessEngineException("Illegal acces when calling '" + declaration.getName() + "' on class " + target.getClass().getName(), e);
            }
            catch (InvocationTargetException e) {
                throw new ProcessEngineException("Exception while invoking '" + declaration.getName() + "' on class " + target.getClass().getName(), e);
            }
        } else {
            Field field = ReflectUtil.getField(declaration.getName(), target);
            if (field == null) {
                throw new ProcessEngineException("Field definition uses unexisting field '" + declaration.getName() + "' on class " + target.getClass().getName());
            }
            if (!ClassDelegate.fieldTypeCompatible(declaration, field)) {
                throw new ProcessEngineException("Incompatible type set on field declaration '" + declaration.getName() + "' for class " + target.getClass().getName() + ". Declared value has type " + declaration.getValue().getClass().getName() + ", while expecting " + field.getType().getName());
            }
            ReflectUtil.setField(field, target, declaration.getValue());
        }
    }

    public static boolean fieldTypeCompatible(FieldDeclaration declaration, Field field) {
        if (declaration.getValue() != null) {
            return field.getType().isAssignableFrom(declaration.getValue().getClass());
        }
        return true;
    }

    public String getClassName() {
        return this.className;
    }
}

