/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.listener;

import java.io.StringReader;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.el.Expression;
import org.camunda.bpm.engine.impl.scripting.ExecutableScript;
import org.camunda.bpm.engine.impl.scripting.ScriptFactory;
import org.camunda.bpm.engine.impl.scripting.env.ScriptingEnvironment;

public class ScriptTaskListener
implements TaskListener {
    private Expression script;
    private Expression language = null;
    private Expression resultVariable = null;

    @Override
    public void notify(DelegateTask delegateTask) {
        if (this.script == null) {
            throw new IllegalArgumentException("The field 'script' should be set on the TaskListener");
        }
        if (this.language == null) {
            throw new IllegalArgumentException("The field 'language' should be set on the TaskListener");
        }
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        ScriptingEnvironment scriptEnv = processEngineConfiguration.getScriptingEnvironment();
        ScriptFactory scriptFactory = processEngineConfiguration.getScriptFactory();
        ExecutableScript executableScript = scriptFactory.createScript(new StringReader(this.script.getExpressionText()), this.language.getExpressionText());
        Object result = scriptEnv.execute(executableScript, delegateTask);
        if (this.resultVariable != null) {
            delegateTask.setVariable(this.resultVariable.getExpressionText(), result);
        }
    }

    public void setScript(Expression script) {
        this.script = script;
    }

    public void setLanguage(Expression language) {
        this.language = language;
    }

    public void setResultVariable(Expression resultVariable) {
        this.resultVariable = resultVariable;
    }
}

