/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceEntity;

public class GetDeploymentResourceForIdCmd
implements Command<InputStream>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String deploymentId;
    protected String resourceId;

    public GetDeploymentResourceForIdCmd(String deploymentId, String resourceId) {
        this.deploymentId = deploymentId;
        this.resourceId = resourceId;
    }

    @Override
    public InputStream execute(CommandContext commandContext) {
        if (this.deploymentId == null) {
            throw new ProcessEngineException("deploymentId is null");
        }
        if (this.resourceId == null) {
            throw new ProcessEngineException("resourceId is null");
        }
        ResourceEntity resource = commandContext.getResourceManager().findResourceByDeploymentIdAndResourceId(this.deploymentId, this.resourceId);
        if (resource == null) {
            throw new ProcessEngineException("no resource found with id '" + this.resourceId + "' in deployment '" + this.deploymentId + "'");
        }
        return new ByteArrayInputStream(resource.getBytes());
    }
}

