/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.entity.runtime;

import java.util.List;
import org.camunda.bpm.engine.impl.AbstractVariableQueryImpl;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseInstanceQueryProperty;
import org.camunda.bpm.engine.impl.cmmn.execution.CaseExecutionState;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.CaseInstanceQuery;

public class CaseInstanceQueryImpl
extends AbstractVariableQueryImpl<CaseInstanceQuery, CaseInstance>
implements CaseInstanceQuery {
    private static final long serialVersionUID = 1L;
    protected String caseExecutionId;
    protected String businessKey;
    protected String caseDefinitionId;
    protected String caseDefinitionKey;
    protected CaseExecutionState state;

    public CaseInstanceQueryImpl() {
    }

    public CaseInstanceQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public CaseInstanceQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public CaseInstanceQuery caseInstanceId(String caseInstanceId) {
        this.assertParamNotNull("caseInstanceId", caseInstanceId);
        this.caseExecutionId = caseInstanceId;
        return this;
    }

    @Override
    public CaseInstanceQuery caseInstanceBusinessKey(String caseInstanceBusinessKey) {
        this.assertParamNotNull("businessKey", caseInstanceBusinessKey);
        this.businessKey = caseInstanceBusinessKey;
        return this;
    }

    @Override
    public CaseInstanceQuery caseDefinitionKey(String caseDefinitionKey) {
        this.assertParamNotNull("caseDefinitionKey", caseDefinitionKey);
        this.caseDefinitionKey = caseDefinitionKey;
        return this;
    }

    @Override
    public CaseInstanceQuery caseDefinitionId(String caseDefinitionId) {
        this.assertParamNotNull("caseDefinitionId", caseDefinitionId);
        this.caseDefinitionId = caseDefinitionId;
        return this;
    }

    @Override
    public CaseInstanceQuery active() {
        this.state = CaseExecutionState.ACTIVE;
        return this;
    }

    @Override
    public CaseInstanceQuery orderByCaseInstanceId() {
        this.orderBy(CaseInstanceQueryProperty.CASE_INSTANCE_ID);
        return this;
    }

    @Override
    public CaseInstanceQuery orderByCaseDefinitionKey() {
        this.orderBy(CaseInstanceQueryProperty.CASE_DEFINITION_KEY);
        return this;
    }

    @Override
    public CaseInstanceQuery orderByCaseDefinitionId() {
        this.orderBy(CaseInstanceQueryProperty.CASE_DEFINITION_ID);
        return this;
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        this.ensureVariablesInitialized();
        return commandContext.getCaseExecutionManager().findCaseInstanceCountByQueryCriteria(this);
    }

    @Override
    public List<CaseInstance> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        this.ensureVariablesInitialized();
        return commandContext.getCaseExecutionManager().findCaseInstanceByQueryCriteria(this, page);
    }

    public String getCaseInstanceId() {
        return this.caseExecutionId;
    }

    public String getCaseExecutionId() {
        return this.caseExecutionId;
    }

    public String getActivityId() {
        return null;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public String getCaseDefinitionKey() {
        return this.caseDefinitionKey;
    }

    public CaseExecutionState getState() {
        return this.state;
    }

    public boolean isCaseInstancesOnly() {
        return true;
    }
}

