/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.execution;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cmmn.execution.CaseExecutionState;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnCaseInstance;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.impl.cmmn.operation.CmmnAtomicOperation;
import org.camunda.bpm.engine.impl.core.instance.CoreExecution;
import org.camunda.bpm.engine.impl.core.variable.CoreVariableScope;

public abstract class CmmnExecution
extends CoreExecution
implements CmmnCaseInstance {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(CmmnExecution.class.getName());
    protected transient CmmnCaseDefinition caseDefinition;
    protected transient CmmnActivity activity;
    protected transient CmmnActivity nextActivity;
    protected int previousState;
    protected int currentState;

    public abstract List<? extends CmmnExecution> getCaseExecutions();

    @Override
    public CmmnExecution findCaseExecution(String activityId) {
        if (this.getActivity() != null && this.getActivity().getId().equals(activityId)) {
            return this;
        }
        for (CmmnExecution cmmnExecution : this.getCaseExecutions()) {
            CmmnExecution result = cmmnExecution.findCaseExecution(activityId);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public String getCaseBusinessKey() {
        return this.getCaseInstance().getBusinessKey();
    }

    public CmmnCaseDefinition getCaseDefinition() {
        return this.caseDefinition;
    }

    public void setCaseDefinition(CmmnCaseDefinition caseDefinition) {
        this.caseDefinition = caseDefinition;
    }

    public abstract CmmnExecution getCaseInstance();

    public abstract void setCaseInstance(CmmnExecution var1);

    public boolean isCaseInstanceExecution() {
        return this.getParent() == null;
    }

    @Override
    public String getCaseInstanceId() {
        return this.getCaseInstance().getId();
    }

    public abstract CmmnExecution getParent();

    public abstract void setParent(CmmnExecution var1);

    @Override
    public CmmnActivity getActivity() {
        return this.activity;
    }

    public void setActivity(CmmnActivity activity) {
        this.activity = activity;
    }

    public CmmnActivity getNextActivity() {
        return this.nextActivity;
    }

    public void setNextActivity(CmmnActivity nextActivity) {
        this.nextActivity = nextActivity;
    }

    @Override
    public CoreVariableScope getParentVariableScope() {
        return this.getParent();
    }

    public void deleteCascade() {
        this.performOperation(CmmnAtomicOperation.CASE_EXECUTION_DELETE_CASCADE);
    }

    public void remove() {
        CmmnExecution parent = this.getParent();
        if (parent != null) {
            parent.getCaseExecutions().remove(this);
        }
    }

    public int getCurrentState() {
        return this.currentState;
    }

    public void setCurrentState(CaseExecutionState currentState) {
        this.previousState = this.currentState;
        this.currentState = currentState.getStateCode();
    }

    public void setCurrentState(int currentState) {
        this.currentState = currentState;
    }

    @Override
    public boolean isAvailable() {
        return this.currentState == CaseExecutionState.AVAILABLE.getStateCode();
    }

    @Override
    public boolean isEnabled() {
        return this.currentState == CaseExecutionState.ENABLED.getStateCode();
    }

    @Override
    public boolean isDisabled() {
        return this.currentState == CaseExecutionState.DISABLED.getStateCode();
    }

    @Override
    public boolean isActive() {
        return this.currentState == CaseExecutionState.ACTIVE.getStateCode();
    }

    @Override
    public boolean isCompleted() {
        return this.currentState == CaseExecutionState.COMPLETED.getStateCode();
    }

    @Override
    public boolean isSuspended() {
        return this.currentState == CaseExecutionState.SUSPENDED.getStateCode();
    }

    @Override
    public boolean isTerminated() {
        return this.currentState == CaseExecutionState.TERMINATED.getStateCode();
    }

    @Override
    public boolean isFailed() {
        return this.currentState == CaseExecutionState.FAILED.getStateCode();
    }

    @Override
    public boolean isClosed() {
        return this.currentState == CaseExecutionState.CLOSED.getStateCode();
    }

    public int getPreviousState() {
        return this.previousState;
    }

    public void setPreviousState(int previousState) {
        this.previousState = this.currentState;
    }

    @Override
    public void create() {
        this.create(null, null);
    }

    @Override
    public void create(Map<String, Object> variables) {
        this.create(null, variables);
    }

    @Override
    public void create(String businessKey) {
        this.create(businessKey, null);
    }

    @Override
    public void create(String businessKey, Map<String, Object> variables) {
        if (variables != null) {
            this.setVariables(variables);
        }
        if (businessKey != null) {
            this.setBusinessKey(businessKey);
        }
        this.setCurrentState(CaseExecutionState.ACTIVE);
        this.performOperation(CmmnAtomicOperation.CASE_INSTANCE_NOTIFY_LISTENER_CREATE);
    }

    @Override
    public void create(List<CmmnActivity> activities) {
        if (!this.isActive()) {
            throw new ProcessEngineException();
        }
        ArrayList<CmmnExecution> children = new ArrayList<CmmnExecution>();
        for (CmmnActivity currentActivity : activities) {
            CmmnExecution child = this.createCaseExecution(currentActivity);
            children.add(child);
        }
        for (CmmnExecution child : children) {
            if (this.isActive()) {
                child.performOperation(CmmnAtomicOperation.CASE_EXECUTION_NOTIFY_LISTENER_CREATE);
                continue;
            }
            log.fine("Not taking child '" + child + "', parent plan item has ended.");
        }
    }

    protected abstract CmmnExecution createCaseExecution(CmmnActivity var1);

    protected abstract CmmnExecution newCaseExecution();

    @Override
    public void enable() {
        this.transition(CaseExecutionState.AVAILABLE, CaseExecutionState.ENABLED, CmmnAtomicOperation.CASE_EXECUTION_NOTIFY_LISTENER_ENABLE);
    }

    @Override
    public void disable() {
        this.transition(CaseExecutionState.ENABLED, CaseExecutionState.DISABLED, CmmnAtomicOperation.CASE_EXECUTION_NOTIFY_LISTENER_DISABLE);
    }

    @Override
    public void reenable() {
        this.transition(CaseExecutionState.DISABLED, CaseExecutionState.ENABLED, CmmnAtomicOperation.CASE_EXECUTION_NOTIFY_LISTENER_RE_ENABLE);
    }

    @Override
    public void manualStart() {
        this.transition(CaseExecutionState.ENABLED, CaseExecutionState.ACTIVE, CmmnAtomicOperation.CASE_EXECUTION_NOTIFY_LISTENER_MANUAL_START);
    }

    @Override
    public void start() {
        this.transition(CaseExecutionState.AVAILABLE, CaseExecutionState.ACTIVE, CmmnAtomicOperation.CASE_EXECUTION_NOTIFY_LISTENER_START);
    }

    @Override
    public void complete() {
        this.transition(CaseExecutionState.ACTIVE, CaseExecutionState.COMPLETED, CmmnAtomicOperation.CASE_EXECUTION_NOTIFY_LISTENER_COMPLETE);
    }

    protected void transition(CaseExecutionState from, CaseExecutionState to, CmmnAtomicOperation nextOperation) {
        if (this.currentState != from.getStateCode()) {
            throw new ProcessEngineException();
        }
        this.setCurrentState(to);
        if (nextOperation != null) {
            this.performOperation(nextOperation);
        }
    }

    public String toString() {
        if (this.isCaseInstanceExecution()) {
            return "CaseInstance[" + this.getToStringIdentity() + "]";
        }
        return "CmmnExecution[" + this.getToStringIdentity() + "]";
    }

    protected String getToStringIdentity() {
        return this.id;
    }
}

