/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.deploy;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.ProcessDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.cmd.GetDeploymentResourceCmd;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.Deployer;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.cmmn.Cmmn;
import org.camunda.bpm.model.cmmn.CmmnModelInstance;

public class DeploymentCache {
    private Logger LOGGER = Logger.getLogger(DeploymentCache.class.getName());
    protected Map<String, ProcessDefinitionEntity> processDefinitionCache = new HashMap<String, ProcessDefinitionEntity>();
    protected Map<String, CaseDefinitionEntity> caseDefinitionCache = new HashMap<String, CaseDefinitionEntity>();
    protected Map<String, BpmnModelInstance> bpmnModelInstanceCache = new HashMap<String, BpmnModelInstance>();
    protected Map<String, CmmnModelInstance> cmmnModelInstanceCache = new HashMap<String, CmmnModelInstance>();
    protected List<Deployer> deployers;

    public void deploy(DeploymentEntity deployment) {
        for (Deployer deployer : this.deployers) {
            deployer.deploy(deployment);
        }
    }

    public ProcessDefinitionEntity findDeployedProcessDefinitionById(String processDefinitionId) {
        if (processDefinitionId == null) {
            throw new ProcessEngineException("Invalid process definition id : null");
        }
        CommandContext commandContext = Context.getCommandContext();
        ProcessDefinitionEntity processDefinition = commandContext.getDbSqlSession().findInCache(ProcessDefinitionEntity.class, processDefinitionId);
        if (processDefinition == null) {
            processDefinition = commandContext.getProcessDefinitionManager().findLatestProcessDefinitionById(processDefinitionId);
        }
        if (processDefinition == null) {
            throw new ProcessEngineException("no deployed process definition found with id '" + processDefinitionId + "'");
        }
        processDefinition = this.resolveProcessDefinition(processDefinition);
        return processDefinition;
    }

    public ProcessDefinitionEntity findDeployedLatestProcessDefinitionByKey(String processDefinitionKey) {
        ProcessDefinitionEntity processDefinition = Context.getCommandContext().getProcessDefinitionManager().findLatestProcessDefinitionByKey(processDefinitionKey);
        if (processDefinition == null) {
            throw new ProcessEngineException("no processes deployed with key '" + processDefinitionKey + "'");
        }
        processDefinition = this.resolveProcessDefinition(processDefinition);
        return processDefinition;
    }

    public ProcessDefinitionEntity findDeployedProcessDefinitionByKeyAndVersion(String processDefinitionKey, Integer processDefinitionVersion) {
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)Context.getCommandContext().getProcessDefinitionManager().findProcessDefinitionByKeyAndVersion(processDefinitionKey, processDefinitionVersion);
        if (processDefinition == null) {
            throw new ProcessEngineException("no processes deployed with key = '" + processDefinitionKey + "' and version = '" + processDefinitionVersion + "'");
        }
        processDefinition = this.resolveProcessDefinition(processDefinition);
        return processDefinition;
    }

    public ProcessDefinitionEntity findDeployedProcessDefinitionByDeploymentAndKey(String deploymentId, String processDefinitionKey) {
        ProcessDefinitionEntity processDefinition = Context.getCommandContext().getProcessDefinitionManager().findProcessDefinitionByDeploymentAndKey(deploymentId, processDefinitionKey);
        if (processDefinition == null) {
            throw new ProcessEngineException("no processes deployed with key = '" + processDefinitionKey + "' in deployment = '" + deploymentId + "'");
        }
        processDefinition = this.resolveProcessDefinition(processDefinition);
        return processDefinition;
    }

    public ProcessDefinitionEntity resolveProcessDefinition(ProcessDefinitionEntity processDefinition) {
        String processDefinitionId = processDefinition.getId();
        String deploymentId = processDefinition.getDeploymentId();
        ProcessDefinitionEntity cachedProcessDefinition = this.processDefinitionCache.get(processDefinitionId);
        if (cachedProcessDefinition == null) {
            DeploymentEntity deployment = Context.getCommandContext().getDeploymentManager().findDeploymentById(deploymentId);
            deployment.setNew(false);
            this.deploy(deployment);
            cachedProcessDefinition = this.processDefinitionCache.get(processDefinitionId);
            if (cachedProcessDefinition == null) {
                throw new ProcessEngineException("deployment '" + deploymentId + "' didn't put process definition '" + processDefinitionId + "' in the cache");
            }
        } else {
            cachedProcessDefinition.updateModifiedFieldsFromEntity(processDefinition);
        }
        return cachedProcessDefinition;
    }

    public BpmnModelInstance findBpmnModelInstanceForProcessDefinition(String processDefinitionId) {
        BpmnModelInstance bpmnModelInstance = this.bpmnModelInstanceCache.get(processDefinitionId);
        if (bpmnModelInstance == null) {
            ProcessDefinitionEntity processDefinition = this.findDeployedProcessDefinitionById(processDefinitionId);
            String deploymentId = processDefinition.getDeploymentId();
            String resourceName = processDefinition.getResourceName();
            InputStream bpmnResourceInputStream = new GetDeploymentResourceCmd(deploymentId, resourceName).execute(Context.getCommandContext());
            try {
                bpmnModelInstance = Bpmn.readModelFromStream((InputStream)bpmnResourceInputStream);
            }
            catch (Exception e) {
                throw new ProcessEngineException("Could not load Bpmn Model for process definition " + processDefinitionId, e);
            }
            this.bpmnModelInstanceCache.put(processDefinitionId, bpmnModelInstance);
        }
        return bpmnModelInstance;
    }

    public void addProcessDefinition(ProcessDefinitionEntity processDefinition) {
        this.processDefinitionCache.put(processDefinition.getId(), processDefinition);
    }

    public void removeProcessDefinition(String processDefinitionId) {
        this.processDefinitionCache.remove(processDefinitionId);
    }

    public void discardProcessDefinitionCache() {
        this.processDefinitionCache.clear();
    }

    public CaseDefinitionEntity findDeployedCaseDefinitionById(String caseDefinitionId) {
        if (caseDefinitionId == null) {
            throw new ProcessEngineException("Invalid case definition id: null");
        }
        CommandContext commandContext = Context.getCommandContext();
        CaseDefinitionEntity caseDefinition = commandContext.getDbSqlSession().findInCache(CaseDefinitionEntity.class, caseDefinitionId);
        if (caseDefinition == null) {
            caseDefinition = commandContext.getCaseDefinitionManager().findCaseDefinitionById(caseDefinitionId);
        }
        if (caseDefinition == null) {
            throw new ProcessEngineException("no deployed case definition found with id '" + caseDefinitionId + "'");
        }
        caseDefinition = this.resolveCaseDefinition(caseDefinition);
        return caseDefinition;
    }

    public CaseDefinitionEntity findDeployedLatestCaseDefinitionByKey(String caseDefinitionKey) {
        if (caseDefinitionKey == null) {
            throw new ProcessEngineException("Invalid case definition key: null");
        }
        CaseDefinitionEntity caseDefinition = Context.getCommandContext().getCaseDefinitionManager().findLatestCaseDefinitionByKey(caseDefinitionKey);
        if (caseDefinition == null) {
            throw new ProcessEngineException("no case definition deployed with key '" + caseDefinitionKey + "'");
        }
        caseDefinition = this.resolveCaseDefinition(caseDefinition);
        return caseDefinition;
    }

    public CaseDefinitionEntity findDeployedCaseDefinitionByKeyAndVersion(String caseDefinitionKey, Integer caseDefinitionVersion) {
        CaseDefinitionEntity caseDefinition = Context.getCommandContext().getCaseDefinitionManager().findCaseDefinitionByKeyAndVersion(caseDefinitionKey, caseDefinitionVersion);
        if (caseDefinition == null) {
            throw new ProcessEngineException("no case definition deployed with key = '" + caseDefinitionKey + "' and version = '" + caseDefinitionVersion + "'");
        }
        caseDefinition = this.resolveCaseDefinition(caseDefinition);
        return caseDefinition;
    }

    public CaseDefinitionEntity findDeployedCaseDefinitionByDeploymentAndKey(String deploymentId, String caseDefinitionKey) {
        CaseDefinitionEntity caseDefinition = Context.getCommandContext().getCaseDefinitionManager().findCaseDefinitionByDeploymentAndKey(deploymentId, caseDefinitionKey);
        if (caseDefinition == null) {
            throw new ProcessEngineException("no case definition deployed with key = '" + caseDefinitionKey + "' in deployment = '" + deploymentId + "'");
        }
        caseDefinition = this.resolveCaseDefinition(caseDefinition);
        return caseDefinition;
    }

    public CaseDefinitionEntity resolveCaseDefinition(CaseDefinitionEntity caseDefinition) {
        String caseDefinitionId = caseDefinition.getId();
        String deploymentId = caseDefinition.getDeploymentId();
        CaseDefinitionEntity cachedCaseDefinition = this.caseDefinitionCache.get(caseDefinitionId);
        if (cachedCaseDefinition == null) {
            DeploymentEntity deployment = Context.getCommandContext().getDeploymentManager().findDeploymentById(deploymentId);
            deployment.setNew(false);
            this.deploy(deployment);
            cachedCaseDefinition = this.caseDefinitionCache.get(caseDefinitionId);
            if (cachedCaseDefinition == null) {
                throw new ProcessEngineException("deployment '" + deploymentId + "' didn't put case definition '" + caseDefinitionId + "' in the cache");
            }
        }
        return cachedCaseDefinition;
    }

    public CmmnModelInstance findCmmnModelInstanceForCaseDefinition(String caseDefinitionId) {
        CmmnModelInstance cmmnModelInstance = this.cmmnModelInstanceCache.get(caseDefinitionId);
        if (cmmnModelInstance == null) {
            CaseDefinitionEntity caseDefinition = this.findDeployedCaseDefinitionById(caseDefinitionId);
            String deploymentId = caseDefinition.getDeploymentId();
            String resourceName = caseDefinition.getResourceName();
            InputStream cmmnResourceInputStream = new GetDeploymentResourceCmd(deploymentId, resourceName).execute(Context.getCommandContext());
            try {
                cmmnModelInstance = Cmmn.readModelFromStream((InputStream)cmmnResourceInputStream);
            }
            catch (Exception e) {
                throw new ProcessEngineException("Could not load Cmmn Model for case definition " + caseDefinitionId, e);
            }
            this.cmmnModelInstanceCache.put(caseDefinitionId, cmmnModelInstance);
        }
        return cmmnModelInstance;
    }

    public void addCaseDefinition(CaseDefinitionEntity caseDefinition) {
        this.caseDefinitionCache.put(caseDefinition.getId(), caseDefinition);
    }

    public void removeCaseDefinition(String caseDefinitionId) {
        this.caseDefinitionCache.remove(caseDefinitionId);
    }

    public void discardCaseDefinitionCache() {
        this.caseDefinitionCache.clear();
    }

    public Map<String, BpmnModelInstance> getBpmnModelInstanceCache() {
        return this.bpmnModelInstanceCache;
    }

    public Map<String, CmmnModelInstance> getCmmnModelInstanceCache() {
        return this.cmmnModelInstanceCache;
    }

    public Map<String, ProcessDefinitionEntity> getProcessDefinitionCache() {
        return this.processDefinitionCache;
    }

    public void setProcessDefinitionCache(Map<String, ProcessDefinitionEntity> processDefinitionCache) {
        this.processDefinitionCache = processDefinitionCache;
    }

    public Map<String, CaseDefinitionEntity> getCaseDefinitionCache() {
        return this.caseDefinitionCache;
    }

    public void setCaseDefinitionCache(Map<String, CaseDefinitionEntity> caseDefinitionCache) {
        this.caseDefinitionCache = caseDefinitionCache;
    }

    public List<Deployer> getDeployers() {
        return this.deployers;
    }

    public void setDeployers(List<Deployer> deployers) {
        this.deployers = deployers;
    }

    public void removeDeployment(String deploymentId) {
        List allDefinitionsForDeployment = new ProcessDefinitionQueryImpl(Context.getCommandContext()).deploymentId(deploymentId).list();
        for (ProcessDefinition processDefinition : allDefinitionsForDeployment) {
            try {
                this.removeProcessDefinition(processDefinition.getId());
            }
            catch (Exception e) {
                this.LOGGER.log(Level.WARNING, "Could not remove process definition with id '" + processDefinition.getId() + "' from the cache.", e);
            }
        }
    }
}

