/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.List;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstanceQuery;
import org.camunda.bpm.engine.impl.HistoricVariableInstanceQueryImpl;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.persistence.AbstractHistoricManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricVariableInstanceEntity;

public class HistoricVariableInstanceManager
extends AbstractHistoricManager {
    public void deleteHistoricVariableInstanceByProcessInstanceId(String historicProcessInstanceId) {
        if (this.historyLevel >= 1) {
            List<HistoricVariableInstance> historicProcessVariables = Context.getCommandContext().getHistoricVariableInstanceManager().findHistoricVariableInstancesByProcessInstanceId(historicProcessInstanceId);
            for (HistoricVariableInstance historicProcessVariable : historicProcessVariables) {
                ((HistoricVariableInstanceEntity)historicProcessVariable).delete();
            }
            List<HistoricVariableInstanceEntity> cachedHistoricVariableInstances = this.getDbSqlSession().findInCache(HistoricVariableInstanceEntity.class);
            for (HistoricVariableInstanceEntity historicProcessVariable : cachedHistoricVariableInstances) {
                if (!historicProcessVariable.getProcessInstanceId().equals(historicProcessInstanceId)) continue;
                historicProcessVariable.delete();
            }
        }
    }

    public List<HistoricVariableInstance> findHistoricVariableInstancesByProcessInstanceId(String processInstanceId) {
        return this.getDbSqlSession().selectList("selectHistoricVariablesByProcessInstanceId", processInstanceId);
    }

    public long findHistoricVariableInstanceCountByQueryCriteria(HistoricVariableInstanceQueryImpl historicProcessVariableQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectHistoricVariableInstanceCountByQueryCriteria", historicProcessVariableQuery);
    }

    public List<HistoricVariableInstance> findHistoricVariableInstancesByQueryCriteria(HistoricVariableInstanceQueryImpl historicProcessVariableQuery, Page page) {
        return this.getDbSqlSession().selectList("selectHistoricVariableInstanceByQueryCriteria", historicProcessVariableQuery, page);
    }

    public HistoricVariableInstanceEntity findHistoricVariableInstanceByVariableInstanceId(String variableInstanceId) {
        return (HistoricVariableInstanceEntity)this.getDbSqlSession().selectOne("selectHistoricVariableInstanceByVariableInstanceId", variableInstanceId);
    }

    public void deleteHistoricVariableInstancesByTaskId(String taskId) {
        if (this.historyLevel >= 1) {
            HistoricVariableInstanceQuery historicProcessVariableQuery = new HistoricVariableInstanceQueryImpl().taskIdIn(taskId);
            List historicProcessVariables = historicProcessVariableQuery.list();
            for (HistoricVariableInstance historicProcessVariable : historicProcessVariables) {
                ((HistoricVariableInstanceEntity)historicProcessVariable).delete();
            }
        }
    }
}

