/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.scripting.env;

import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.scripting.ExecutableScript;
import org.camunda.bpm.engine.impl.scripting.ScriptFactory;
import org.camunda.bpm.engine.impl.scripting.engine.ScriptingEngines;
import org.camunda.bpm.engine.impl.scripting.env.ScriptEnvResolver;

public class ScriptingEnvironment {
    protected Map<String, List<ExecutableScript>> env = new HashMap<String, List<ExecutableScript>>();
    protected List<ScriptEnvResolver> envResolvers;
    protected ScriptFactory scriptFactory;
    protected ScriptingEngines scriptingEngines;

    public ScriptingEnvironment(ScriptFactory scriptFactory, List<ScriptEnvResolver> envResolvers) {
        this.scriptFactory = scriptFactory;
        this.envResolvers = envResolvers;
        this.scriptingEngines = scriptFactory.getScriptingEngines();
    }

    public Object execute(ExecutableScript script, VariableScope scope) {
        String scriptLanguage = script.getLanguage();
        ScriptEngine scriptEngine = this.scriptingEngines.getScriptEngineForLanguage(scriptLanguage);
        Bindings bindings = this.scriptingEngines.createBindings(scriptEngine, scope);
        List<ExecutableScript> envScripts = this.getEnvScripts(scriptLanguage);
        for (ExecutableScript envScript : envScripts) {
            envScript.execute(scriptEngine, bindings);
        }
        return script.execute(scriptEngine, bindings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ExecutableScript> getEnvScripts(String scriptLanguage) {
        List<ExecutableScript> envScripts = this.env.get(scriptLanguage);
        if (envScripts == null) {
            ScriptingEnvironment scriptingEnvironment = this;
            synchronized (scriptingEnvironment) {
                envScripts = this.env.get(scriptLanguage);
                if (envScripts == null) {
                    envScripts = this.initEnvForLanguage(scriptLanguage);
                    this.env.put(scriptLanguage, envScripts);
                }
            }
        }
        return envScripts;
    }

    protected List<ExecutableScript> initEnvForLanguage(String language) {
        ArrayList<ExecutableScript> scripts = new ArrayList<ExecutableScript>();
        for (ScriptEnvResolver resolver : this.envResolvers) {
            Reader[] resolvedScripts = resolver.resolve(language);
            if (resolvedScripts == null) continue;
            for (Reader resolvedScript : resolvedScripts) {
                scripts.add(this.scriptFactory.createScript(resolvedScript, language));
            }
        }
        return scripts;
    }
}

