/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.util;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ClassLoadingException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.util.ClassLoaderUtil;

public abstract class ReflectUtil {
    private static final Logger LOG = Logger.getLogger(ReflectUtil.class.getName());
    private static final Map<String, String> charEncodings = new HashMap<String, String>();

    public static ClassLoader getClassLoader() {
        ClassLoader loader = ReflectUtil.getCustomClassLoader();
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        return loader;
    }

    public static Class<?> loadClass(String className) {
        Throwable throwable;
        Class<?> clazz;
        block12: {
            clazz = null;
            ClassLoader classLoader = ReflectUtil.getCustomClassLoader();
            throwable = null;
            if (classLoader != null) {
                try {
                    LOG.finest("Trying to load class with custom classloader: " + className);
                    clazz = Class.forName(className, true, classLoader);
                }
                catch (Throwable t) {
                    throwable = t;
                }
            }
            if (clazz == null) {
                block11: {
                    try {
                        ClassLoader contextClassloader = ClassLoaderUtil.getContextClassloader();
                        if (contextClassloader != null) {
                            LOG.finest("Trying to load class with current thread context classloader: " + className);
                            clazz = Class.forName(className, true, contextClassloader);
                        }
                    }
                    catch (Throwable t) {
                        if (throwable != null) break block11;
                        throwable = t;
                    }
                }
                if (clazz == null) {
                    try {
                        LOG.finest("Trying to load class with local classloader: " + className);
                        clazz = Class.forName(className, true, ClassLoaderUtil.getClassloader(ReflectUtil.class));
                    }
                    catch (Throwable t) {
                        if (throwable != null) break block12;
                        throwable = t;
                    }
                }
            }
        }
        if (clazz == null) {
            throw new ClassLoadingException(className, throwable);
        }
        return clazz;
    }

    public static InputStream getResourceAsStream(String name) {
        InputStream resourceStream = null;
        ClassLoader classLoader = ReflectUtil.getCustomClassLoader();
        if (classLoader != null) {
            resourceStream = classLoader.getResourceAsStream(name);
        }
        if (resourceStream == null && (resourceStream = (classLoader = Thread.currentThread().getContextClassLoader()).getResourceAsStream(name)) == null) {
            classLoader = ReflectUtil.class.getClassLoader();
            resourceStream = classLoader.getResourceAsStream(name);
        }
        return resourceStream;
    }

    public static URL getResource(String name) {
        URL url = null;
        ClassLoader classLoader = ReflectUtil.getCustomClassLoader();
        if (classLoader != null) {
            url = classLoader.getResource(name);
        }
        if (url == null && (url = (classLoader = Thread.currentThread().getContextClassLoader()).getResource(name)) == null) {
            classLoader = ReflectUtil.class.getClassLoader();
            url = classLoader.getResource(name);
        }
        return url;
    }

    public static String getResourceUrlAsString(String name) {
        String url = ReflectUtil.getResource(name).toString();
        for (Map.Entry<String, String> mapping : charEncodings.entrySet()) {
            url = url.replaceAll(mapping.getKey(), mapping.getValue());
        }
        return url;
    }

    public static Object instantiate(String className) {
        try {
            Class<?> clazz = ReflectUtil.loadClass(className);
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new ProcessEngineException("couldn't instantiate class " + className, e);
        }
    }

    public static Object invoke(Object target, String methodName, Object[] args) {
        try {
            Class<?> clazz = target.getClass();
            Method method = ReflectUtil.findMethod(clazz, methodName, args);
            method.setAccessible(true);
            return method.invoke(target, args);
        }
        catch (Exception e) {
            throw new ProcessEngineException("couldn't invoke " + methodName + " on " + target, e);
        }
    }

    public static Field getField(String fieldName, Object object) {
        return ReflectUtil.getField(fieldName, object.getClass());
    }

    public static Field getField(String fieldName, Class<?> clazz) {
        Field field;
        block3: {
            field = null;
            try {
                field = clazz.getDeclaredField(fieldName);
            }
            catch (SecurityException e) {
                throw new ProcessEngineException("not allowed to access field " + field + " on class " + clazz.getCanonicalName());
            }
            catch (NoSuchFieldException e) {
                Class<?> superClass = clazz.getSuperclass();
                if (superClass == null) break block3;
                return ReflectUtil.getField(fieldName, superClass);
            }
        }
        return field;
    }

    public static void setField(Field field, Object object, Object value) {
        try {
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (IllegalArgumentException e) {
            throw new ProcessEngineException("Could not set field " + field.toString(), e);
        }
        catch (IllegalAccessException e) {
            throw new ProcessEngineException("Could not set field " + field.toString(), e);
        }
    }

    public static Method getSetter(String fieldName, Class<?> clazz, Class<?> fieldType) {
        String setterName = ReflectUtil.buildSetterName(fieldName);
        try {
            Method[] methods;
            for (Method method : methods = clazz.getMethods()) {
                Class<?>[] paramTypes;
                if (!method.getName().equals(setterName) || (paramTypes = method.getParameterTypes()) == null || paramTypes.length != 1 || !paramTypes[0].isAssignableFrom(fieldType)) continue;
                return method;
            }
            return null;
        }
        catch (SecurityException e) {
            throw new ProcessEngineException("Not allowed to access method " + setterName + " on class " + clazz.getCanonicalName());
        }
    }

    public static Method getSingleSetter(String fieldName, Class<?> clazz) {
        String setterName = ReflectUtil.buildSetterName(fieldName);
        try {
            Method[] methods = clazz.getMethods();
            ArrayList<Method> candidates = new ArrayList<Method>();
            HashSet parameterTypes = new HashSet();
            for (Method method : methods) {
                Class<?>[] paramTypes;
                if (!method.getName().equals(setterName) || (paramTypes = method.getParameterTypes()) == null || paramTypes.length != 1) continue;
                candidates.add(method);
                parameterTypes.add(paramTypes[0]);
            }
            if (parameterTypes.size() > 1) {
                throw new ProcessEngineException("There exists more than one setter method with different argument types named " + setterName + " on class " + clazz.getCanonicalName());
            }
            if (candidates.size() >= 1) {
                return (Method)candidates.get(0);
            }
            return null;
        }
        catch (SecurityException e) {
            throw new ProcessEngineException("Not allowed to access method " + setterName + " on class " + clazz.getCanonicalName());
        }
    }

    private static String buildSetterName(String fieldName) {
        return "set" + Character.toTitleCase(fieldName.charAt(0)) + fieldName.substring(1, fieldName.length());
    }

    private static Method findMethod(Class<? extends Object> clazz, String methodName, Object[] args) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().equals(methodName) || !ReflectUtil.matches(method.getParameterTypes(), args)) continue;
            return method;
        }
        Class<? extends Object> superClass = clazz.getSuperclass();
        if (superClass != null) {
            return ReflectUtil.findMethod(superClass, methodName, args);
        }
        return null;
    }

    public static Object instantiate(String className, Object[] args) {
        Class<?> clazz = ReflectUtil.loadClass(className);
        Constructor<?> constructor = ReflectUtil.findMatchingConstructor(clazz, args);
        if (constructor == null) {
            throw new ProcessEngineException("couldn't find constructor for " + className + " with args " + Arrays.asList(args));
        }
        try {
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new ProcessEngineException("couldn't find constructor for " + className + " with args " + Arrays.asList(args), e);
        }
    }

    private static <T> Constructor<T> findMatchingConstructor(Class<T> clazz, Object[] args) {
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (!ReflectUtil.matches(constructor.getParameterTypes(), args)) continue;
            return constructor;
        }
        return null;
    }

    private static boolean matches(Class<?>[] parameterTypes, Object[] args) {
        if (parameterTypes == null || parameterTypes.length == 0) {
            return args == null || args.length == 0;
        }
        if (args == null || parameterTypes.length != args.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (args[i] == null || parameterTypes[i].isAssignableFrom(args[i].getClass())) continue;
            return false;
        }
        return true;
    }

    private static ClassLoader getCustomClassLoader() {
        ClassLoader classLoader;
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        if (processEngineConfiguration != null && (classLoader = processEngineConfiguration.getClassLoader()) != null) {
            return classLoader;
        }
        return null;
    }

    public static Method getMethod(Class declaringType, String methodName, Class<?> ... parameterTypes) {
        return ReflectUtil.findMethod(declaringType, methodName, parameterTypes);
    }

    static {
        charEncodings.put("\u00e4", "%C3%A4");
        charEncodings.put("\u00f6", "%C3%B6");
        charEncodings.put("\u00fc", "%C3%BC");
        charEncodings.put("\u00c4", "%C3%84");
        charEncodings.put("\u00d6", "%C3%96");
        charEncodings.put("\u00dc", "%C3%9C");
    }
}

