/* Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.camunda.bpm.engine.impl.db.upgrade;

import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbSqlSession;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyEntity;


/**
 * @author Tom Baeyens
 */
public class DbUpgradeStep52To53InsertPropertyHistoryLevel implements DbUpgradeStep {

  public void execute(DbSqlSession dbSqlSession) throws Exception {
    int historyLevel = Context.getProcessEngineConfiguration().getHistoryLevel();
    PropertyEntity property = new PropertyEntity("historyLevel", Integer.toString(historyLevel));
    dbSqlSession.insert(property);
  }

}
