/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.cmmn;

import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseExecutionQuery;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class CaseServiceHumanTaskTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testManualStart() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).manualStart();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        CaseServiceHumanTaskTest.assertTrue((boolean)caseExecution.isActive());
        CaseServiceHumanTaskTest.assertFalse((boolean)caseExecution.isEnabled());
        Task task = (Task)this.taskService.createTaskQuery().caseExecutionId(caseExecutionId).singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)task);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testManualStartWithVariable() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).manualStart();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        CaseServiceHumanTaskTest.assertTrue((boolean)caseExecution.isActive());
        CaseServiceHumanTaskTest.assertFalse((boolean)caseExecution.isEnabled());
        Task task = (Task)this.taskService.createTaskQuery().caseExecutionId(caseExecutionId).singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)task);
        List result = this.runtimeService.createVariableInstanceQuery().list();
        CaseServiceHumanTaskTest.assertFalse((boolean)result.isEmpty());
        CaseServiceHumanTaskTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceHumanTaskTest.assertEquals((String)caseInstanceId, (String)variable.getCaseExecutionId());
            CaseServiceHumanTaskTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceHumanTaskTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceHumanTaskTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceHumanTaskTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceHumanTaskTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseServiceHumanTaskTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testManualStartWithVariables() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_HumanTask_1").singleResult()).getId();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "abc");
        variables.put("anotherVariableName", 999);
        this.caseService.withCaseExecution(caseExecutionId).setVariables(variables).manualStart();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        CaseServiceHumanTaskTest.assertTrue((boolean)caseExecution.isActive());
        CaseServiceHumanTaskTest.assertFalse((boolean)caseExecution.isEnabled());
        Task task = (Task)this.taskService.createTaskQuery().caseExecutionId(caseExecutionId).singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)task);
        List result = this.runtimeService.createVariableInstanceQuery().list();
        CaseServiceHumanTaskTest.assertFalse((boolean)result.isEmpty());
        CaseServiceHumanTaskTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceHumanTaskTest.assertEquals((String)caseInstanceId, (String)variable.getCaseExecutionId());
            CaseServiceHumanTaskTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceHumanTaskTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceHumanTaskTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceHumanTaskTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceHumanTaskTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseServiceHumanTaskTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testManualStartWithLocalVariable() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariableLocal("aVariableName", (Object)"abc").setVariableLocal("anotherVariableName", (Object)999).manualStart();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        CaseServiceHumanTaskTest.assertTrue((boolean)caseExecution.isActive());
        CaseServiceHumanTaskTest.assertFalse((boolean)caseExecution.isEnabled());
        Task task = (Task)this.taskService.createTaskQuery().caseExecutionId(caseExecutionId).singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)task);
        List result = this.runtimeService.createVariableInstanceQuery().list();
        CaseServiceHumanTaskTest.assertFalse((boolean)result.isEmpty());
        CaseServiceHumanTaskTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceHumanTaskTest.assertEquals((String)caseExecutionId, (String)variable.getCaseExecutionId());
            CaseServiceHumanTaskTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceHumanTaskTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceHumanTaskTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceHumanTaskTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceHumanTaskTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseServiceHumanTaskTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testManualStartWithLocalVariables() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_HumanTask_1").singleResult()).getId();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "abc");
        variables.put("anotherVariableName", 999);
        this.caseService.withCaseExecution(caseExecutionId).setVariablesLocal(variables).manualStart();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        CaseServiceHumanTaskTest.assertTrue((boolean)caseExecution.isActive());
        CaseServiceHumanTaskTest.assertFalse((boolean)caseExecution.isEnabled());
        Task task = (Task)this.taskService.createTaskQuery().caseExecutionId(caseExecutionId).singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)task);
        List result = this.runtimeService.createVariableInstanceQuery().list();
        CaseServiceHumanTaskTest.assertFalse((boolean)result.isEmpty());
        CaseServiceHumanTaskTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceHumanTaskTest.assertEquals((String)caseExecutionId, (String)variable.getCaseExecutionId());
            CaseServiceHumanTaskTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceHumanTaskTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceHumanTaskTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceHumanTaskTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceHumanTaskTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseServiceHumanTaskTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testReenableAnEnabledHumanTask() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        try {
            this.caseService.withCaseExecution(caseExecutionId).reenable();
            CaseServiceHumanTaskTest.fail((String)"It should not be possible to re-enable an enabled human task.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn"})
    public void testReenableAnDisabledHumanTask() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).disable();
        this.caseService.withCaseExecution(caseExecutionId).reenable();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        CaseServiceHumanTaskTest.assertFalse((boolean)caseExecution.isDisabled());
        CaseServiceHumanTaskTest.assertFalse((boolean)caseExecution.isActive());
        CaseServiceHumanTaskTest.assertTrue((boolean)caseExecution.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testReenableAnActiveHumanTask() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).manualStart();
        try {
            this.caseService.withCaseExecution(caseExecutionId).reenable();
            CaseServiceHumanTaskTest.fail((String)"It should not be possible to re-enable an active human task.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn"})
    public void testDisableAnEnabledHumanTask() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).disable();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        CaseServiceHumanTaskTest.assertTrue((boolean)caseExecution.isDisabled());
        CaseServiceHumanTaskTest.assertFalse((boolean)caseExecution.isActive());
        CaseServiceHumanTaskTest.assertFalse((boolean)caseExecution.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn"})
    public void testDisableADisabledHumanTask() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).disable();
        try {
            this.caseService.withCaseExecution(caseExecutionId).disable();
            CaseServiceHumanTaskTest.fail((String)"It should not be possible to disable a already disabled human task.");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testDisableAnActiveHumanTask() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).manualStart();
        try {
            this.caseService.withCaseExecution(caseExecutionId).disable();
            CaseServiceHumanTaskTest.fail((String)"It should not be possible to disable an active human task.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn"})
    public void testManualStartOfADisabledHumanTask() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).disable();
        try {
            this.caseService.withCaseExecution(caseExecutionId).manualStart();
            CaseServiceHumanTaskTest.fail((String)"It should not be possible to start a disabled human task manually.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testManualStartOfAnActiveHumanTask() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).manualStart();
        try {
            this.caseService.withCaseExecution(caseExecutionId).manualStart();
            CaseServiceHumanTaskTest.fail((String)"It should not be possible to start an already active human task manually.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn"})
    public void testComplete() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).manualStart();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)task);
        this.caseService.withCaseExecution(caseExecutionId).complete();
        task = (Task)this.taskService.createTaskQuery().singleResult();
        CaseServiceHumanTaskTest.assertNull((Object)task);
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        CaseServiceHumanTaskTest.assertNull((Object)caseExecution);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().active().singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)caseInstance);
        CaseServiceHumanTaskTest.assertTrue((boolean)caseInstance.isActive());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCompleteShouldCompleteCaseInstance() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).manualStart();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)task);
        this.caseService.withCaseExecution(caseExecutionId).complete();
        task = (Task)this.taskService.createTaskQuery().singleResult();
        CaseServiceHumanTaskTest.assertNull((Object)task);
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        CaseServiceHumanTaskTest.assertNull((Object)caseExecution);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().completed().singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)caseInstance);
        CaseServiceHumanTaskTest.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testDisableShouldCompleteCaseInstance() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).disable();
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        CaseServiceHumanTaskTest.assertNull((Object)caseExecution);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().completed().singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)caseInstance);
        CaseServiceHumanTaskTest.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCompleteAnEnabledHumanTask() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        try {
            this.caseService.withCaseExecution(caseExecutionId).complete();
            CaseServiceHumanTaskTest.fail((String)"Should not be able to complete task.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn"})
    public void testCompleteADisabledHumanTask() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).disable();
        try {
            this.caseService.withCaseExecution(caseExecutionId).complete();
            CaseServiceHumanTaskTest.fail((String)"Should not be able to complete task.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn"})
    public void testCompleteWithSetVariable() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).manualStart();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)task);
        this.caseService.withCaseExecution(caseExecutionId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).complete();
        task = (Task)this.taskService.createTaskQuery().singleResult();
        CaseServiceHumanTaskTest.assertNull((Object)task);
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        CaseServiceHumanTaskTest.assertNull((Object)caseExecution);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().active().singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)caseInstance);
        CaseServiceHumanTaskTest.assertTrue((boolean)caseInstance.isActive());
        List result = this.runtimeService.createVariableInstanceQuery().list();
        CaseServiceHumanTaskTest.assertFalse((boolean)result.isEmpty());
        CaseServiceHumanTaskTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceHumanTaskTest.assertEquals((String)caseInstanceId, (String)variable.getCaseExecutionId());
            CaseServiceHumanTaskTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceHumanTaskTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceHumanTaskTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceHumanTaskTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceHumanTaskTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseServiceHumanTaskTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn"})
    public void testCompleteWithSetVariableLocal() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).manualStart();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)task);
        this.caseService.withCaseExecution(caseExecutionId).setVariableLocal("aVariableName", (Object)"abc").setVariableLocal("anotherVariableName", (Object)999).complete();
        task = (Task)this.taskService.createTaskQuery().singleResult();
        CaseServiceHumanTaskTest.assertNull((Object)task);
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        CaseServiceHumanTaskTest.assertNull((Object)caseExecution);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().active().singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)caseInstance);
        CaseServiceHumanTaskTest.assertTrue((boolean)caseInstance.isActive());
        List result = this.runtimeService.createVariableInstanceQuery().list();
        CaseServiceHumanTaskTest.assertTrue((boolean)result.isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn"})
    public void testCompleteWithRemoveVariable() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).manualStart();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)task);
        this.caseService.withCaseExecution(caseExecutionId).removeVariable("aVariableName").removeVariable("anotherVariableName").complete();
        task = (Task)this.taskService.createTaskQuery().singleResult();
        CaseServiceHumanTaskTest.assertNull((Object)task);
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        CaseServiceHumanTaskTest.assertNull((Object)caseExecution);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().active().singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)caseInstance);
        CaseServiceHumanTaskTest.assertTrue((boolean)caseInstance.isActive());
        List result = this.runtimeService.createVariableInstanceQuery().list();
        CaseServiceHumanTaskTest.assertTrue((boolean)result.isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn"})
    public void testCompleteWithRemoveVariableLocal() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariableLocal("aVariableName", (Object)"abc").setVariableLocal("anotherVariableName", (Object)999).manualStart();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)task);
        this.caseService.withCaseExecution(caseExecutionId).removeVariableLocal("aVariableName").removeVariableLocal("anotherVariableName").complete();
        task = (Task)this.taskService.createTaskQuery().singleResult();
        CaseServiceHumanTaskTest.assertNull((Object)task);
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        CaseServiceHumanTaskTest.assertNull((Object)caseExecution);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().active().singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)caseInstance);
        CaseServiceHumanTaskTest.assertTrue((boolean)caseInstance.isActive());
        List result = this.runtimeService.createVariableInstanceQuery().list();
        CaseServiceHumanTaskTest.assertTrue((boolean)result.isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testClose() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        try {
            this.caseService.withCaseExecution(caseExecutionId).close();
            CaseServiceHumanTaskTest.fail((String)"It should not be possible to close a task.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }
}

