/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.cmmn;

import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseExecutionQuery;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.test.Deployment;

public class CaseServiceStageTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCase.cmmn"})
    public void testManualStart() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_Stage_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).manualStart();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        CaseServiceStageTest.assertTrue((boolean)caseExecution.isActive());
        CaseServiceStageTest.assertFalse((boolean)caseExecution.isEnabled());
        CaseExecution firstHumanTask = (CaseExecution)caseExecutionQuery.activityId("PI_HumanTask_1").singleResult();
        CaseServiceStageTest.assertNotNull((Object)firstHumanTask);
        CaseServiceStageTest.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseServiceStageTest.assertFalse((boolean)firstHumanTask.isActive());
        CaseExecution secondHumanTask = (CaseExecution)caseExecutionQuery.activityId("PI_HumanTask_2").singleResult();
        CaseServiceStageTest.assertNotNull((Object)secondHumanTask);
        CaseServiceStageTest.assertTrue((boolean)secondHumanTask.isEnabled());
        CaseServiceStageTest.assertFalse((boolean)secondHumanTask.isActive());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCase.cmmn"})
    public void testManualStartWithVariable() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_Stage_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).manualStart();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        CaseServiceStageTest.assertTrue((boolean)caseExecution.isActive());
        CaseServiceStageTest.assertFalse((boolean)caseExecution.isEnabled());
        CaseExecution firstHumanTask = (CaseExecution)caseExecutionQuery.activityId("PI_HumanTask_1").singleResult();
        CaseServiceStageTest.assertNotNull((Object)firstHumanTask);
        CaseServiceStageTest.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseServiceStageTest.assertFalse((boolean)firstHumanTask.isActive());
        CaseExecution secondHumanTask = (CaseExecution)caseExecutionQuery.activityId("PI_HumanTask_2").singleResult();
        CaseServiceStageTest.assertNotNull((Object)secondHumanTask);
        CaseServiceStageTest.assertTrue((boolean)secondHumanTask.isEnabled());
        CaseServiceStageTest.assertFalse((boolean)secondHumanTask.isActive());
        List result = this.runtimeService.createVariableInstanceQuery().list();
        CaseServiceStageTest.assertFalse((boolean)result.isEmpty());
        CaseServiceStageTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceStageTest.assertEquals((String)caseInstanceId, (String)variable.getCaseExecutionId());
            CaseServiceStageTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceStageTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceStageTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceStageTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceStageTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseServiceStageTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCase.cmmn"})
    public void testManualWithVariables() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_Stage_1").singleResult()).getId();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "abc");
        variables.put("anotherVariableName", 999);
        this.caseService.withCaseExecution(caseExecutionId).setVariables(variables).manualStart();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        CaseServiceStageTest.assertTrue((boolean)caseExecution.isActive());
        CaseServiceStageTest.assertFalse((boolean)caseExecution.isEnabled());
        CaseExecution firstHumanTask = (CaseExecution)caseExecutionQuery.activityId("PI_HumanTask_1").singleResult();
        CaseServiceStageTest.assertNotNull((Object)firstHumanTask);
        CaseServiceStageTest.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseServiceStageTest.assertFalse((boolean)firstHumanTask.isActive());
        CaseExecution secondHumanTask = (CaseExecution)caseExecutionQuery.activityId("PI_HumanTask_2").singleResult();
        CaseServiceStageTest.assertNotNull((Object)secondHumanTask);
        CaseServiceStageTest.assertTrue((boolean)secondHumanTask.isEnabled());
        CaseServiceStageTest.assertFalse((boolean)secondHumanTask.isActive());
        List result = this.runtimeService.createVariableInstanceQuery().list();
        CaseServiceStageTest.assertFalse((boolean)result.isEmpty());
        CaseServiceStageTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceStageTest.assertEquals((String)caseInstanceId, (String)variable.getCaseExecutionId());
            CaseServiceStageTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceStageTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceStageTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceStageTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceStageTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseServiceStageTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCase.cmmn"})
    public void testManualStartWithLocalVariable() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_Stage_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariableLocal("aVariableName", (Object)"abc").setVariableLocal("anotherVariableName", (Object)999).manualStart();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        CaseServiceStageTest.assertTrue((boolean)caseExecution.isActive());
        CaseServiceStageTest.assertFalse((boolean)caseExecution.isEnabled());
        CaseExecution firstHumanTask = (CaseExecution)caseExecutionQuery.activityId("PI_HumanTask_1").singleResult();
        CaseServiceStageTest.assertNotNull((Object)firstHumanTask);
        CaseServiceStageTest.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseServiceStageTest.assertFalse((boolean)firstHumanTask.isActive());
        CaseExecution secondHumanTask = (CaseExecution)caseExecutionQuery.activityId("PI_HumanTask_2").singleResult();
        CaseServiceStageTest.assertNotNull((Object)secondHumanTask);
        CaseServiceStageTest.assertTrue((boolean)secondHumanTask.isEnabled());
        CaseServiceStageTest.assertFalse((boolean)secondHumanTask.isActive());
        List result = this.runtimeService.createVariableInstanceQuery().list();
        CaseServiceStageTest.assertFalse((boolean)result.isEmpty());
        CaseServiceStageTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceStageTest.assertEquals((String)caseExecutionId, (String)variable.getCaseExecutionId());
            CaseServiceStageTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceStageTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceStageTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceStageTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceStageTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseServiceStageTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCase.cmmn"})
    public void testManualStartWithLocalVariables() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_Stage_1").singleResult()).getId();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "abc");
        variables.put("anotherVariableName", 999);
        this.caseService.withCaseExecution(caseExecutionId).setVariablesLocal(variables).manualStart();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        CaseServiceStageTest.assertTrue((boolean)caseExecution.isActive());
        CaseServiceStageTest.assertFalse((boolean)caseExecution.isEnabled());
        CaseExecution firstHumanTask = (CaseExecution)caseExecutionQuery.activityId("PI_HumanTask_1").singleResult();
        CaseServiceStageTest.assertNotNull((Object)firstHumanTask);
        CaseServiceStageTest.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseServiceStageTest.assertFalse((boolean)firstHumanTask.isActive());
        CaseExecution secondHumanTask = (CaseExecution)caseExecutionQuery.activityId("PI_HumanTask_2").singleResult();
        CaseServiceStageTest.assertNotNull((Object)secondHumanTask);
        CaseServiceStageTest.assertTrue((boolean)secondHumanTask.isEnabled());
        CaseServiceStageTest.assertFalse((boolean)secondHumanTask.isActive());
        List result = this.runtimeService.createVariableInstanceQuery().list();
        CaseServiceStageTest.assertFalse((boolean)result.isEmpty());
        CaseServiceStageTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceStageTest.assertEquals((String)caseExecutionId, (String)variable.getCaseExecutionId());
            CaseServiceStageTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceStageTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceStageTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceStageTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceStageTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseServiceStageTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCase.cmmn"})
    public void testReenableAnEnabledStage() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult()).getId();
        try {
            this.caseService.withCaseExecution(caseExecutionId).reenable();
            CaseServiceStageTest.fail((String)"It should not be possible to re-enable an enabled stage.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskAndOneStageCase.cmmn"})
    public void testReenableAnDisabledStage() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_Stage_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).disable();
        this.caseService.withCaseExecution(caseExecutionId).reenable();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        CaseServiceStageTest.assertFalse((boolean)caseExecution.isDisabled());
        CaseServiceStageTest.assertFalse((boolean)caseExecution.isActive());
        CaseServiceStageTest.assertTrue((boolean)caseExecution.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCase.cmmn"})
    public void testReenableAnActiveStage() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).manualStart();
        try {
            this.caseService.withCaseExecution(caseExecutionId).reenable();
            CaseServiceStageTest.fail((String)"It should not be possible to re-enable an active human task.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskAndOneStageCase.cmmn"})
    public void testDisableAnEnabledStage() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_Stage_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).disable();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        CaseServiceStageTest.assertTrue((boolean)caseExecution.isDisabled());
        CaseServiceStageTest.assertFalse((boolean)caseExecution.isActive());
        CaseServiceStageTest.assertFalse((boolean)caseExecution.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskAndOneStageCase.cmmn"})
    public void testDisableADisabledStage() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_Stage_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).disable();
        try {
            this.caseService.withCaseExecution(caseExecutionId).disable();
            CaseServiceStageTest.fail((String)"It should not be possible to disable a already disabled human task.");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCase.cmmn"})
    public void testDisableAnActiveStage() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).manualStart();
        try {
            this.caseService.withCaseExecution(caseExecutionId).disable();
            CaseServiceStageTest.fail((String)"It should not be possible to disable an active human task.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskAndOneStageCase.cmmn"})
    public void testManualStartOfADisabledStage() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).disable();
        try {
            this.caseService.withCaseExecution(caseExecutionId).manualStart();
            CaseServiceStageTest.fail((String)"It should not be possible to start a disabled human task manually.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCase.cmmn"})
    public void testManualStartOfAnActiveStage() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).manualStart();
        try {
            this.caseService.withCaseExecution(caseExecutionId).manualStart();
            CaseServiceStageTest.fail((String)"It should not be possible to start an already active human task manually.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCase.cmmn"})
    public void testDisableShouldCompleteCaseInstance() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).disable();
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult();
        CaseServiceStageTest.assertNull((Object)caseExecution);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().completed().singleResult();
        CaseServiceStageTest.assertNotNull((Object)caseInstance);
        CaseServiceStageTest.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCase.cmmn"})
    public void testCompleteShouldCompleteCaseInstance() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).manualStart();
        this.caseService.withCaseExecution(caseExecutionId).complete();
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        CaseServiceStageTest.assertNull((Object)caseExecution);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().completed().singleResult();
        CaseServiceStageTest.assertNotNull((Object)caseInstance);
        CaseServiceStageTest.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskAndOneStageCase.cmmn"})
    public void testComplete() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).manualStart();
        this.caseService.withCaseExecution(caseExecutionId).complete();
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult();
        CaseServiceStageTest.assertNull((Object)caseExecution);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().active().singleResult();
        CaseServiceStageTest.assertNotNull((Object)caseInstance);
        CaseServiceStageTest.assertTrue((boolean)caseInstance.isActive());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCase.cmmn"})
    public void testCompleteEnabledStage() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult()).getId();
        try {
            this.caseService.withCaseExecution(caseExecutionId).complete();
            CaseServiceStageTest.fail((String)"Should not be able to complete stage.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskAndOneStageCase.cmmn"})
    public void testCompleteDisabledStage() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).disable();
        try {
            this.caseService.withCaseExecution(caseExecutionId).complete();
            CaseServiceStageTest.fail((String)"Should not be able to complete stage.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/emptyStageCase.cmmn"})
    public void testAutoCompletionOfEmptyStage() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).manualStart();
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult();
        CaseServiceStageTest.assertNull((Object)caseExecution);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().completed().singleResult();
        CaseServiceStageTest.assertNotNull((Object)caseInstance);
        CaseServiceStageTest.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCase.cmmn"})
    public void testClose() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult()).getId();
        try {
            this.caseService.withCaseExecution(caseExecutionId).close();
            CaseServiceStageTest.fail((String)"It should not be possible to close a stage.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }
}

