/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.form.FormProperty;
import org.camunda.bpm.engine.form.StartFormData;
import org.camunda.bpm.engine.form.TaskFormData;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.CollectionUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.form.Address;

public class FormServiceTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/examples/taskforms/VacationRequest_deprecated_forms.bpmn20.xml", "org/camunda/bpm/engine/test/examples/taskforms/approve.form", "org/camunda/bpm/engine/test/examples/taskforms/request.form", "org/camunda/bpm/engine/test/examples/taskforms/adjustRequest.form"})
    public void testGetStartFormByProcessDefinitionId() {
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        FormServiceTest.assertEquals((int)1, (int)processDefinitions.size());
        ProcessDefinition processDefinition = (ProcessDefinition)processDefinitions.get(0);
        Object startForm = this.formService.getRenderedStartForm(processDefinition.getId(), "juel");
        FormServiceTest.assertNotNull((Object)startForm);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testGetStartFormByProcessDefinitionIdWithoutStartform() {
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        FormServiceTest.assertEquals((int)1, (int)processDefinitions.size());
        ProcessDefinition processDefinition = (ProcessDefinition)processDefinitions.get(0);
        Object startForm = this.formService.getRenderedStartForm(processDefinition.getId());
        FormServiceTest.assertNull((Object)startForm);
    }

    public void testGetStartFormByKeyNullKey() {
        try {
            this.formService.getRenderedStartForm(null);
            FormServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testGetStartFormByIdNullId() {
        try {
            this.formService.getRenderedStartForm(null);
            FormServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testGetStartFormByIdUnexistingProcessDefinitionId() {
        try {
            this.formService.getRenderedStartForm("unexistingId");
            FormServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("no deployed process definition found with id", ae.getMessage());
        }
    }

    public void testGetTaskFormNullTaskId() {
        try {
            this.formService.getRenderedTaskForm(null);
            FormServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testGetTaskFormUnexistingTaskId() {
        try {
            this.formService.getRenderedTaskForm("unexistingtask");
            FormServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("Task 'unexistingtask' not found", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/form/FormsProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/form/start.form", "org/camunda/bpm/engine/test/api/form/task.form"})
    public void testTaskFormPropertyDefaultsAndFormRendering() {
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        StartFormData startForm = this.formService.getStartFormData(procDefId);
        FormServiceTest.assertNotNull((Object)startForm);
        FormServiceTest.assertEquals((String)this.deploymentId, (String)startForm.getDeploymentId());
        FormServiceTest.assertEquals((String)"org/camunda/bpm/engine/test/api/form/start.form", (String)startForm.getFormKey());
        FormServiceTest.assertEquals(new ArrayList(), (Object)startForm.getFormProperties());
        FormServiceTest.assertEquals((String)procDefId, (String)startForm.getProcessDefinition().getId());
        Object renderedStartForm = this.formService.getRenderedStartForm(procDefId, "juel");
        FormServiceTest.assertEquals((Object)"start form content", (Object)renderedStartForm);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("room", "5b");
        properties.put("speaker", "Mike");
        String processInstanceId = this.formService.submitStartFormData(procDefId, properties).getId();
        HashMap<String, String> expectedVariables = new HashMap<String, String>();
        expectedVariables.put("room", "5b");
        expectedVariables.put("speaker", "Mike");
        Map variables = this.runtimeService.getVariables(processInstanceId);
        FormServiceTest.assertEquals(expectedVariables, (Object)variables);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        String taskId = task.getId();
        TaskFormData taskForm = this.formService.getTaskFormData(taskId);
        FormServiceTest.assertEquals((String)this.deploymentId, (String)taskForm.getDeploymentId());
        FormServiceTest.assertEquals((String)"org/camunda/bpm/engine/test/api/form/task.form", (String)taskForm.getFormKey());
        FormServiceTest.assertEquals(new ArrayList(), (Object)taskForm.getFormProperties());
        FormServiceTest.assertEquals((String)taskId, (String)taskForm.getTask().getId());
        FormServiceTest.assertEquals((Object)"Mike is speaking in room 5b", (Object)this.formService.getRenderedTaskForm(taskId, "juel"));
        properties = new HashMap();
        properties.put("room", "3f");
        this.formService.submitTaskFormData(taskId, properties);
        expectedVariables = new HashMap();
        expectedVariables.put("room", "3f");
        expectedVariables.put("speaker", "Mike");
        variables = this.runtimeService.getVariables(processInstanceId);
        FormServiceTest.assertEquals(expectedVariables, (Object)variables);
    }

    @Deployment
    public void testFormPropertyHandlingDeprecated() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("room", "5b");
        properties.put("speaker", "Mike");
        properties.put("duration", "45");
        properties.put("free", "true");
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        String processInstanceId = this.formService.submitStartFormData(procDefId, properties).getId();
        HashMap<String, Object> expectedVariables = new HashMap<String, Object>();
        expectedVariables.put("room", "5b");
        expectedVariables.put("SpeakerName", "Mike");
        expectedVariables.put("duration", new Long(45L));
        expectedVariables.put("free", Boolean.TRUE);
        Map variables = this.runtimeService.getVariables(processInstanceId);
        FormServiceTest.assertEquals(expectedVariables, (Object)variables);
        Address address = new Address();
        address.setStreet("broadway");
        this.runtimeService.setVariable(processInstanceId, "address", (Object)address);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        TaskFormData taskFormData = this.formService.getTaskFormData(taskId);
        List formProperties = taskFormData.getFormProperties();
        FormProperty propertyRoom = (FormProperty)formProperties.get(0);
        FormServiceTest.assertEquals((String)"room", (String)propertyRoom.getId());
        FormServiceTest.assertEquals((String)"5b", (String)propertyRoom.getValue());
        FormProperty propertyDuration = (FormProperty)formProperties.get(1);
        FormServiceTest.assertEquals((String)"duration", (String)propertyDuration.getId());
        FormServiceTest.assertEquals((String)"45", (String)propertyDuration.getValue());
        FormProperty propertySpeaker = (FormProperty)formProperties.get(2);
        FormServiceTest.assertEquals((String)"speaker", (String)propertySpeaker.getId());
        FormServiceTest.assertEquals((String)"Mike", (String)propertySpeaker.getValue());
        FormProperty propertyStreet = (FormProperty)formProperties.get(3);
        FormServiceTest.assertEquals((String)"street", (String)propertyStreet.getId());
        FormServiceTest.assertEquals((String)"broadway", (String)propertyStreet.getValue());
        FormProperty propertyFree = (FormProperty)formProperties.get(4);
        FormServiceTest.assertEquals((String)"free", (String)propertyFree.getId());
        FormServiceTest.assertEquals((String)"true", (String)propertyFree.getValue());
        FormServiceTest.assertEquals((int)5, (int)formProperties.size());
        try {
            this.formService.submitTaskFormData(taskId, new HashMap());
            FormServiceTest.fail((String)"expected exception about required form property 'street'");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            properties = new HashMap();
            properties.put("speaker", "its not allowed to update speaker!");
            this.formService.submitTaskFormData(taskId, properties);
            FormServiceTest.fail((String)"expected exception about a non writable form property 'speaker'");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        properties = new HashMap();
        properties.put("street", "rubensstraat");
        this.formService.submitTaskFormData(taskId, properties);
        expectedVariables = new HashMap();
        expectedVariables.put("room", "5b");
        expectedVariables.put("SpeakerName", "Mike");
        expectedVariables.put("duration", new Long(45L));
        expectedVariables.put("free", Boolean.TRUE);
        variables = this.runtimeService.getVariables(processInstanceId);
        address = (Address)variables.remove("address");
        FormServiceTest.assertEquals((String)"rubensstraat", (String)address.getStreet());
        FormServiceTest.assertEquals(expectedVariables, (Object)variables);
    }

    @Deployment
    public void testFormPropertyHandling() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("room", "5b");
        properties.put("speaker", "Mike");
        properties.put("duration", 45L);
        properties.put("free", "true");
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        String processInstanceId = this.formService.submitStartForm(procDefId, properties).getId();
        HashMap<String, Object> expectedVariables = new HashMap<String, Object>();
        expectedVariables.put("room", "5b");
        expectedVariables.put("SpeakerName", "Mike");
        expectedVariables.put("duration", new Long(45L));
        expectedVariables.put("free", Boolean.TRUE);
        Map variables = this.runtimeService.getVariables(processInstanceId);
        FormServiceTest.assertEquals(expectedVariables, (Object)variables);
        Address address = new Address();
        address.setStreet("broadway");
        this.runtimeService.setVariable(processInstanceId, "address", (Object)address);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        TaskFormData taskFormData = this.formService.getTaskFormData(taskId);
        List formProperties = taskFormData.getFormProperties();
        FormProperty propertyRoom = (FormProperty)formProperties.get(0);
        FormServiceTest.assertEquals((String)"room", (String)propertyRoom.getId());
        FormServiceTest.assertEquals((String)"5b", (String)propertyRoom.getValue());
        FormProperty propertyDuration = (FormProperty)formProperties.get(1);
        FormServiceTest.assertEquals((String)"duration", (String)propertyDuration.getId());
        FormServiceTest.assertEquals((String)"45", (String)propertyDuration.getValue());
        FormProperty propertySpeaker = (FormProperty)formProperties.get(2);
        FormServiceTest.assertEquals((String)"speaker", (String)propertySpeaker.getId());
        FormServiceTest.assertEquals((String)"Mike", (String)propertySpeaker.getValue());
        FormProperty propertyStreet = (FormProperty)formProperties.get(3);
        FormServiceTest.assertEquals((String)"street", (String)propertyStreet.getId());
        FormServiceTest.assertEquals((String)"broadway", (String)propertyStreet.getValue());
        FormProperty propertyFree = (FormProperty)formProperties.get(4);
        FormServiceTest.assertEquals((String)"free", (String)propertyFree.getId());
        FormServiceTest.assertEquals((String)"true", (String)propertyFree.getValue());
        FormServiceTest.assertEquals((int)5, (int)formProperties.size());
        try {
            this.formService.submitTaskForm(taskId, new HashMap());
            FormServiceTest.fail((String)"expected exception about required form property 'street'");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            properties = new HashMap();
            properties.put("speaker", "its not allowed to update speaker!");
            this.formService.submitTaskForm(taskId, properties);
            FormServiceTest.fail((String)"expected exception about a non writable form property 'speaker'");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        properties = new HashMap();
        properties.put("street", "rubensstraat");
        this.formService.submitTaskForm(taskId, properties);
        expectedVariables = new HashMap();
        expectedVariables.put("room", "5b");
        expectedVariables.put("SpeakerName", "Mike");
        expectedVariables.put("duration", new Long(45L));
        expectedVariables.put("free", Boolean.TRUE);
        variables = this.runtimeService.getVariables(processInstanceId);
        address = (Address)variables.remove("address");
        FormServiceTest.assertEquals((String)"rubensstraat", (String)address.getStreet());
        FormServiceTest.assertEquals(expectedVariables, (Object)variables);
    }

    @Deployment
    public void testFormPropertyDetails() {
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        StartFormData startFormData = this.formService.getStartFormData(procDefId);
        FormProperty property = (FormProperty)startFormData.getFormProperties().get(0);
        FormServiceTest.assertEquals((String)"speaker", (String)property.getId());
        FormServiceTest.assertNull((Object)property.getValue());
        FormServiceTest.assertTrue((boolean)property.isReadable());
        FormServiceTest.assertTrue((boolean)property.isWritable());
        FormServiceTest.assertFalse((boolean)property.isRequired());
        FormServiceTest.assertEquals((String)"string", (String)property.getType().getName());
        property = (FormProperty)startFormData.getFormProperties().get(1);
        FormServiceTest.assertEquals((String)"start", (String)property.getId());
        FormServiceTest.assertNull((Object)property.getValue());
        FormServiceTest.assertTrue((boolean)property.isReadable());
        FormServiceTest.assertTrue((boolean)property.isWritable());
        FormServiceTest.assertFalse((boolean)property.isRequired());
        FormServiceTest.assertEquals((String)"date", (String)property.getType().getName());
        FormServiceTest.assertEquals((Object)"dd-MMM-yyyy", (Object)property.getType().getInformation("datePattern"));
        property = (FormProperty)startFormData.getFormProperties().get(2);
        FormServiceTest.assertEquals((String)"direction", (String)property.getId());
        FormServiceTest.assertNull((Object)property.getValue());
        FormServiceTest.assertTrue((boolean)property.isReadable());
        FormServiceTest.assertTrue((boolean)property.isWritable());
        FormServiceTest.assertFalse((boolean)property.isRequired());
        FormServiceTest.assertEquals((String)"enum", (String)property.getType().getName());
        Map values = (Map)property.getType().getInformation("values");
        LinkedHashMap<String, String> expectedValues = new LinkedHashMap<String, String>();
        expectedValues.put("left", "Go Left");
        expectedValues.put("right", "Go Right");
        expectedValues.put("up", "Go Up");
        expectedValues.put("down", "Go Down");
        Iterator expectedValuesIterator = expectedValues.entrySet().iterator();
        for (Map.Entry entry : values.entrySet()) {
            Map.Entry expectedEntryAtLocation = expectedValuesIterator.next();
            FormServiceTest.assertEquals((String)((String)expectedEntryAtLocation.getKey()), (String)((String)entry.getKey()));
            FormServiceTest.assertEquals((String)((String)expectedEntryAtLocation.getValue()), (String)((String)entry.getValue()));
        }
        FormServiceTest.assertEquals(expectedValues, (Object)values);
    }

    @Deployment
    public void testInvalidFormKeyReference() {
        try {
            this.formService.getRenderedStartForm(((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId(), "juel");
            FormServiceTest.fail();
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Form with formKey 'IDoNotExist' does not exist", e.getMessage());
        }
    }

    @Deployment
    public void testSubmitStartFormDataWithBusinessKey() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("duration", "45");
        properties.put("speaker", "Mike");
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        ProcessInstance processInstance = this.formService.submitStartFormData(procDefId, "123", properties);
        FormServiceTest.assertEquals((String)"123", (String)processInstance.getBusinessKey());
        FormServiceTest.assertEquals((String)processInstance.getId(), (String)((ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey("123").singleResult()).getId());
    }

    @Deployment
    public void testSubmitStartFormWithBusinessKey() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("duration", 45L);
        properties.put("speaker", "Mike");
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        ProcessInstance processInstance = this.formService.submitStartForm(procDefId, "123", properties);
        FormServiceTest.assertEquals((String)"123", (String)processInstance.getBusinessKey());
        FormServiceTest.assertEquals((String)processInstance.getId(), (String)((ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey("123").singleResult()).getId());
        Map variables = this.runtimeService.getVariables(processInstance.getId());
        FormServiceTest.assertEquals((Object)"Mike", variables.get("SpeakerName"));
        FormServiceTest.assertEquals((Object)45L, variables.get("duration"));
    }

    @Deployment
    public void testSubmitStartFormWithoutProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("duration", 45L);
        properties.put("speaker", "Mike");
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        ProcessInstance processInstance = this.formService.submitStartForm(procDefId, "123", properties);
        FormServiceTest.assertEquals((String)"123", (String)processInstance.getBusinessKey());
        FormServiceTest.assertEquals((String)processInstance.getId(), (String)((ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey("123").singleResult()).getId());
        Map variables = this.runtimeService.getVariables(processInstance.getId());
        FormServiceTest.assertEquals((Object)"Mike", variables.get("speaker"));
        FormServiceTest.assertEquals((Object)45L, variables.get("duration"));
    }

    public void testGetStartFormKeyEmptyArgument() {
        try {
            this.formService.getStartFormKey(null);
            FormServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("The process definition id is mandatory, but 'null' has been provided.", ae.getMessage());
        }
        try {
            this.formService.getStartFormKey("");
            FormServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("The process definition id is mandatory, but '' has been provided.", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/form/FormsProcess.bpmn20.xml"})
    public void testGetStartFormKey() {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        String expectedFormKey = this.formService.getStartFormData(processDefinitionId).getFormKey();
        String actualFormKey = this.formService.getStartFormKey(processDefinitionId);
        FormServiceTest.assertEquals((String)expectedFormKey, (String)actualFormKey);
    }

    public void testGetTaskFormKeyEmptyArguments() {
        try {
            this.formService.getTaskFormKey(null, "23");
            FormServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("The process definition id is mandatory, but 'null' has been provided.", ae.getMessage());
        }
        try {
            this.formService.getTaskFormKey("", "23");
            FormServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("The process definition id is mandatory, but '' has been provided.", ae.getMessage());
        }
        try {
            this.formService.getTaskFormKey("42", null);
            FormServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("The task definition key is mandatory, but 'null' has been provided.", ae.getMessage());
        }
        try {
            this.formService.getTaskFormKey("42", "");
            FormServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("The task definition key is mandatory, but '' has been provided.", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/form/FormsProcess.bpmn20.xml"})
    public void testGetTaskFormKey() {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        this.runtimeService.startProcessInstanceById(processDefinitionId);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        FormServiceTest.assertNotNull((Object)task);
        String expectedFormKey = this.formService.getTaskFormData(task.getId()).getFormKey();
        String actualFormKey = this.formService.getTaskFormKey(task.getProcessDefinitionId(), task.getTaskDefinitionKey());
        FormServiceTest.assertEquals((String)expectedFormKey, (String)actualFormKey);
    }

    @Deployment
    public void testGetTaskFormKeyWithExpression() {
        this.runtimeService.startProcessInstanceByKey("FormsProcess", CollectionUtil.singletonMap((String)"dynamicKey", (Object)"test"));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        FormServiceTest.assertNotNull((Object)task);
        FormServiceTest.assertEquals((String)"test", (String)this.formService.getTaskFormData(task.getId()).getFormKey());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/form/FormServiceTest.startFormFields.bpmn20.xml"})
    public void testGetStartFormVariables() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        Map variables = this.formService.getStartFormVariables(processDefinition.getId());
        FormServiceTest.assertEquals((int)4, (int)variables.size());
        VariableInstance variable = (VariableInstance)variables.get("stringField");
        FormServiceTest.assertEquals((Object)"someString", (Object)variable.getValue());
        FormServiceTest.assertEquals((String)"string", (String)variable.getTypeName());
        variable = (VariableInstance)variables.get("longField");
        FormServiceTest.assertEquals((Object)5L, (Object)variable.getValue());
        FormServiceTest.assertEquals((String)"long", (String)variable.getTypeName());
        variable = (VariableInstance)variables.get("customField");
        FormServiceTest.assertNull((Object)variable.getValue());
        FormServiceTest.assertEquals((String)"string", (String)variable.getTypeName());
        variable = (VariableInstance)variables.get("dateField");
        FormServiceTest.assertNotNull((Object)variable.getValue());
        FormServiceTest.assertEquals((String)"date", (String)variable.getTypeName());
        Date dateValue = (Date)variable.getValue();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateValue);
        FormServiceTest.assertEquals((int)10, (int)calendar.get(5));
        FormServiceTest.assertEquals((int)0, (int)calendar.get(2));
        FormServiceTest.assertEquals((int)2013, (int)calendar.get(1));
        variables = this.formService.getStartFormVariables(processDefinition.getId(), Arrays.asList("stringField"));
        FormServiceTest.assertEquals((int)1, (int)variables.size());
        variable = (VariableInstance)variables.get("stringField");
        FormServiceTest.assertEquals((Object)"someString", (Object)variable.getValue());
        FormServiceTest.assertEquals((String)"string", (String)variable.getTypeName());
        variables = this.formService.getStartFormVariables(processDefinition.getId(), Arrays.asList("non-existing!"));
        FormServiceTest.assertEquals((int)0, (int)variables.size());
        variables = this.formService.getStartFormVariables(processDefinition.getId(), null);
        FormServiceTest.assertEquals((int)4, (int)variables.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/form/FormServiceTest.startFormFieldsUnknownType.bpmn20.xml"})
    public void testGetStartFormVariablesUnknownType() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        try {
            this.formService.getStartFormVariables(processDefinition.getId());
            FormServiceTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Unsupported variable type 'enum'", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/form/FormServiceTest.taskFormFields.bpmn20.xml"})
    public void testGetTaskFormVariables() {
        HashMap<String, Object> processVars = new HashMap<String, Object>();
        processVars.put("someString", "initialValue");
        processVars.put("initialBooleanVariable", true);
        processVars.put("initialLongVariable", 1L);
        this.runtimeService.startProcessInstanceByKey("testProcess", processVars);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Map variables = this.formService.getTaskFormVariables(task.getId());
        FormServiceTest.assertEquals((int)6, (int)variables.size());
        VariableInstance variable = (VariableInstance)variables.get("stringField");
        FormServiceTest.assertEquals((Object)"someString", (Object)variable.getValue());
        FormServiceTest.assertEquals((String)"string", (String)variable.getTypeName());
        variable = (VariableInstance)variables.get("longField");
        FormServiceTest.assertEquals((Object)5L, (Object)variable.getValue());
        FormServiceTest.assertEquals((String)"long", (String)variable.getTypeName());
        variable = (VariableInstance)variables.get("customField");
        FormServiceTest.assertNull((Object)variable.getValue());
        FormServiceTest.assertEquals((String)"string", (String)variable.getTypeName());
        variable = (VariableInstance)variables.get("someString");
        FormServiceTest.assertEquals((Object)"initialValue", (Object)variable.getValue());
        FormServiceTest.assertEquals((String)"string", (String)variable.getTypeName());
        variable = (VariableInstance)variables.get("initialBooleanVariable");
        FormServiceTest.assertEquals((Object)true, (Object)variable.getValue());
        FormServiceTest.assertEquals((String)"boolean", (String)variable.getTypeName());
        variable = (VariableInstance)variables.get("initialLongVariable");
        FormServiceTest.assertEquals((Object)1L, (Object)variable.getValue());
        FormServiceTest.assertEquals((String)"long", (String)variable.getTypeName());
        this.taskService.setVariableLocal(task.getId(), "initialLongVariable", (Object)2L);
        variables = this.formService.getTaskFormVariables(task.getId());
        FormServiceTest.assertEquals((int)6, (int)variables.size());
        variable = (VariableInstance)variables.get("initialLongVariable");
        FormServiceTest.assertEquals((Object)2L, (Object)variable.getValue());
        FormServiceTest.assertEquals((String)"long", (String)variable.getTypeName());
        variables = this.formService.getTaskFormVariables(task.getId(), Arrays.asList("someString"));
        FormServiceTest.assertEquals((int)1, (int)variables.size());
        variable = (VariableInstance)variables.get("someString");
        FormServiceTest.assertEquals((Object)"initialValue", (Object)variable.getValue());
        FormServiceTest.assertEquals((String)"string", (String)variable.getTypeName());
        variables = this.formService.getTaskFormVariables(task.getId(), Arrays.asList("initialBooleanVariable"));
        FormServiceTest.assertEquals((int)1, (int)variables.size());
        variable = (VariableInstance)variables.get("initialBooleanVariable");
        FormServiceTest.assertEquals((Object)true, (Object)variable.getValue());
        FormServiceTest.assertEquals((String)"boolean", (String)variable.getTypeName());
        variables = this.formService.getTaskFormVariables(task.getId(), Arrays.asList("non-existing!"));
        FormServiceTest.assertEquals((int)0, (int)variables.size());
        variables = this.formService.getTaskFormVariables(task.getId(), null);
        FormServiceTest.assertEquals((int)6, (int)variables.size());
    }
}

