/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.identity;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.persistence.entity.GroupEntity;
import org.camunda.bpm.engine.impl.persistence.entity.UserEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.junit.Assert;

public class IdentityServiceAuthorizationsTest
extends PluggableProcessEngineTestCase {
    private static final String jonny2 = "jonny2";

    protected void tearDown() throws Exception {
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        this.cleanupAfterTest();
        super.tearDown();
    }

    public void testUserCreateAuthorizations() {
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.USER);
        basePerms.setResourceId("*");
        basePerms.addPermission((Permission)Permissions.ALL);
        basePerms.removePermission((Permission)Permissions.CREATE);
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.identityService.setAuthenticatedUserId(jonny2);
        try {
            this.identityService.newUser("jonny1");
            IdentityServiceAuthorizationsTest.fail((String)"exception expected");
        }
        catch (AuthorizationException e) {
            IdentityServiceAuthorizationsTest.assertEquals((String)Permissions.CREATE.getName(), (String)e.getViolatedPermissionName());
            IdentityServiceAuthorizationsTest.assertEquals((String)jonny2, (String)e.getUserId());
            IdentityServiceAuthorizationsTest.assertEquals((String)Resources.USER.resourceName(), (String)e.getResourceType());
            IdentityServiceAuthorizationsTest.assertEquals(null, (String)e.getResourceId());
        }
        UserEntity newUser = new UserEntity("jonny1");
        try {
            this.identityService.saveUser((User)newUser);
            IdentityServiceAuthorizationsTest.fail((String)"exception expected");
        }
        catch (AuthorizationException e) {
            IdentityServiceAuthorizationsTest.assertEquals((String)Permissions.CREATE.getName(), (String)e.getViolatedPermissionName());
            IdentityServiceAuthorizationsTest.assertEquals((String)jonny2, (String)e.getUserId());
            IdentityServiceAuthorizationsTest.assertEquals((String)Resources.USER.resourceName(), (String)e.getResourceType());
            IdentityServiceAuthorizationsTest.assertEquals(null, (String)e.getResourceId());
        }
    }

    public void testUserDeleteAuthorizations() {
        User jonny1 = this.identityService.newUser("jonny1");
        this.identityService.saveUser(jonny1);
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.USER);
        basePerms.setResourceId("*");
        basePerms.addPermission((Permission)Permissions.ALL);
        basePerms.removePermission((Permission)Permissions.DELETE);
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.identityService.setAuthenticatedUserId(jonny2);
        try {
            this.identityService.deleteUser("jonny1");
            IdentityServiceAuthorizationsTest.fail((String)"exception expected");
        }
        catch (AuthorizationException e) {
            IdentityServiceAuthorizationsTest.assertEquals((String)Permissions.DELETE.getName(), (String)e.getViolatedPermissionName());
            IdentityServiceAuthorizationsTest.assertEquals((String)jonny2, (String)e.getUserId());
            IdentityServiceAuthorizationsTest.assertEquals((String)Resources.USER.resourceName(), (String)e.getResourceType());
            IdentityServiceAuthorizationsTest.assertEquals((String)"jonny1", (String)e.getResourceId());
        }
    }

    public void testUserUpdateAuthorizations() {
        User jonny1 = this.identityService.newUser("jonny1");
        this.identityService.saveUser(jonny1);
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.USER);
        basePerms.setResourceId("*");
        basePerms.addPermission((Permission)Permissions.ALL);
        basePerms.removePermission((Permission)Permissions.UPDATE);
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.identityService.setAuthenticatedUserId(jonny2);
        jonny1 = (User)this.identityService.createUserQuery().singleResult();
        jonny1.setFirstName("Jonny");
        try {
            this.identityService.saveUser(jonny1);
            IdentityServiceAuthorizationsTest.fail((String)"exception expected");
        }
        catch (AuthorizationException e) {
            IdentityServiceAuthorizationsTest.assertEquals((String)Permissions.UPDATE.getName(), (String)e.getViolatedPermissionName());
            IdentityServiceAuthorizationsTest.assertEquals((String)jonny2, (String)e.getUserId());
            IdentityServiceAuthorizationsTest.assertEquals((String)Resources.USER.resourceName(), (String)e.getResourceType());
            IdentityServiceAuthorizationsTest.assertEquals((String)"jonny1", (String)e.getResourceId());
        }
        User jonny3 = this.identityService.newUser("jonny3");
        this.identityService.saveUser(jonny3);
    }

    public void testGroupCreateAuthorizations() {
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.GROUP);
        basePerms.setResourceId("*");
        basePerms.addPermission((Permission)Permissions.ALL);
        basePerms.removePermission((Permission)Permissions.CREATE);
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.identityService.setAuthenticatedUserId(jonny2);
        try {
            this.identityService.newGroup("group1");
            IdentityServiceAuthorizationsTest.fail((String)"exception expected");
        }
        catch (AuthorizationException e) {
            IdentityServiceAuthorizationsTest.assertEquals((String)Permissions.CREATE.getName(), (String)e.getViolatedPermissionName());
            IdentityServiceAuthorizationsTest.assertEquals((String)jonny2, (String)e.getUserId());
            IdentityServiceAuthorizationsTest.assertEquals((String)Resources.GROUP.resourceName(), (String)e.getResourceType());
            IdentityServiceAuthorizationsTest.assertEquals(null, (String)e.getResourceId());
        }
        GroupEntity group = new GroupEntity("group1");
        try {
            this.identityService.saveGroup((Group)group);
            IdentityServiceAuthorizationsTest.fail((String)"exception expected");
        }
        catch (AuthorizationException e) {
            IdentityServiceAuthorizationsTest.assertEquals((String)Permissions.CREATE.getName(), (String)e.getViolatedPermissionName());
            IdentityServiceAuthorizationsTest.assertEquals((String)jonny2, (String)e.getUserId());
            IdentityServiceAuthorizationsTest.assertEquals((String)Resources.GROUP.resourceName(), (String)e.getResourceType());
            IdentityServiceAuthorizationsTest.assertEquals(null, (String)e.getResourceId());
        }
    }

    public void testGroupDeleteAuthorizations() {
        Group group1 = this.identityService.newGroup("group1");
        this.identityService.saveGroup(group1);
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.GROUP);
        basePerms.setResourceId("*");
        basePerms.addPermission((Permission)Permissions.ALL);
        basePerms.removePermission((Permission)Permissions.DELETE);
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.identityService.setAuthenticatedUserId(jonny2);
        try {
            this.identityService.deleteGroup("group1");
            IdentityServiceAuthorizationsTest.fail((String)"exception expected");
        }
        catch (AuthorizationException e) {
            IdentityServiceAuthorizationsTest.assertEquals((String)Permissions.DELETE.getName(), (String)e.getViolatedPermissionName());
            IdentityServiceAuthorizationsTest.assertEquals((String)jonny2, (String)e.getUserId());
            IdentityServiceAuthorizationsTest.assertEquals((String)Resources.GROUP.resourceName(), (String)e.getResourceType());
            IdentityServiceAuthorizationsTest.assertEquals((String)"group1", (String)e.getResourceId());
        }
    }

    public void testGroupUpdateAuthorizations() {
        Group group1 = this.identityService.newGroup("group1");
        this.identityService.saveGroup(group1);
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.GROUP);
        basePerms.setResourceId("*");
        basePerms.addPermission((Permission)Permissions.ALL);
        basePerms.removePermission((Permission)Permissions.UPDATE);
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.identityService.setAuthenticatedUserId(jonny2);
        group1 = (Group)this.identityService.createGroupQuery().singleResult();
        group1.setName("Group 1");
        try {
            this.identityService.saveGroup(group1);
            IdentityServiceAuthorizationsTest.fail((String)"exception expected");
        }
        catch (AuthorizationException e) {
            IdentityServiceAuthorizationsTest.assertEquals((String)Permissions.UPDATE.getName(), (String)e.getViolatedPermissionName());
            IdentityServiceAuthorizationsTest.assertEquals((String)jonny2, (String)e.getUserId());
            IdentityServiceAuthorizationsTest.assertEquals((String)Resources.GROUP.resourceName(), (String)e.getResourceType());
            IdentityServiceAuthorizationsTest.assertEquals((String)"group1", (String)e.getResourceId());
        }
        Group group2 = this.identityService.newGroup("group2");
        this.identityService.saveGroup(group2);
    }

    public void testMembershipCreateAuthorizations() {
        User jonny1 = this.identityService.newUser("jonny1");
        this.identityService.saveUser(jonny1);
        Group group1 = this.identityService.newGroup("group1");
        this.identityService.saveGroup(group1);
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.GROUP_MEMBERSHIP);
        basePerms.setResourceId("*");
        basePerms.addPermission((Permission)Permissions.ALL);
        basePerms.removePermission((Permission)Permissions.CREATE);
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.identityService.setAuthenticatedUserId(jonny2);
        try {
            this.identityService.createMembership("jonny1", "group1");
            IdentityServiceAuthorizationsTest.fail((String)"exception expected");
        }
        catch (AuthorizationException e) {
            IdentityServiceAuthorizationsTest.assertEquals((String)Permissions.CREATE.getName(), (String)e.getViolatedPermissionName());
            IdentityServiceAuthorizationsTest.assertEquals((String)jonny2, (String)e.getUserId());
            IdentityServiceAuthorizationsTest.assertEquals((String)Resources.GROUP_MEMBERSHIP.resourceName(), (String)e.getResourceType());
            IdentityServiceAuthorizationsTest.assertEquals((String)"group1", (String)e.getResourceId());
        }
    }

    public void testMembershipDeleteAuthorizations() {
        User jonny1 = this.identityService.newUser("jonny1");
        this.identityService.saveUser(jonny1);
        Group group1 = this.identityService.newGroup("group1");
        this.identityService.saveGroup(group1);
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.GROUP_MEMBERSHIP);
        basePerms.setResourceId("*");
        basePerms.addPermission((Permission)Permissions.ALL);
        basePerms.removePermission((Permission)Permissions.DELETE);
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.identityService.setAuthenticatedUserId(jonny2);
        try {
            this.identityService.deleteMembership("jonny1", "group1");
            IdentityServiceAuthorizationsTest.fail((String)"exception expected");
        }
        catch (AuthorizationException e) {
            IdentityServiceAuthorizationsTest.assertEquals((String)Permissions.DELETE.getName(), (String)e.getViolatedPermissionName());
            IdentityServiceAuthorizationsTest.assertEquals((String)jonny2, (String)e.getUserId());
            IdentityServiceAuthorizationsTest.assertEquals((String)Resources.GROUP_MEMBERSHIP.resourceName(), (String)e.getResourceType());
            IdentityServiceAuthorizationsTest.assertEquals((String)"group1", (String)e.getResourceId());
        }
    }

    public void testUserQueryAuthorizations() {
        String authUserId = jonny2;
        this.identityService.setAuthenticatedUserId(authUserId);
        User jonny1 = this.identityService.newUser("jonny1");
        this.identityService.saveUser(jonny1);
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.USER);
        basePerms.setResourceId("*");
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        IdentityServiceAuthorizationsTest.assertNull((Object)this.identityService.createUserQuery().singleResult());
        IdentityServiceAuthorizationsTest.assertEquals((long)0L, (long)this.identityService.createUserQuery().count());
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        Authorization ourPerms = this.authorizationService.createNewAuthorization(1);
        ourPerms.setUserId(authUserId);
        ourPerms.setResource((Resource)Resources.USER);
        ourPerms.setResourceId("*");
        ourPerms.addPermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(ourPerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        IdentityServiceAuthorizationsTest.assertNotNull((Object)this.identityService.createUserQuery().singleResult());
        IdentityServiceAuthorizationsTest.assertEquals((long)1L, (long)this.identityService.createUserQuery().count());
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        basePerms = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.USER).userIdIn(new String[]{"*"}).singleResult();
        basePerms.addPermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        IdentityServiceAuthorizationsTest.assertNotNull((Object)this.identityService.createUserQuery().singleResult());
        IdentityServiceAuthorizationsTest.assertEquals((long)1L, (long)this.identityService.createUserQuery().count());
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        ourPerms = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.USER).userIdIn(new String[]{authUserId}).singleResult();
        ourPerms.removePermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(ourPerms);
        Authorization revoke = this.authorizationService.createNewAuthorization(2);
        revoke.setUserId(authUserId);
        revoke.setResource((Resource)Resources.USER);
        revoke.setResourceId("*");
        revoke.removePermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(revoke);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        IdentityServiceAuthorizationsTest.assertNull((Object)this.identityService.createUserQuery().singleResult());
        IdentityServiceAuthorizationsTest.assertEquals((long)0L, (long)this.identityService.createUserQuery().count());
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        this.authorizationService.deleteAuthorization(ourPerms.getId());
        this.authorizationService.deleteAuthorization(revoke.getId());
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        IdentityServiceAuthorizationsTest.assertNotNull((Object)this.identityService.createUserQuery().singleResult());
        IdentityServiceAuthorizationsTest.assertEquals((long)1L, (long)this.identityService.createUserQuery().count());
    }

    public void testUserQueryAuthorizationsMultipleGroups() {
        String authUserId = jonny2;
        this.identityService.setAuthenticatedUserId(authUserId);
        User demo = this.identityService.newUser("demo");
        this.identityService.saveUser(demo);
        User mary = this.identityService.newUser("mary");
        this.identityService.saveUser(mary);
        User peter = this.identityService.newUser("peter");
        this.identityService.saveUser(peter);
        User john = this.identityService.newUser("john");
        this.identityService.saveUser(john);
        Group sales = this.identityService.newGroup("sales");
        this.identityService.saveGroup(sales);
        Group accounting = this.identityService.newGroup("accounting");
        this.identityService.saveGroup(accounting);
        Group management = this.identityService.newGroup("management");
        this.identityService.saveGroup(management);
        this.identityService.createMembership("demo", "sales");
        this.identityService.createMembership("demo", "accounting");
        this.identityService.createMembership("demo", "management");
        this.identityService.createMembership("john", "sales");
        this.identityService.createMembership("mary", "accounting");
        this.identityService.createMembership("peter", "management");
        Authorization demoAuth = this.authorizationService.createNewAuthorization(1);
        demoAuth.setUserId("demo");
        demoAuth.setResource((Resource)Resources.USER);
        demoAuth.setResourceId("demo");
        demoAuth.addPermission((Permission)Permissions.ALL);
        this.authorizationService.saveAuthorization(demoAuth);
        Authorization johnAuth = this.authorizationService.createNewAuthorization(1);
        johnAuth.setUserId("john");
        johnAuth.setResource((Resource)Resources.USER);
        johnAuth.setResourceId("john");
        johnAuth.addPermission((Permission)Permissions.ALL);
        this.authorizationService.saveAuthorization(johnAuth);
        Authorization maryAuth = this.authorizationService.createNewAuthorization(1);
        maryAuth.setUserId("mary");
        maryAuth.setResource((Resource)Resources.USER);
        maryAuth.setResourceId("mary");
        maryAuth.addPermission((Permission)Permissions.ALL);
        this.authorizationService.saveAuthorization(maryAuth);
        Authorization peterAuth = this.authorizationService.createNewAuthorization(1);
        peterAuth.setUserId("peter");
        peterAuth.setResource((Resource)Resources.USER);
        peterAuth.setResourceId("peter");
        peterAuth.addPermission((Permission)Permissions.ALL);
        this.authorizationService.saveAuthorization(peterAuth);
        Authorization accAuth = this.authorizationService.createNewAuthorization(1);
        accAuth.setGroupId("accounting");
        accAuth.setResource((Resource)Resources.GROUP);
        accAuth.setResourceId("accounting");
        accAuth.addPermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(accAuth);
        Authorization salesAuth = this.authorizationService.createNewAuthorization(1);
        salesAuth.setGroupId("sales");
        salesAuth.setResource((Resource)Resources.GROUP);
        salesAuth.setResourceId("sales");
        salesAuth.addPermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(salesAuth);
        Authorization manAuth = this.authorizationService.createNewAuthorization(1);
        manAuth.setGroupId("management");
        manAuth.setResource((Resource)Resources.GROUP);
        manAuth.setResourceId("management");
        manAuth.addPermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(manAuth);
        Authorization salesDemoAuth = this.authorizationService.createNewAuthorization(1);
        salesDemoAuth.setGroupId("sales");
        salesDemoAuth.setResource((Resource)Resources.USER);
        salesDemoAuth.setResourceId("demo");
        salesDemoAuth.addPermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(salesDemoAuth);
        Authorization salesJohnAuth = this.authorizationService.createNewAuthorization(1);
        salesJohnAuth.setGroupId("sales");
        salesJohnAuth.setResource((Resource)Resources.USER);
        salesJohnAuth.setResourceId("john");
        salesJohnAuth.addPermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(salesJohnAuth);
        Authorization manDemoAuth = this.authorizationService.createNewAuthorization(1);
        manDemoAuth.setGroupId("management");
        manDemoAuth.setResource((Resource)Resources.USER);
        manDemoAuth.setResourceId("demo");
        manDemoAuth.addPermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(manDemoAuth);
        Authorization manPeterAuth = this.authorizationService.createNewAuthorization(1);
        manPeterAuth.setGroupId("management");
        manPeterAuth.setResource((Resource)Resources.USER);
        manPeterAuth.setResourceId("peter");
        manPeterAuth.addPermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(manPeterAuth);
        Authorization accDemoAuth = this.authorizationService.createNewAuthorization(1);
        accDemoAuth.setGroupId("accounting");
        accDemoAuth.setResource((Resource)Resources.USER);
        accDemoAuth.setResourceId("demo");
        accDemoAuth.addPermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(accDemoAuth);
        Authorization accMaryAuth = this.authorizationService.createNewAuthorization(1);
        accMaryAuth.setGroupId("accounting");
        accMaryAuth.setResource((Resource)Resources.USER);
        accMaryAuth.setResourceId("mary");
        accMaryAuth.addPermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(accMaryAuth);
        ArrayList<String> groups = new ArrayList<String>();
        groups.add("management");
        groups.add("accounting");
        groups.add("sales");
        this.identityService.setAuthentication("demo", groups);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        List salesUser = this.identityService.createUserQuery().memberOfGroup("sales").list();
        IdentityServiceAuthorizationsTest.assertEquals((int)2, (int)salesUser.size());
        for (User user : salesUser) {
            if (user.getId().equals("demo") || user.getId().equals("john")) continue;
            Assert.fail((String)("Unexpected user for group sales: " + user.getId()));
        }
        List accountingUser = this.identityService.createUserQuery().memberOfGroup("accounting").list();
        IdentityServiceAuthorizationsTest.assertEquals((int)2, (int)accountingUser.size());
        for (User user : accountingUser) {
            if (user.getId().equals("demo") || user.getId().equals("mary")) continue;
            Assert.fail((String)("Unexpected user for group accounting: " + user.getId()));
        }
        List managementUser = this.identityService.createUserQuery().memberOfGroup("management").list();
        IdentityServiceAuthorizationsTest.assertEquals((int)2, (int)managementUser.size());
        for (User user : managementUser) {
            if (user.getId().equals("demo") || user.getId().equals("peter")) continue;
            Assert.fail((String)("Unexpected user for group managment: " + user.getId()));
        }
    }

    public void testGroupQueryAuthorizations() {
        String authUserId = jonny2;
        this.identityService.setAuthenticatedUserId(authUserId);
        User jonny1 = this.identityService.newUser("jonny1");
        this.identityService.saveUser(jonny1);
        Group group1 = this.identityService.newGroup("group1");
        this.identityService.saveGroup(group1);
        Authorization basePerms = this.authorizationService.createNewAuthorization(0);
        basePerms.setResource((Resource)Resources.GROUP);
        basePerms.setResourceId("*");
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        IdentityServiceAuthorizationsTest.assertNull((Object)this.identityService.createGroupQuery().singleResult());
        IdentityServiceAuthorizationsTest.assertEquals((long)0L, (long)this.identityService.createGroupQuery().count());
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        Authorization ourPerms = this.authorizationService.createNewAuthorization(1);
        ourPerms.setUserId(authUserId);
        ourPerms.setResource((Resource)Resources.GROUP);
        ourPerms.setResourceId("*");
        ourPerms.addPermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(ourPerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        IdentityServiceAuthorizationsTest.assertNotNull((Object)this.identityService.createGroupQuery().singleResult());
        IdentityServiceAuthorizationsTest.assertEquals((long)1L, (long)this.identityService.createGroupQuery().count());
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        basePerms = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.GROUP).userIdIn(new String[]{"*"}).singleResult();
        basePerms.addPermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(basePerms);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        IdentityServiceAuthorizationsTest.assertNotNull((Object)this.identityService.createGroupQuery().singleResult());
        IdentityServiceAuthorizationsTest.assertEquals((long)1L, (long)this.identityService.createGroupQuery().count());
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        ourPerms = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.GROUP).userIdIn(new String[]{authUserId}).singleResult();
        ourPerms.removePermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(ourPerms);
        Authorization revoke = this.authorizationService.createNewAuthorization(2);
        revoke.setUserId(authUserId);
        revoke.setResource((Resource)Resources.GROUP);
        revoke.setResourceId("*");
        revoke.removePermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(revoke);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        IdentityServiceAuthorizationsTest.assertNull((Object)this.identityService.createGroupQuery().singleResult());
        IdentityServiceAuthorizationsTest.assertEquals((long)0L, (long)this.identityService.createGroupQuery().count());
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        this.authorizationService.deleteAuthorization(ourPerms.getId());
        this.authorizationService.deleteAuthorization(revoke.getId());
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        IdentityServiceAuthorizationsTest.assertNotNull((Object)this.identityService.createGroupQuery().singleResult());
        IdentityServiceAuthorizationsTest.assertEquals((long)1L, (long)this.identityService.createGroupQuery().count());
    }

    protected void cleanupAfterTest() {
        for (Group group : this.identityService.createGroupQuery().list()) {
            this.identityService.deleteGroup(group.getId());
        }
        for (User user : this.identityService.createUserQuery().list()) {
            this.identityService.deleteUser(user.getId());
        }
        for (Authorization authorization : this.authorizationService.createAuthorizationQuery().list()) {
            this.authorizationService.deleteAuthorization(authorization.getId());
        }
    }
}

