/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.CaseInstanceQuery;

public class CaseInstanceQueryTest
extends PluggableProcessEngineTestCase {
    private static String CASE_DEFINITION_KEY = "oneTaskCase";
    private static String CASE_DEFINITION_KEY_2 = "oneTaskCase2";
    private List<String> caseInstanceIds;

    protected void setUp() throws Exception {
        super.setUp();
        this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn").addClasspathResource("org/camunda/bpm/engine/test/api/cmmn/oneTaskCase2.cmmn").deploy();
        this.caseInstanceIds = new ArrayList<String>();
        for (int i = 0; i < 4; ++i) {
            String id = this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).businessKey(String.valueOf(i)).create().getId();
            this.caseInstanceIds.add(id);
        }
        String id = this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY_2).businessKey("1").create().getId();
        this.caseInstanceIds.add(id);
    }

    protected void tearDown() throws Exception {
        for (Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
        super.tearDown();
    }

    private void verifyQueryResults(CaseInstanceQuery query, int countExpected) {
        CaseInstanceQueryTest.assertEquals((int)countExpected, (int)query.list().size());
        CaseInstanceQueryTest.assertEquals((long)countExpected, (long)query.count());
        if (countExpected == 1) {
            CaseInstanceQueryTest.assertNotNull((Object)query.singleResult());
        } else if (countExpected > 1) {
            this.verifySingleResultFails(query);
        } else if (countExpected == 0) {
            CaseInstanceQueryTest.assertNull((Object)query.singleResult());
        }
    }

    private void verifySingleResultFails(CaseInstanceQuery query) {
        try {
            query.singleResult();
            CaseInstanceQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testCaseInstanceProperties() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(CASE_DEFINITION_KEY_2).singleResult()).getId();
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().caseDefinitionKey(CASE_DEFINITION_KEY_2).singleResult();
        CaseInstanceQueryTest.assertNotNull((Object)caseInstance.getId());
        CaseInstanceQueryTest.assertEquals((String)caseInstance.getId(), (String)caseInstance.getCaseInstanceId());
        CaseInstanceQueryTest.assertEquals((String)"1", (String)caseInstance.getBusinessKey());
        CaseInstanceQueryTest.assertEquals((String)caseDefinitionId, (String)caseInstance.getCaseDefinitionId());
        CaseInstanceQueryTest.assertTrue((boolean)caseInstance.isActive());
        CaseInstanceQueryTest.assertFalse((boolean)caseInstance.isEnabled());
    }

    public void testQueryWithoutQueryParameter() {
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        this.verifyQueryResults(query, 5);
    }

    public void testQueryByCaseDefinitionKey() {
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.caseDefinitionKey(CASE_DEFINITION_KEY_2);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidCaseDefinitionKey() {
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.caseDefinitionKey("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseDefinitionKey(null);
            CaseInstanceQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByCaseDefinitionId() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(CASE_DEFINITION_KEY).singleResult()).getId();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.caseDefinitionId(caseDefinitionId);
        this.verifyQueryResults(query, 4);
    }

    public void testQueryByInvalidCaseDefinitionId() {
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.caseDefinitionId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseDefinitionId(null);
            CaseInstanceQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByActive() {
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.active();
        this.verifyQueryResults(query, 5);
    }

    public void testQueryByCompleted() {
        List executions = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").list();
        for (CaseExecution caseExecution : executions) {
            this.caseService.withCaseExecution(caseExecution.getId()).disable();
        }
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.completed();
        this.verifyQueryResults(query, 5);
    }

    public void testQueryByCaseInstanceBusinessKey() {
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.caseInstanceBusinessKey("1");
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByInvalidCaseInstanceBusinessKey() {
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.caseInstanceBusinessKey("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseInstanceBusinessKey(null);
            CaseInstanceQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByCaseInstanceBusinessKeyAndCaseDefinitionKey() {
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.caseInstanceBusinessKey("0").caseDefinitionKey(CASE_DEFINITION_KEY);
        this.verifyQueryResults(query, 1);
        query.caseInstanceBusinessKey("1").caseDefinitionKey(CASE_DEFINITION_KEY);
        this.verifyQueryResults(query, 1);
        query.caseInstanceBusinessKey("2").caseDefinitionKey(CASE_DEFINITION_KEY);
        this.verifyQueryResults(query, 1);
        query.caseInstanceBusinessKey("3").caseDefinitionKey(CASE_DEFINITION_KEY);
        this.verifyQueryResults(query, 1);
        query.caseInstanceBusinessKey("1").caseDefinitionKey(CASE_DEFINITION_KEY_2);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByCaseInstanceId() {
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        for (String caseInstanceId : this.caseInstanceIds) {
            query.caseInstanceId(caseInstanceId);
            this.verifyQueryResults(query, 1);
        }
    }

    public void testQueryByInvalidCaseInstanceId() {
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.caseInstanceId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            query.caseInstanceId(null);
            CaseInstanceQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByNullVariableValueEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aNullValue", null).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueEquals("aNullValue", null);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByStringVariableValueEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueEquals("aStringValue", (Object)"abc");
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByBooleanVariableValueEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aBooleanValue", (Object)true).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueEquals("aBooleanValue", (Object)true);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByShortVariableValueEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aShortValue", (Object)123).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueEquals("aShortValue", (Object)123);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByIntegerVariableValueEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("anIntegerValue", (Object)456).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueEquals("anIntegerValue", (Object)456);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByLongVariableValueEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aLongValue", (Object)789L).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueEquals("aLongValue", (Object)789L);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByDateVariableValueEquals() {
        Date now = new Date();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDateValue", (Object)now).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueEquals("aDateValue", (Object)now);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByDoubleVariableValueEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDoubleValue", (Object)1.5).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueEquals("aDoubleValue", (Object)1.5);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByByteArrayVariableValueEquals() {
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aByteArrayValue", (Object)bytes).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueEquals("aByteArrayValue", (Object)bytes).list();
            CaseInstanceQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryBySerializableVariableValueEquals() {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aSerializableValue", serializable).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueEquals("aSerializableValue", serializable).list();
            CaseInstanceQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByStringVariableValueNotEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueNotEquals("aStringValue", (Object)"abd");
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByBooleanVariableValueNotEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aBooleanValue", (Object)true).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueNotEquals("aBooleanValue", (Object)false);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByShortVariableValueNotEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aShortValue", (Object)123).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueNotEquals("aShortValue", (Object)124);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByIntegerVariableValueNotEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("anIntegerValue", (Object)456).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueNotEquals("anIntegerValue", (Object)457);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByLongVariableValueNotEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aLongValue", (Object)789L).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueNotEquals("aLongValue", (Object)790L);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByDateVariableValueNotEquals() {
        Date now = new Date();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDateValue", (Object)now).create();
        Date before = new Date(now.getTime() - 100000L);
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueNotEquals("aDateValue", (Object)before);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByDoubleVariableValueNotEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDoubleValue", (Object)1.5).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueNotEquals("aDoubleValue", (Object)1.6);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByByteArrayVariableValueNotEquals() {
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aByteArrayValue", (Object)bytes).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueNotEquals("aByteArrayValue", (Object)bytes).list();
            CaseInstanceQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryBySerializableVariableValueNotEquals() {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aSerializableValue", serializable).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueNotEquals("aSerializableValue", serializable).list();
            CaseInstanceQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByNullVariableValueGreaterThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aNullValue", null).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueGreaterThan("aNullValue", null).list();
            CaseInstanceQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByStringVariableValueGreaterThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueGreaterThan("aStringValue", (Object)"ab");
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByBooleanVariableValueGreaterThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aBooleanValue", (Object)true).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueGreaterThan("aBooleanValue", (Object)false).list();
            CaseInstanceQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByShortVariableValueGreaterThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aShortValue", (Object)123).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueGreaterThan("aShortValue", (Object)122);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByIntegerVariableValueGreaterThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("anIntegerValue", (Object)456).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueGreaterThan("anIntegerValue", (Object)455);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByLongVariableValueGreaterThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aLongValue", (Object)789L).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueGreaterThan("aLongValue", (Object)788L);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByDateVariableValueGreaterThan() {
        Date now = new Date();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDateValue", (Object)now).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        Date before = new Date(now.getTime() - 100000L);
        query.variableValueGreaterThan("aDateValue", (Object)before);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByDoubleVariableValueGreaterThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDoubleValue", (Object)1.5).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueGreaterThan("aDoubleValue", (Object)1.4);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByByteArrayVariableValueGreaterThan() {
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aByteArrayValue", (Object)bytes).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueGreaterThan("aByteArrayValue", (Object)bytes).list();
            CaseInstanceQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryBySerializableVariableGreaterThan() {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aSerializableValue", serializable).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueGreaterThan("aSerializableValue", serializable).list();
            CaseInstanceQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByNullVariableValueGreaterThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aNullValue", null).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueGreaterThanOrEqual("aNullValue", null).list();
            CaseInstanceQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByStringVariableValueGreaterThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueGreaterThanOrEqual("aStringValue", (Object)"ab");
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseInstanceQuery();
        query.variableValueGreaterThanOrEqual("aStringValue", (Object)"abc");
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByBooleanVariableValueGreaterThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aBooleanValue", (Object)true).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueGreaterThanOrEqual("aBooleanValue", (Object)false).list();
            CaseInstanceQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByShortVariableValueGreaterThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aShortValue", (Object)123).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueGreaterThanOrEqual("aShortValue", (Object)122);
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseInstanceQuery();
        query.variableValueGreaterThanOrEqual("aShortValue", (Object)123);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByIntegerVariableValueGreaterThanOrEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("anIntegerValue", (Object)456).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueGreaterThanOrEqual("anIntegerValue", (Object)455);
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseInstanceQuery();
        query.variableValueGreaterThanOrEqual("anIntegerValue", (Object)456);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByLongVariableValueGreaterThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aLongValue", (Object)789L).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueGreaterThanOrEqual("aLongValue", (Object)788L);
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseInstanceQuery();
        query.variableValueGreaterThanOrEqual("aLongValue", (Object)789L);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByDateVariableValueGreaterThanOrEqual() {
        Date now = new Date();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDateValue", (Object)now).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        Date before = new Date(now.getTime() - 100000L);
        query.variableValueGreaterThanOrEqual("aDateValue", (Object)before);
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseInstanceQuery();
        query.variableValueGreaterThanOrEqual("aDateValue", (Object)now);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByDoubleVariableValueGreaterThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDoubleValue", (Object)1.5).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueGreaterThanOrEqual("aDoubleValue", (Object)1.4);
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseInstanceQuery();
        query.variableValueGreaterThanOrEqual("aDoubleValue", (Object)1.5);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByByteArrayVariableValueGreaterThanOrEqual() {
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aByteArrayValue", (Object)bytes).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueGreaterThanOrEqual("aByteArrayValue", (Object)bytes).list();
            CaseInstanceQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryBySerializableVariableGreaterThanOrEqual() {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aSerializableValue", serializable).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueGreaterThanOrEqual("aSerializableValue", serializable).list();
            CaseInstanceQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByNullVariableValueLessThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aNullValue", null).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueLessThan("aNullValue", null).list();
            CaseInstanceQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByStringVariableValueLessThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueLessThan("aStringValue", (Object)"abd");
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByBooleanVariableValueLessThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aBooleanValue", (Object)true).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueLessThan("aBooleanValue", (Object)false).list();
            CaseInstanceQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByShortVariableValueLessThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aShortValue", (Object)123).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueLessThan("aShortValue", (Object)124);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByIntegerVariableValueLessThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("anIntegerValue", (Object)456).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueLessThan("anIntegerValue", (Object)457);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByLongVariableValueLessThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aLongValue", (Object)789L).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueLessThan("aLongValue", (Object)790L);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByDateVariableValueLessThan() {
        Date now = new Date();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDateValue", (Object)now).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        Date after = new Date(now.getTime() + 100000L);
        query.variableValueLessThan("aDateValue", (Object)after);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByDoubleVariableValueLessThan() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDoubleValue", (Object)1.5).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueLessThan("aDoubleValue", (Object)1.6);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByByteArrayVariableValueLessThan() {
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aByteArrayValue", (Object)bytes).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueLessThan("aByteArrayValue", (Object)bytes).list();
            CaseInstanceQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryBySerializableVariableLessThan() {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aSerializableValue", serializable).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueLessThan("aSerializableValue", serializable).list();
            CaseInstanceQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByNullVariableValueLessThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aNullValue", null).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueLessThanOrEqual("aNullValue", null).list();
            CaseInstanceQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByStringVariableValueLessThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueLessThanOrEqual("aStringValue", (Object)"abd");
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseInstanceQuery();
        query.variableValueLessThanOrEqual("aStringValue", (Object)"abc");
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByBooleanVariableValueLessThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aBooleanValue", (Object)true).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueLessThanOrEqual("aBooleanValue", (Object)false).list();
            CaseInstanceQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByShortVariableValueLessThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aShortValue", (Object)123).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueLessThanOrEqual("aShortValue", (Object)124);
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseInstanceQuery();
        query.variableValueLessThanOrEqual("aShortValue", (Object)123);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByIntegerVariableValueLessThanOrEquals() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("anIntegerValue", (Object)456).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueLessThanOrEqual("anIntegerValue", (Object)457);
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseInstanceQuery();
        query.variableValueLessThanOrEqual("anIntegerValue", (Object)456);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByLongVariableValueLessThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aLongValue", (Object)789L).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueLessThanOrEqual("aLongValue", (Object)790L);
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseInstanceQuery();
        query.variableValueLessThanOrEqual("aLongValue", (Object)789L);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByDateVariableValueLessThanOrEqual() {
        Date now = new Date();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDateValue", (Object)now).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        Date after = new Date(now.getTime() + 100000L);
        query.variableValueLessThanOrEqual("aDateValue", (Object)after);
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseInstanceQuery();
        query.variableValueLessThanOrEqual("aDateValue", (Object)now);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByDoubleVariableValueLessThanOrEqual() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aDoubleValue", (Object)1.5).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueLessThanOrEqual("aDoubleValue", (Object)1.6);
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseInstanceQuery();
        query.variableValueLessThanOrEqual("aDoubleValue", (Object)1.5);
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByByteArrayVariableValueLessThanOrEqual() {
        byte[] bytes = "somebytes".getBytes();
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aByteArrayValue", (Object)bytes).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueLessThanOrEqual("aByteArrayValue", (Object)bytes).list();
            CaseInstanceQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryBySerializableVariableLessThanOrEqual() {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("one");
        serializable.add("two");
        serializable.add("three");
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aSerializableValue", serializable).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueLessThanOrEqual("aSerializableValue", serializable).list();
            CaseInstanceQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByNullVariableValueLike() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aNullValue", null).create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        try {
            query.variableValueLike("aNullValue", null).list();
            CaseInstanceQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByStringVariableValueLike() {
        this.caseService.withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariable("aStringValue", (Object)"abc").create();
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.variableValueLike("aStringValue", "ab%");
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseInstanceQuery();
        query.variableValueLike("aStringValue", "%bc");
        this.verifyQueryResults(query, 1);
        query = this.caseService.createCaseInstanceQuery();
        query.variableValueLike("aStringValue", "%b%");
        this.verifyQueryResults(query, 1);
    }

    public void testQuerySorting() {
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        query.orderByCaseDefinitionId().asc();
        this.verifyQueryResults(query, 5);
        query = this.caseService.createCaseInstanceQuery();
        query.orderByCaseDefinitionKey().asc();
        this.verifyQueryResults(query, 5);
        query = this.caseService.createCaseInstanceQuery();
        query.orderByCaseInstanceId().asc();
        this.verifyQueryResults(query, 5);
        query = this.caseService.createCaseInstanceQuery();
        query.orderByCaseDefinitionId().desc();
        this.verifyQueryResults(query, 5);
        query = this.caseService.createCaseInstanceQuery();
        query.orderByCaseDefinitionKey().desc();
        this.verifyQueryResults(query, 5);
        query = this.caseService.createCaseInstanceQuery();
        query.orderByCaseInstanceId().desc();
        this.verifyQueryResults(query, 5);
        query = this.caseService.createCaseInstanceQuery();
    }
}

